/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.control.AbstractTee;
import adams.flow.control.Branch;
import adams.flow.control.LoadBalancer;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandler;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CleanUpProcessor;
import java.lang.reflect.Array;

public class FlattenStructure
extends AbstractModifyingProcessor
implements CleanUpProcessor {
    private static final long serialVersionUID = -5327018527621230693L;

    @Override
    public String globalInfo() {
        return "Tries to flatten the flow structure wherever possible.";
    }

    @Override
    protected void processActor(AbstractActor actor) {
        actor.getOptionManager().traverse(new OptionTraverser(){

            protected void flattenTee(AbstractTee tee) {
                AbstractActor[] actors = ((Sequence)tee.get(0)).getActors();
                tee.setActors(actors);
                FlattenStructure.this.m_Modified = true;
            }

            protected void flattenLoadBalancer(LoadBalancer load) {
                AbstractActor[] actors = ((Sequence)load.get(0)).getActors();
                load.setLoadActors(actors);
                FlattenStructure.this.m_Modified = true;
            }

            protected void flattenBranch(Branch branch) {
                ActorHandler parent = (ActorHandler)((Object)branch.getParent());
                int index = parent.indexOf(branch.getName());
                parent.set(index, branch.getBranches()[0]);
                branch.setParent(null);
                FlattenStructure.this.m_Modified = true;
            }

            protected void flatten(Object current) {
                Branch branch;
                if (current instanceof AbstractTee) {
                    AbstractTee tee = (AbstractTee)current;
                    if (tee.size() == 1 && tee.get(0) instanceof Sequence) {
                        this.flattenTee(tee);
                    }
                } else if (current instanceof LoadBalancer) {
                    LoadBalancer load = (LoadBalancer)current;
                    if (load.size() == 1 && load.get(0) instanceof Sequence) {
                        this.flattenLoadBalancer(load);
                    }
                } else if (current instanceof Branch && (branch = (Branch)current).size() == 1) {
                    this.flattenBranch(branch);
                }
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                Object current = option.getCurrentValue();
                if (option.isMultiple()) {
                    for (int i = 0; i < Array.getLength(current); ++i) {
                        Object element = Array.get(current, i);
                        this.flatten(element);
                    }
                } else {
                    this.flatten(current);
                }
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        });
        if (this.m_Modified) {
            this.m_ModifiedActor = actor;
        }
    }
}

