/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.core.Token;
import adams.flow.sink.AbstractTextualDisplay;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextEditorPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Display
extends AbstractTextualDisplay {
    private static final long serialVersionUID = -3655490351179936332L;
    protected JMenuItem m_MenuItemFilePrint;
    protected JMenuItem m_MenuItemEditUndo;
    protected JMenuItem m_MenuItemEditRedo;
    protected JMenuItem m_MenuItemEditCut;
    protected JMenuItem m_MenuItemEditCopy;
    protected JMenuItem m_MenuItemEditPaste;
    protected JMenuItem m_MenuItemEditSelectAll;
    protected JMenuItem m_MenuItemEditFind;
    protected JMenuItem m_MenuItemEditFindNext;
    protected JMenuItem m_MenuItemViewFont;

    @Override
    public String globalInfo() {
        return "Actor that outputs any object that arrives at its input port via the 'toString()' method.";
    }

    @Override
    protected int getDefaultWidth() {
        return 640;
    }

    @Override
    protected int getDefaultHeight() {
        return 480;
    }

    @Override
    protected JMenu createFileMenu() {
        JMenu result = super.createFileMenu();
        JMenuItem menuitem = new JMenuItem("Print...");
        menuitem.setMnemonic('P');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed P"));
        menuitem.setIcon(GUIHelper.getIcon("print.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((TextEditorPanel)Display.this.m_Panel).printText();
            }
        });
        int pos = this.indexOfMenuItem(result, this.m_MenuItemFileClose);
        result.insertSeparator(pos);
        result.insert(menuitem, pos);
        this.m_MenuItemFilePrint = menuitem;
        return result;
    }

    protected JMenu createEditMenu() {
        final TextEditorPanel fPanel = (TextEditorPanel)this.m_Panel;
        JMenu result = new JMenu("Edit");
        result.setMnemonic('E');
        result.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Display.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Undo");
        menuitem.setMnemonic('U');
        menuitem.setEnabled(fPanel.canUndo());
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Z"));
        menuitem.setIcon(GUIHelper.getIcon("undo.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.undo();
            }
        });
        result.add(menuitem);
        this.m_MenuItemEditUndo = menuitem;
        menuitem = new JMenuItem("Redo");
        menuitem.setMnemonic('R');
        menuitem.setEnabled(fPanel.canUndo());
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Y"));
        menuitem.setIcon(GUIHelper.getIcon("redo.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.redo();
            }
        });
        result.add(menuitem);
        this.m_MenuItemEditRedo = menuitem;
        menuitem = new JMenuItem("Cut", GUIHelper.getIcon("cut.gif"));
        menuitem.setMnemonic('u');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed X"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.cut();
            }
        });
        result.addSeparator();
        result.add(menuitem);
        this.m_MenuItemEditCut = menuitem;
        menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed C"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.copy();
            }
        });
        result.add(menuitem);
        this.m_MenuItemEditCopy = menuitem;
        menuitem = new JMenuItem("Paste", GUIHelper.getIcon("paste.gif"));
        menuitem.setMnemonic('P');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed V"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.paste();
            }
        });
        result.add(menuitem);
        this.m_MenuItemEditPaste = menuitem;
        menuitem = new JMenuItem("Select all", GUIHelper.getEmptyIcon());
        menuitem.setMnemonic('S');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed A"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.selectAll();
            }
        });
        result.addSeparator();
        result.add(menuitem);
        this.m_MenuItemEditSelectAll = menuitem;
        menuitem = new JMenuItem("Find", GUIHelper.getIcon("find.gif"));
        menuitem.setMnemonic('F');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed F"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.find();
            }
        });
        result.addSeparator();
        result.add(menuitem);
        this.m_MenuItemEditFind = menuitem;
        menuitem = new JMenuItem("Find next", GUIHelper.getEmptyIcon());
        menuitem.setMnemonic('n');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed G"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.findNext();
            }
        });
        result.add(menuitem);
        this.m_MenuItemEditFindNext = menuitem;
        return result;
    }

    protected JMenu createViewMenu() {
        JMenu result = new JMenu("View");
        result.setMnemonic('V');
        result.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Display.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Choose font...");
        result.add(menuitem);
        menuitem.setIcon(GUIHelper.getIcon("font.png"));
        menuitem.setMnemonic('f');
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((TextEditorPanel)Display.this.m_Panel).selectFont();
            }
        });
        this.m_MenuItemViewFont = menuitem;
        return result;
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar result = super.createMenuBar();
        result.add(this.createEditMenu());
        result.add(this.createViewMenu());
        return result;
    }

    @Override
    protected void updateMenu() {
        super.updateMenu();
        TextEditorPanel panel = (TextEditorPanel)this.m_Panel;
        boolean contentAvailable = panel.getContent().length() > 0;
        this.m_MenuItemEditUndo.setEnabled(panel.canUndo());
        this.m_MenuItemEditRedo.setEnabled(panel.canRedo());
        this.m_MenuItemEditCut.setEnabled(panel.canCut());
        this.m_MenuItemEditCopy.setEnabled(panel.canCopy());
        this.m_MenuItemEditPaste.setEnabled(panel.canPaste());
        this.m_MenuItemEditFind.setEnabled(contentAvailable);
        this.m_MenuItemEditFindNext.setEnabled(contentAvailable && panel.getLastFind() != null);
    }

    @Override
    public void clearPanel() {
        ((TextEditorPanel)this.m_Panel).clear();
    }

    @Override
    protected BasePanel newPanel() {
        TextEditorPanel result = new TextEditorPanel();
        result.setTextFont(this.getFont());
        return result;
    }

    @Override
    public String supplyText() {
        String result = null;
        TextEditorPanel panel = (TextEditorPanel)this.m_Panel;
        if (panel.getContent().length() != 0) {
            result = panel.getContent();
        }
        return result;
    }

    @Override
    protected boolean supportsClear() {
        return true;
    }

    @Override
    protected void clear() {
        ((TextEditorPanel)this.m_Panel).clear();
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    @Override
    protected void display(Token token) {
        TextEditorPanel panel = (TextEditorPanel)this.m_Panel;
        panel.append(token.getPayload() + "\n");
        panel.setModified(false);
    }
}

