/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.option.OptionUtils;
import adams.data.conversion.AnyToString;
import adams.data.conversion.ConversionToString;
import adams.flow.sink.AbstractSink;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.Hashtable;

public class Exec
extends AbstractSink {
    private static final long serialVersionUID = -5040421332565191432L;
    public static final String BACKUP_PROCESS = "process";
    public static final String BACKUP_WRITER = "writer";
    protected String m_Command;
    protected ConversionToString m_Conversion;
    protected Process m_Process;
    protected BufferedWriter m_Writer;

    @Override
    public String globalInfo() {
        return "Pipes the incoming data, after converting it using the provided conversion scheme, into the started process.\nNB: no errors are currently output.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cmd", "command", "mysql test");
        this.m_OptionManager.add("conversion", "conversion", new AnyToString());
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("command");
        if (variable != null) {
            return variable;
        }
        if (this.m_Command != null && this.m_Command.length() != 0) {
            return this.m_Command;
        }
        return null;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_Process != null) {
            result.put(BACKUP_PROCESS, this.m_Process);
        }
        if (this.m_Writer != null) {
            result.put(BACKUP_WRITER, this.m_Writer);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_PROCESS)) {
            this.m_Process = (Process)state.get(BACKUP_PROCESS);
            state.remove(BACKUP_PROCESS);
        }
        if (state.containsKey(BACKUP_WRITER)) {
            this.m_Writer = (BufferedWriter)state.get(BACKUP_WRITER);
            state.remove(BACKUP_WRITER);
        }
        super.restoreState(state);
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_PROCESS);
        this.pruneBackup(BACKUP_WRITER);
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The external command to pipe the data into.";
    }

    public void setConversion(ConversionToString value) {
        this.m_Conversion = value;
        this.reset();
    }

    public ConversionToString getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion scheme to apply to the input tokens.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{this.m_Conversion.accepts()};
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_Process == null) {
            try {
                String[] cmd = OptionUtils.splitOptions(this.m_Command);
                this.m_Process = Runtime.getRuntime().exec(cmd);
                this.m_Writer = new BufferedWriter(new OutputStreamWriter(this.m_Process.getOutputStream()));
            }
            catch (Exception e) {
                this.m_Writer = null;
                this.getSystemErr().println("Failed to execute command: " + this.m_Command);
                this.getSystemErr().printStackTrace(e);
            }
        }
        if (this.m_Writer != null) {
            this.m_Conversion.setInput(this.m_InputToken.getPayload());
            String msg = this.m_Conversion.convert();
            if (msg == null) {
                try {
                    this.m_Writer.write((String)this.m_Conversion.getOutput());
                    this.m_Writer.newLine();
                    this.m_Writer.flush();
                }
                catch (Exception e) {
                    this.getSystemErr().println("Failed to pipe data:");
                    this.getSystemErr().printStackTrace(e);
                }
            } else {
                result = "Failed to convert token: " + msg;
            }
        }
        return result;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        if (this.m_Writer != null) {
            try {
                this.m_Writer.close();
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to close pipe:");
                this.getSystemErr().printStackTrace(e);
            }
            this.m_Writer = null;
        }
    }
}

