/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.NamedCounter;
import adams.core.io.AbstractSpreadSheetWriter;
import adams.core.io.CsvSpreadSheetWriter;
import adams.core.io.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.sink.AbstractFileWriter;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Hashtable;

public class PlotContainerSink
extends AbstractFileWriter {
    private static final long serialVersionUID = 3238389451500168650L;
    public static final String BACKUP_SPREADSHEET = "spreadsheet";
    public static final String BACKUP_TOKENCOUNTS = "token counts";
    public static final String COLUMN_X = "x";
    protected AbstractSpreadSheetWriter m_Writer;
    protected SpreadSheet m_SpreadSheet;
    protected NamedCounter m_TokenCounts;
    protected DoubleComparator m_Comparator;

    @Override
    public String globalInfo() {
        return "Actor that outputs the plot containers in various formats.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", new CsvSpreadSheetWriter());
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("writer");
        if (variable != null) {
            return variable;
        }
        if (this.m_Writer != null) {
            return this.m_Writer.getClass().getName().replace("adams.core.io.", "");
        }
        return null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_SpreadSheet = new SpreadSheet();
        this.m_TokenCounts = new NamedCounter();
        this.m_Comparator = new DoubleComparator();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_SpreadSheet = new SpreadSheet();
        this.m_SpreadSheet.getHeaderRow().addCell(COLUMN_X).setContent(COLUMN_X);
        this.m_TokenCounts.clear();
    }

    @Override
    public String outputFileTipText() {
        return "The file to save the generated output to.";
    }

    public void setWriter(AbstractSpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractSpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for outputting the plot containers.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_SPREADSHEET);
        this.pruneBackup(BACKUP_TOKENCOUNTS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_SPREADSHEET, this.m_SpreadSheet);
        result.put(BACKUP_TOKENCOUNTS, this.m_TokenCounts);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_SPREADSHEET)) {
            this.m_SpreadSheet = (SpreadSheet)state.get(BACKUP_SPREADSHEET);
            state.remove(BACKUP_SPREADSHEET);
        }
        if (state.containsKey(BACKUP_TOKENCOUNTS)) {
            this.m_TokenCounts = (NamedCounter)state.get(BACKUP_TOKENCOUNTS);
            state.remove(BACKUP_TOKENCOUNTS);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{SequencePlotterContainer.class};
    }

    @Override
    protected String doExecute() {
        String rowKey;
        String result = null;
        SequencePlotterContainer cont = (SequencePlotterContainer)this.m_InputToken.getPayload();
        String name = (String)cont.getValue("PlotName");
        Double x = (Double)cont.getValue("X");
        Double y = (Double)cont.getValue("Y");
        this.m_TokenCounts.next(name);
        SpreadSheet.Row row = this.m_SpreadSheet.getHeaderRow();
        if (!row.hasCell(name)) {
            row.addCell(name).setContent(name);
        }
        if (x == null) {
            x = new Double(this.m_TokenCounts.current(name));
        }
        if (this.m_SpreadSheet.hasRow(rowKey = "" + x)) {
            row = this.m_SpreadSheet.getRow(rowKey);
        } else {
            row = this.m_SpreadSheet.addRow(rowKey);
            row.addCell(COLUMN_X).setContent(x);
        }
        if (!row.hasCell(name)) {
            row.addCell(name).setContent(y);
        } else {
            row.getCell(name).setContent(y);
        }
        this.m_SpreadSheet.sort(this.m_Comparator);
        if (!this.m_Writer.write(this.m_SpreadSheet, this.m_OutputFile)) {
            result = "Failed to write plot data to '" + this.m_OutputFile + "'!";
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_SpreadSheet = null;
        if (this.m_TokenCounts != null) {
            this.m_TokenCounts.clear();
        }
        this.m_TokenCounts = null;
        super.wrapUp();
    }

    public static class DoubleComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 4012515986361784010L;

        @Override
        public int compare(String o1, String o2) {
            Double d1 = new Double(o1);
            Double d2 = new Double(o2);
            return d1.compareTo(d2);
        }
    }
}

