/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.logview;

import adams.core.Properties;
import adams.core.ShallowCopySupporter;
import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.db.LogEntry;
import adams.flow.sink.LogViewer;
import adams.gui.core.BaseDialog;
import java.util.Collections;
import java.util.Vector;

public abstract class AbstractLogEntryDialog
extends AbstractOptionHandler
implements ShallowCopySupporter<AbstractLogEntryDialog> {
    private static final long serialVersionUID = -1693243371323850638L;
    protected int m_Width;
    protected int m_Height;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", this.getDefaultWidth(), 1, null);
        this.m_OptionManager.add("height", "height", this.getDefaultHeight(), 1, null);
    }

    protected int getDefaultWidth() {
        return 600;
    }

    protected int getDefaultHeight() {
        return 400;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the dialog.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the dialog.";
    }

    protected String getDefaultTitle() {
        return "Log entry";
    }

    protected String toString(LogEntry entry) {
        StringBuilder result = new StringBuilder();
        Properties props = entry.getMessageAsProperties();
        Vector<String> keys = new Vector<String>(props.keySetAll());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            if (i > 0) {
                result.append("\n");
            }
            result.append(keys.get(i) + ":\n");
            result.append(Utils.indent(props.getProperty(keys.get(i)), 3));
        }
        return result.toString();
    }

    protected String createTitle(LogEntry entry) {
        String result = this.getDefaultTitle() + " - ";
        result = entry.getDatabaseID() != -1 ? result + "DB #" + entry.getDatabaseID() : result + "Time " + entry.getGenerationAsString();
        return result;
    }

    protected void preCreateDialog(LogViewer parent, LogEntry entry) {
    }

    protected abstract BaseDialog createDialog(LogEntry var1);

    protected void postCreateDialog(LogViewer parent, LogEntry entry) {
    }

    public BaseDialog create(LogViewer parent, LogEntry entry) {
        if (this.isDebugOn()) {
            this.debug("creating dialog: " + entry.toString());
        }
        this.preCreateDialog(parent, entry);
        BaseDialog result = this.createDialog(entry);
        result.setSize(this.m_Width, this.m_Height);
        this.postCreateDialog(parent, entry);
        return result;
    }

    @Override
    public AbstractLogEntryDialog shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractLogEntryDialog shallowCopy(boolean expand) {
        return (AbstractLogEntryDialog)OptionUtils.shallowCopy(this, expand);
    }
}

