/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.GlobalActorsHandler;
import adams.flow.core.InputConsumer;
import adams.flow.sink.AbstractDisplay;
import adams.flow.sink.AbstractSink;
import adams.flow.sink.ComponentSupplier;
import adams.flow.sink.GlobalSink;
import adams.flow.sink.SequencePlotter;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.print.JComponentWriter;
import adams.gui.print.JComponentWriterFileChooser;
import adams.gui.print.PNGWriter;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GridView
extends adams.flow.core.AbstractDisplay
implements GlobalActorsHandler,
MenuBarProvider,
ComponentSupplier,
SendToActionSupporter {
    private static final long serialVersionUID = -4454052058077687116L;
    protected Vector<AbstractActor> m_Actors;
    protected Vector<GridViewWrapper> m_Wrappers;
    protected Vector<BasePanel> m_Panels;
    protected int m_NumRows;
    protected int m_NumCols;
    protected JComponentWriter m_Writer;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected transient JComponentWriterFileChooser m_GraphicFileChooser;

    @Override
    public String globalInfo() {
        return "Displays multiple graphical actors in a grid. The actors get added row-wise to the grid from top-left to bottom-right. The actors can be referenced in the flow using " + GlobalSink.class.getName() + " actors.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-rows", "numRows", 1, 1, null);
        this.m_OptionManager.add("num-cols", "numCols", 1, 1, null);
        this.m_OptionManager.add("actor", "actors", new AbstractActor[0]);
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + ", Rows: ";
        String variable = this.getOptionManager().getVariableForProperty("numRows");
        result = variable != null ? result + variable : result + this.m_NumRows;
        result = result + ", Cols: ";
        variable = this.getOptionManager().getVariableForProperty("numCols");
        result = variable != null ? result + variable : result + this.m_NumCols;
        return result;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Actors = new Vector();
        this.m_Wrappers = null;
        this.m_Panels = null;
    }

    public void setNumRows(int value) {
        this.m_NumRows = value;
        this.reset();
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of rows in the grid.";
    }

    public void setNumCols(int value) {
        this.m_NumCols = value;
        this.reset();
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public String numColsTipText() {
        return "The number of columns in the grid.";
    }

    public void setActors(AbstractActor[] value) {
        int i;
        ActorUtils.uniqueNames(value);
        for (i = 0; i < value.length; ++i) {
            String msg = this.check(value[i]);
            if (msg == null) continue;
            this.getSystemErr().println(msg);
            return;
        }
        this.m_Actors.clear();
        for (i = 0; i < value.length; ++i) {
            this.m_Actors.add(value[i]);
        }
        this.updateParent();
        this.reset();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.toArray(new AbstractActor[this.m_Actors.size()]);
    }

    public String actorsTipText() {
        return "The panel-generating actors to display in the grid.";
    }

    protected String check(AbstractActor actor) {
        if (!(actor instanceof adams.flow.core.AbstractDisplay)) {
            return "Actor '" + actor.getName() + "' not derived from " + AbstractDisplay.class.getName() + "!";
        }
        if (!ActorUtils.isSink(actor)) {
            return "Actor '" + actor.getName() + "' is not a sink!";
        }
        return null;
    }

    protected void updateParent() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setParent(null);
            this.get(i).setParent(this);
        }
    }

    @Override
    public void add(AbstractActor actor) {
        String msg = this.check(actor);
        if (msg == null) {
            this.m_Actors.add(actor);
        } else {
            this.getSystemErr().println(msg);
        }
    }

    @Override
    public void add(int index, AbstractActor actor) {
        String msg = this.check(actor);
        if (msg == null) {
            this.m_Actors.add(index, actor);
        } else {
            this.getSystemErr().println(msg);
        }
    }

    @Override
    public AbstractActor remove(int index) {
        return this.m_Actors.remove(index);
    }

    @Override
    public void removeAll() {
        this.m_Actors.clear();
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, false, ActorExecution.PARALLEL, false, new Class[]{AbstractDisplay.class});
    }

    @Override
    public String check() {
        String result = null;
        for (int i = 0; i < this.m_Actors.size() && (result = this.check(this.m_Actors.get(i))) == null; ++i) {
        }
        return result;
    }

    @Override
    public int size() {
        return this.m_Actors.size();
    }

    @Override
    public AbstractActor get(int index) {
        if (this.m_Wrappers != null) {
            return this.m_Wrappers.get(index);
        }
        return this.m_Actors.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        String msg = this.check(actor);
        if (msg == null) {
            this.m_Actors.set(index, actor);
        } else {
            this.getSystemErr().println(msg);
        }
    }

    @Override
    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (!this.m_Actors.get(i).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public AbstractActor firstActive() {
        AbstractActor result = null;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    @Override
    public AbstractActor lastActive() {
        AbstractActor result = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i).getSkip()) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    @Override
    public void clearPanel() {
        for (GridViewWrapper wrapper : this.m_Wrappers) {
            wrapper.clearPanel();
        }
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new GridLayout(this.m_NumRows, this.m_NumCols));
        this.m_Panels = new Vector();
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            BasePanel panel = new BasePanel(new BorderLayout());
            JLabel label = new JLabel(this.m_Actors.get(i).getName(), 0);
            panel.add((Component)label, "Center");
            result.add(panel);
            this.m_Panels.add(panel);
        }
        return result;
    }

    @Override
    protected Runnable newDisplayRunnable() {
        Runnable result = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (GridView.this.m_CreateFrame && !GridView.this.m_Frame.isVisible()) {
                    GridView.this.m_Frame.setVisible(true);
                }
                AbstractActor abstractActor = GridView.this.m_Self;
                synchronized (abstractActor) {
                    GridView.this.m_Self.notifyAll();
                }
                GridView.this.m_Updating = false;
            }
        };
        this.m_InputToken = null;
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        this.m_Wrappers = new Vector();
        for (AbstractActor actor : this.m_Actors) {
            ((adams.flow.core.AbstractDisplay)actor).setCreateFrame(false);
            GridViewWrapper wrapper = new GridViewWrapper();
            wrapper.setParent(this);
            wrapper.setName(actor.getName());
            wrapper.setWrapped(actor);
            result = wrapper.setUp();
            if (result != null) {
                result = "Failed to wrap actor '" + actor.getName() + "': " + result;
                break;
            }
            this.m_Wrappers.add(wrapper);
        }
        return result;
    }

    public void addPanel(AbstractActor actor, BasePanel panel) {
        int index = this.indexOf(actor.getName());
        this.m_Panels.set(index, panel);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                GridView.this.m_Panel.removeAll();
                for (BasePanel p : GridView.this.m_Panels) {
                    GridView.this.m_Panel.add(p);
                }
                GridView.this.m_Panel.validate();
                GridView.this.m_Panel.doLayout();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void stopExecution() {
        if (this.m_Wrappers != null) {
            for (GridViewWrapper wrapper : this.m_Wrappers) {
                wrapper.stopExecution();
            }
        }
        super.stopExecution();
    }

    @Override
    public void wrapUp() {
        if (this.m_Wrappers != null) {
            for (GridViewWrapper wrapper : this.m_Wrappers) {
                wrapper.wrapUp();
            }
        }
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        if (this.m_Wrappers != null) {
            for (GridViewWrapper wrapper : this.m_Wrappers) {
                wrapper.cleanUp();
            }
            this.m_Wrappers.clear();
            this.m_Wrappers = null;
        }
        if (this.m_Panels != null) {
            this.m_Panels.clear();
            this.m_Panels = null;
        }
        super.cleanUp();
    }

    protected JMenuBar createMenuBar() {
        JMenuBar result = new JMenuBar();
        JMenu menu = new JMenu("File");
        result.add(menu);
        menu.setMnemonic('F');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GridView.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Save as...");
        menu.add(menuitem);
        menuitem.setMnemonic('a');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridView.this.saveAs();
            }
        });
        this.m_MenuItemFileSaveAs = menuitem;
        menu.addSeparator();
        if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
            menu.addSeparator();
        }
        menuitem = new JMenuItem("Close");
        menu.add(menuitem);
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
        menuitem.setIcon(GUIHelper.getIcon("exit.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridView.this.close();
            }
        });
        this.m_MenuItemFileClose = menuitem;
        return result;
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            this.m_MenuBar = this.createMenuBar();
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileSaveAs.setEnabled(this.m_Wrappers != null && this.m_Wrappers.size() > 0);
    }

    protected JComponentWriterFileChooser getGraphicFileChooser() {
        if (this.m_GraphicFileChooser == null) {
            this.m_GraphicFileChooser = new JComponentWriterFileChooser();
        }
        return this.m_GraphicFileChooser;
    }

    protected void saveAs() {
        VFSJFileChooser.RETURN_TYPE retVal = this.getGraphicFileChooser().showSaveDialog(this.m_Panel);
        if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        JComponentWriter writer = this.getGraphicFileChooser().getWriter();
        writer.setComponent(this.supplyComponent());
        try {
            writer.toOutput();
        }
        catch (Exception e) {
            this.getSystemErr().println("Error saving panel to '" + writer.getFile() + "': ");
            this.getSystemErr().printStackTrace(e);
        }
    }

    protected void close() {
        this.m_Panel.closeParent();
    }

    @Override
    public JComponent supplyComponent() {
        return this.m_Panel;
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, JComponent.class}, cls) && this.supplyComponent() != null;
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        JComponent comp = this.supplyComponent();
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            if (comp != null) {
                result = SendToActionUtils.nextTmpFile("actor-" + this.getName(), "png");
                PNGWriter writer = new PNGWriter();
                writer.setFile((PlaceholderFile)result);
                writer.setComponent(comp);
                try {
                    writer.generateOutput();
                }
                catch (Exception e) {
                    this.getSystemErr().println("Failed to write image to " + result + ":");
                    this.getSystemErr().printStackTrace(e);
                    result = null;
                }
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
            result = comp;
        }
        return result;
    }

    public static class GridViewWrapper
    extends AbstractSink {
        private static final long serialVersionUID = -1571827759359015717L;
        protected adams.flow.core.AbstractDisplay m_Wrapped;
        protected BasePanel m_Panel;

        @Override
        public String globalInfo() {
            return "Wrapper for sinks to be used in the " + GridView.class.getName() + " sink.";
        }

        @Override
        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("wrapped", "wrapped", new SequencePlotter());
        }

        public void setWrapped(AbstractActor value) {
            this.m_Wrapped = (adams.flow.core.AbstractDisplay)value;
            this.m_Wrapped.setParent(this);
            this.reset();
        }

        public AbstractActor getWrapped() {
            return this.m_Wrapped;
        }

        public String wrappedTipText() {
            return "The actor to wrap.";
        }

        @Override
        public String getQuickInfo() {
            String variable = this.getOptionManager().getVariableForProperty("wrapped");
            if (variable != null) {
                return variable;
            }
            return this.m_Wrapped.getClass().getName();
        }

        @Override
        public Class[] accepts() {
            return ((InputConsumer)((Object)this.m_Wrapped)).accepts();
        }

        @Override
        protected String doExecute() {
            String result = null;
            if (this.m_Panel == null && (result = this.m_Wrapped.execute()) == null) {
                this.m_Panel = this.m_Wrapped.getPanel();
                ((GridView)this.getParent()).addPanel(this.m_Wrapped, this.m_Panel);
            }
            if (result == null) {
                this.m_Wrapped.input(this.m_InputToken);
                result = this.m_Wrapped.execute();
            }
            return result;
        }

        @Override
        public void cleanUp() {
            if (this.m_Panel != null) {
                this.m_Wrapped.clearPanel();
                this.m_Wrapped.cleanUp();
                this.m_Panel = null;
            }
            super.cleanUp();
        }

        public void clearPanel() {
            if (this.m_Panel != null) {
                this.m_Wrapped.clearPanel();
            }
        }
    }
}

