/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractDisplay;
import adams.gui.core.BasePanel;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class Stopwatch
extends AbstractDisplay {
    private static final long serialVersionUID = -6030616525436078513L;
    protected int m_UpdateInterval;
    protected String m_Prefix;
    protected String m_Suffix;
    protected boolean m_ShowSeconds;
    protected Font m_Font;

    @Override
    public String globalInfo() {
        return "Stops the execution time of the flow, till either the user stops the flow or the flow finishes by itself";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("update-interval", "updateInterval", 500, 10, null);
        this.m_OptionManager.add("prefix", "prefix", "");
        this.m_OptionManager.add("suffix", "suffix", "");
        this.m_OptionManager.add("show-seconds", "showSeconds", false);
        this.m_OptionManager.add("font", "font", new Font("monospaced", 0, 16));
    }

    @Override
    public String getQuickInfo() {
        String result = "\"";
        String variable = this.getOptionManager().getVariableForProperty("prefix");
        result = variable != null ? result + variable : result + this.m_Prefix;
        result = result + "0:00";
        if (this.m_ShowSeconds) {
            result = result + ":00";
        }
        result = (variable = this.getOptionManager().getVariableForProperty("suffix")) != null ? result + variable : result + this.m_Suffix;
        result = result + "\", updated every ";
        variable = this.getOptionManager().getVariableForProperty("updateInterval");
        result = variable != null ? result + variable : result + this.m_UpdateInterval;
        result = result + " msecs";
        return result;
    }

    @Override
    protected int getDefaultX() {
        return -3;
    }

    @Override
    protected int getDefaultWidth() {
        return 100;
    }

    @Override
    protected int getDefaultHeight() {
        return 56;
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix text for the time display.";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The suffix text for the time display.";
    }

    public void setShowSeconds(boolean value) {
        this.m_ShowSeconds = value;
        this.reset();
    }

    public boolean getShowSeconds() {
        return this.m_ShowSeconds;
    }

    public String showSecondsTipText() {
        return "If enabled, the seconds are displayed in the stopwatch output as well.";
    }

    public void setUpdateInterval(int value) {
        this.m_UpdateInterval = value;
        this.reset();
    }

    public int getUpdateInterval() {
        return this.m_UpdateInterval;
    }

    public String updateIntervalTipText() {
        return "The wait period in milli-seconds before the stopwatch display is being updated.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for displaying the time.";
    }

    @Override
    public void clearPanel() {
        ((StopwatchPanel)this.m_Panel).resetTimer();
    }

    @Override
    protected BasePanel newPanel() {
        StopwatchPanel result = new StopwatchPanel(this);
        return result;
    }

    @Override
    protected Runnable newDisplayRunnable() {
        Runnable result = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (Stopwatch.this.m_CreateFrame && !Stopwatch.this.m_Frame.isVisible()) {
                    Stopwatch.this.m_Frame.setVisible(true);
                }
                AbstractActor abstractActor = Stopwatch.this.m_Self;
                synchronized (abstractActor) {
                    Stopwatch.this.m_Self.notifyAll();
                }
                Stopwatch.this.m_Updating = false;
            }
        };
        return result;
    }

    @Override
    protected String doExecute() {
        String result = super.doExecute();
        if (!this.m_Headless && result == null) {
            ((StopwatchPanel)this.m_Panel).startTimer();
        }
        return result;
    }

    @Override
    public void stopExecution() {
        if (this.m_Panel != null) {
            ((StopwatchPanel)this.m_Panel).stopTimer();
        }
        super.stopExecution();
    }

    @Override
    public void wrapUp() {
        if (this.m_Panel != null) {
            ((StopwatchPanel)this.m_Panel).stopTimer();
        }
        super.wrapUp();
    }

    public static class StopwatchPanel
    extends BasePanel {
        private static final long serialVersionUID = 1725406518546756466L;
        protected Stopwatch m_Owner;
        protected JLabel m_LabelTime;
        protected long m_StartTime;
        protected Timer m_Timer;

        public StopwatchPanel(Stopwatch owner) {
            this.m_Owner = owner;
            this.setTimeFont(this.getOwner().getFont());
            this.updateTime(0L);
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new FlowLayout(2));
            this.m_LabelTime = new JLabel();
            this.add(this.m_LabelTime);
        }

        public Stopwatch getOwner() {
            return this.m_Owner;
        }

        public void setTimeFont(Font value) {
            this.m_LabelTime.setFont(value);
        }

        public Font getTimeFont() {
            return this.m_LabelTime.getFont();
        }

        public void updateTime(long time) {
            long hours = (time /= 1000L) / 3600L;
            long mins = (time %= 3600L) / 60L;
            long secs = time %= 60L;
            StringBuilder text = new StringBuilder();
            text.append(this.getOwner().getPrefix());
            text.append(hours);
            text.append(":");
            if (mins < 10L) {
                text.append(0);
            }
            text.append(mins);
            if (this.getOwner().getShowSeconds()) {
                text.append(":");
                if (secs < 10L) {
                    text.append(0);
                }
                text.append(secs);
            }
            text.append(this.getOwner().getSuffix());
            this.m_LabelTime.setText(text.toString());
        }

        public long getStartTime() {
            return this.m_StartTime;
        }

        public void startTimer() {
            if (this.m_Timer == null) {
                this.resetTimer();
                this.m_Timer = new Timer(this);
                new Thread(this.m_Timer).start();
            }
        }

        public void stopTimer() {
            if (this.m_Timer != null) {
                this.m_Timer.stop();
                this.m_Timer = null;
            }
        }

        public void resetTimer() {
            this.m_StartTime = System.currentTimeMillis();
        }
    }

    public static class Timer
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = -9020703905185523399L;
        protected StopwatchPanel m_Owner;
        protected boolean m_Running;

        public Timer(StopwatchPanel owner) {
            this.m_Owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.m_Running = true;
            while (this.m_Running) {
                try {
                    Timer timer = this;
                    synchronized (timer) {
                        this.wait(this.m_Owner.getOwner().getUpdateInterval());
                    }
                    if (!this.m_Running) continue;
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            Timer.this.m_Owner.updateTime(System.currentTimeMillis() - Timer.this.m_Owner.getStartTime());
                        }
                    };
                    SwingUtilities.invokeLater(run);
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.m_Running = false;
            Timer timer = this;
            synchronized (timer) {
                this.notifyAll();
            }
        }
    }
}

