/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.conversion.Conversion;
import adams.data.conversion.ObjectToObject;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class Convert
extends AbstractTransformer {
    private static final long serialVersionUID = 1704879993786242375L;
    protected Conversion m_Conversion;

    @Override
    public String globalInfo() {
        return "Converts data from one format into another.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("conversion", "conversion", new ObjectToObject());
    }

    public void setConversion(Conversion value) {
        this.m_Conversion = value;
        this.m_Conversion.setOwner(this);
        this.reset();
    }

    public Conversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The type of conversion to perform.";
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("conversion");
        if (variable != null) {
            return variable;
        }
        if (this.m_Conversion != null) {
            return this.m_Conversion.getClass().getName().replace("adams.data.conversion.", "");
        }
        return null;
    }

    @Override
    public Class[] accepts() {
        if (this.getOptionManager().getVariableForProperty("conversion") != null) {
            return new Class[]{Unknown.class};
        }
        return new Class[]{this.m_Conversion.accepts()};
    }

    @Override
    public Class[] generates() {
        if (this.getOptionManager().getVariableForProperty("conversion") != null) {
            return new Class[]{Unknown.class};
        }
        return new Class[]{this.m_Conversion.generates()};
    }

    @Override
    protected String doExecute() {
        this.m_Conversion.setInput(this.m_InputToken.getPayload());
        String result = this.m_Conversion.convert();
        if (result == null && this.m_Conversion.getOutput() != null) {
            this.m_OutputToken = new Token(this.m_Conversion.getOutput());
        }
        if (this.isDebugOn()) {
            this.debug(this.m_InputToken.getPayload() + " -> " + this.m_OutputToken.getPayload());
        }
        return result;
    }
}

