/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.standalone.DatabaseConnection;
import adams.flow.transformer.AbstractTransformer;
import adams.tools.AbstractTool;
import adams.tools.DatabaseIDProcessor;
import adams.tools.InitializeTables;
import adams.tools.InputFileHandler;
import adams.tools.OutputFileGenerator;
import java.io.File;
import java.util.Vector;

public class Tool
extends AbstractTransformer {
    private static final long serialVersionUID = -295054877801672294L;
    protected AbstractTool m_Tool;

    @Override
    public String globalInfo() {
        return "Runs a tool. If the tool is an InputFileHandler, then it will only accept String or File tokens, otherwise the token will be only used to trigger the execution. If the tool is an OutputFileGenerator then this File will be forwarded as token, otherwise the input token will be forwarded as it is.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tools", "tool", new InitializeTables());
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("tool");
        if (variable != null) {
            return variable;
        }
        return this.m_Tool.getClass().getName().replaceAll(".*\\.tools\\.", "");
    }

    public void setTool(AbstractTool value) {
        this.m_Tool = value;
        this.reset();
    }

    public AbstractTool getTool() {
        return this.m_Tool;
    }

    public String toolTipText() {
        return "The tool to run.";
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return adams.db.DatabaseConnection.getSingleton();
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, this.getDefaultDatabaseConnection());
    }

    @Override
    public Class[] accepts() {
        Vector<Class> result = new Vector<Class>();
        if (this.m_Tool instanceof InputFileHandler) {
            result.add(String.class);
            result.add(File.class);
        }
        if (this.m_Tool instanceof DatabaseIDProcessor) {
            result.add(Integer[].class);
        }
        if (result.size() == 0) {
            result.add(Unknown.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    protected void updateDatabaseConnection() {
        if (this.m_Tool instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_Tool)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected String doExecute() {
        String result;
        try {
            if (this.m_Tool instanceof InputFileHandler) {
                if (this.m_InputToken.getPayload() instanceof String) {
                    ((InputFileHandler)((Object)this.m_Tool)).setInputFile(new PlaceholderFile((String)this.m_InputToken.getPayload()));
                } else if (this.m_InputToken.getPayload() instanceof File) {
                    ((InputFileHandler)((Object)this.m_Tool)).setInputFile(new PlaceholderFile((File)this.m_InputToken.getPayload()));
                }
            }
            if (this.m_Tool instanceof DatabaseIDProcessor && this.m_InputToken.getPayload() instanceof Integer[]) {
                int[] ids = new int[((Integer[])this.m_InputToken.getPayload()).length];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = ((Integer[])this.m_InputToken.getPayload())[i];
                }
                ((DatabaseIDProcessor)((Object)this.m_Tool)).setDatabaseIDs(ids);
            }
            this.m_Tool.run();
            this.m_OutputToken = this.m_Tool instanceof OutputFileGenerator ? new Token(((OutputFileGenerator)((Object)this.m_Tool)).getOutputFile()) : this.m_InputToken;
            result = null;
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    public Class[] generates() {
        if (this.m_Tool instanceof OutputFileGenerator) {
            return new Class[]{File.class};
        }
        return new Class[]{Unknown.class};
    }
}

