/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderFile;
import adams.data.container.DataContainer;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.gui.chooser.AbstractExtensionFileFilterFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractDataContainerFileChooser<T extends DataContainer>
extends AbstractExtensionFileFilterFileChooser<DataContainerFileExtensionFilter> {
    private static final long serialVersionUID = -5373058011025481738L;
    protected static Hashtable<Class, Vector<DataContainerFileExtensionFilter>> m_ReaderFileFilters = new Hashtable();
    protected static Hashtable<Class, Vector<DataContainerFileExtensionFilter>> m_WriterFileFilters = new Hashtable();
    protected JButton m_ConfigureButton;
    protected JCheckBox m_CheckBoxOptions;
    protected JLabel m_LabelOptions;
    protected GenericObjectEditor m_Editor;

    protected AbstractDataContainerFileChooser() {
    }

    protected AbstractDataContainerFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    protected AbstractDataContainerFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_AllowGlobFilters = false;
        this.m_CheckBoxOptions = new JCheckBox("Invoke options dialog");
        this.m_CheckBoxOptions.setMnemonic('I');
        this.m_LabelOptions = new JLabel("<html><br>Note:<br><br>Some file formats offer additional<br>options which can be customized<br>when invoking the options dialog.</html>");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_CheckBoxOptions, "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.m_LabelOptions, "North");
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)panel2, "Center");
        this.setAccessory(panel);
        this.m_Editor = new GenericObjectEditor(false);
    }

    protected static void initFilters(AbstractDataContainerFileChooser chooser, boolean reader, String[] classnames) {
        if (reader) {
            m_ReaderFileFilters.put(((Object)((Object)chooser)).getClass(), new Vector());
        } else {
            m_WriterFileFilters.put(((Object)((Object)chooser)).getClass(), new Vector());
        }
        for (int i = 0; i < classnames.length; ++i) {
            DataContainerFileExtensionFilter filter;
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            String classname = classnames[i];
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                if (reader) {
                    desc = ((AbstractDataContainerReader)converter).getFormatDescription();
                    ext = ((AbstractDataContainerReader)converter).getFormatExtensions();
                } else {
                    desc = ((AbstractDataContainerWriter)converter).getFormatDescription();
                    ext = ((AbstractDataContainerWriter)converter).getFormatExtensions();
                }
            }
            catch (Exception e) {
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new DataContainerFileExtensionFilter(classname, desc, ext);
                m_ReaderFileFilters.get(((Object)((Object)chooser)).getClass()).add(filter);
                continue;
            }
            filter = new DataContainerFileExtensionFilter(classname, desc, ext);
            m_WriterFileFilters.get(((Object)((Object)chooser)).getClass()).add(filter);
        }
        if (reader) {
            Collections.sort((List)m_ReaderFileFilters.get(((Object)((Object)chooser)).getClass()));
        } else {
            Collections.sort((List)m_WriterFileFilters.get(((Object)((Object)chooser)).getClass()));
        }
    }

    @Override
    protected Vector<DataContainerFileExtensionFilter> getOpenFileFilters() {
        return m_ReaderFileFilters.get(((Object)((Object)this)).getClass());
    }

    @Override
    protected Vector<DataContainerFileExtensionFilter> getSaveFileFilters() {
        return m_WriterFileFilters.get(((Object)((Object)this)).getClass());
    }

    @Override
    protected void initGUI(int dialogType) {
        super.initGUI(dialogType);
        if (dialogType == 1) {
            this.m_Editor.setClassType(AbstractDataContainerReader.class);
            this.m_Editor.setValue(this.getDefaultReader());
        } else {
            this.m_Editor.setClassType(AbstractDataContainerWriter.class);
            this.m_Editor.setValue(this.getDefaultWriter());
        }
        this.restoreLastFilter(dialogType);
    }

    protected abstract AbstractDataContainerReader<T> getDefaultReader();

    protected abstract AbstractDataContainerWriter<T> getDefaultWriter();

    @Override
    public VFSJFileChooser.RETURN_TYPE showOpenDialog(Component parent) {
        VFSJFileChooser.RETURN_TYPE result = super.showOpenDialog(parent);
        if (result == VFSJFileChooser.RETURN_TYPE.APPROVE && this.m_CheckBoxOptions.isSelected()) {
            this.m_Editor.setValue(this.m_CurrentHandler);
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog((Container)((Object)this), this.m_Editor);
            dialog.setVisible(true);
            result = dialog.getResultType();
            if (result == VFSJFileChooser.RETURN_TYPE.APPROVE) {
                this.m_CurrentHandler = this.m_Editor.getValue();
            }
        }
        return result;
    }

    @Override
    public VFSJFileChooser.RETURN_TYPE showSaveDialog(Component parent) {
        VFSJFileChooser.RETURN_TYPE result = super.showSaveDialog(parent);
        if (result == VFSJFileChooser.RETURN_TYPE.APPROVE && this.m_CheckBoxOptions.isSelected()) {
            this.m_Editor.setValue(this.m_CurrentHandler);
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog((Container)((Object)this), this.m_Editor);
            dialog.setVisible(true);
            result = dialog.getResultType();
            if (result == VFSJFileChooser.RETURN_TYPE.APPROVE) {
                this.m_CurrentHandler = this.m_Editor.getValue();
            }
        }
        return result;
    }

    public AbstractDataContainerReader getReader() {
        this.configureCurrentHandlerHook(1);
        if (this.m_CurrentHandler instanceof AbstractDataContainerWriter) {
            return null;
        }
        return (AbstractDataContainerReader)this.m_CurrentHandler;
    }

    public AbstractDataContainerWriter getWriter() {
        this.configureCurrentHandlerHook(2);
        if (this.m_CurrentHandler instanceof AbstractDataContainerReader) {
            return null;
        }
        return (AbstractDataContainerWriter)this.m_CurrentHandler;
    }

    @Override
    protected void updateCurrentHandlerHook() {
        try {
            String classname = ((DataContainerFileExtensionFilter)this.getFileFilter()).getClassname();
            Object newHandler = Class.forName(classname).newInstance();
            if (this.m_CurrentHandler == null) {
                this.m_CurrentHandler = newHandler;
            } else if (!this.m_CurrentHandler.getClass().equals(newHandler.getClass())) {
                this.m_CurrentHandler = newHandler;
            }
            boolean onlyFiles = this.m_DialogType == 1 ? ((AbstractDataContainerReader)this.m_CurrentHandler).isInputFile() : ((AbstractDataContainerWriter)this.m_CurrentHandler).isOutputFile();
            if (onlyFiles) {
                this.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.FILES_ONLY);
            } else {
                this.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.DIRECTORIES_ONLY);
            }
        }
        catch (Exception e) {
            this.m_CurrentHandler = null;
            e.printStackTrace();
        }
    }

    @Override
    protected void configureCurrentHandlerHook(int dialogType) {
        boolean onlyFiles;
        PlaceholderFile selFile = this.getSelectedPlaceholderFile();
        if (this.m_CurrentHandler == null) {
            String classname = ((DataContainerFileExtensionFilter)this.getFileFilter()).getClassname();
            try {
                this.m_CurrentHandler = Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_CurrentHandler = null;
            }
            if (this.m_CurrentHandler == null) {
                return;
            }
        }
        if ((onlyFiles = this.m_CurrentHandler instanceof AbstractDataContainerReader ? ((AbstractDataContainerReader)this.m_CurrentHandler).isInputFile() : ((AbstractDataContainerWriter)this.m_CurrentHandler).isOutputFile()) && selFile.isDirectory() || !onlyFiles && !selFile.isDirectory()) {
            return;
        }
        try {
            PlaceholderFile currFile = this.m_CurrentHandler instanceof AbstractDataContainerReader ? ((AbstractDataContainerReader)this.m_CurrentHandler).getInput() : ((AbstractDataContainerWriter)this.m_CurrentHandler).getOutput();
            if (currFile == null || !((File)currFile).getAbsolutePath().equals(selFile.getAbsolutePath())) {
                if (this.m_CurrentHandler instanceof AbstractDataContainerReader) {
                    ((AbstractDataContainerReader)this.m_CurrentHandler).setInput(selFile);
                } else {
                    ((AbstractDataContainerWriter)this.m_CurrentHandler).setOutput(selFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters.containsKey(((Object)((Object)this)).getClass());
    }

    @Override
    public void setAllowGlobFilters(boolean value) {
    }

    public static class DataContainerFileExtensionFilter
    extends ExtensionFileFilter {
        private static final long serialVersionUID = 5863117558505811134L;
        protected String m_Classname;

        public DataContainerFileExtensionFilter(String classname) {
            this.m_Classname = classname;
        }

        public DataContainerFileExtensionFilter(String classname, String description, String extension) {
            super(description, extension);
            this.m_Classname = classname;
        }

        public DataContainerFileExtensionFilter(String classname, String description, String[] extensions) {
            super(description, extensions);
            this.m_Classname = classname;
        }

        public DataContainerFileExtensionFilter(String classname, String description, String extension, boolean caseSensitive) {
            super(description, extension, caseSensitive);
            this.m_Classname = classname;
        }

        public DataContainerFileExtensionFilter(String classname, String description, String[] extensions, boolean caseSensitive) {
            super(description, extensions, caseSensitive);
            this.m_Classname = classname;
        }

        public String getClassname() {
            return this.m_Classname;
        }
    }
}

