/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.Placeholders;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.chooser.BaseFileChooser;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileFilter;
import java.io.File;

public class FileChooserPanel
extends AbstractChooserPanel<File> {
    private static final long serialVersionUID = -8755020252465094120L;
    protected BaseFileChooser m_FileChooser;
    protected boolean m_UseSaveDialog;

    public FileChooserPanel() {
        this("");
    }

    public FileChooserPanel(String path) {
        this(new PlaceholderFile(path));
    }

    public FileChooserPanel(File path) {
        this.setCurrent(path);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new BaseFileChooser();
        this.m_UseSaveDialog = false;
    }

    @Override
    protected File doChoose() {
        this.m_FileChooser.setSelectedFile((File)this.getCurrent());
        if (this.m_UseSaveDialog) {
            if (this.m_FileChooser.showSaveDialog(this.m_Self) == VFSJFileChooser.RETURN_TYPE.APPROVE) {
                return this.m_FileChooser.getSelectedFile();
            }
            return null;
        }
        if (this.m_FileChooser.showOpenDialog(this.m_Self) == VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return this.m_FileChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    protected String toString(File value) {
        return Placeholders.collapseStr(value.getAbsolutePath());
    }

    @Override
    protected File fromString(String value) {
        return new PlaceholderFile(value);
    }

    public void setFileSelectionMode(VFSJFileChooser.SELECTION_MODE value) {
        this.m_FileChooser.setFileSelectionMode(value);
    }

    public VFSJFileChooser.SELECTION_MODE getFileSelectionMode() {
        return this.m_FileChooser.getFileSelectionMode();
    }

    public void addChoosableFileFilter(AbstractVFSFileFilter value) {
        AbstractVFSFileFilter current = this.m_FileChooser.getFileFilter();
        this.m_FileChooser.addChoosableFileFilter(value);
        this.m_FileChooser.setFileFilter(current);
    }

    public void removeChoosableFileFilter(AbstractVFSFileFilter value) {
        this.m_FileChooser.removeChoosableFileFilter(value);
    }

    public void removeChoosableFileFilters() {
        AbstractVFSFileFilter[] filters;
        for (AbstractVFSFileFilter filter : filters = this.m_FileChooser.getChoosableFileFilters()) {
            this.m_FileChooser.removeChoosableFileFilter(filter);
        }
    }

    public AbstractVFSFileFilter[] getChoosableFileFilters() {
        return this.m_FileChooser.getChoosableFileFilters();
    }

    public void setAcceptAllFileFilterUsed(boolean value) {
        this.m_FileChooser.setAcceptAllFileFilterUsed(value);
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.m_FileChooser.isAcceptAllFileFilterUsed();
    }

    public void setFileFilter(AbstractVFSFileFilter value) {
        this.m_FileChooser.setFileFilter(value);
    }

    public AbstractVFSFileFilter getFileFilter() {
        return this.m_FileChooser.getFileFilter();
    }

    public void setPromptOverwriteFile(boolean value) {
        this.m_FileChooser.setPromptOverwriteFile(value);
    }

    public boolean getPromptOverwriteFile() {
        return this.m_FileChooser.getPromptOverwriteFile();
    }

    public void setAutoAppendExtension(boolean value) {
        this.m_FileChooser.setAutoAppendExtension(value);
    }

    public boolean getAutoAppendExtension() {
        return this.m_FileChooser.getAutoAppendExtension();
    }

    public void setDefaultExtension(String value) {
        this.m_FileChooser.setDefaultExtension(value);
    }

    public String getDefaultExtension() {
        return this.m_FileChooser.getDefaultExtension();
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory(new PlaceholderFile(value));
    }

    public File getCurrentDirectory() {
        return this.m_FileChooser.getCurrentDirectory();
    }

    @Override
    public boolean setCurrent(File value) {
        boolean result = super.setCurrent(new PlaceholderFile(value));
        this.m_FileChooser.setSelectedFile(((File)this.getCurrent()).getAbsoluteFile());
        return result;
    }

    public void setUseSaveDialog(boolean value) {
        this.m_UseSaveDialog = value;
    }

    public boolean getUseSaveDialog(boolean value) {
        return this.m_UseSaveDialog;
    }
}

