/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.gui.chooser.FontChooser;
import adams.gui.core.GUIHelper;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JTextPane;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class BaseTextPane
extends JTextPane {
    private static final long serialVersionUID = 5053144101104728014L;
    protected boolean m_WordWrapEnabled;
    protected Dimension m_SizeBackup;

    public BaseTextPane() {
        this.initialize();
    }

    public BaseTextPane(StyledDocument doc) {
        super(doc);
        this.initialize();
    }

    protected void initialize() {
        this.m_WordWrapEnabled = false;
        this.m_SizeBackup = this.getSize();
    }

    public Frame getParentFrame() {
        return GUIHelper.getParentFrame(this);
    }

    public Dialog getParentDialog() {
        return GUIHelper.getParentDialog(this);
    }

    public JInternalFrame getParentInternalFrame() {
        return GUIHelper.getParentInternalFrame(this);
    }

    public void printText() {
        try {
            this.print(null, null, true, null, null, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "Failed to print:\n" + ex;
            if (this.getParentDialog() != null) {
                GUIHelper.showErrorMessage(this.getParentDialog(), msg);
            }
            GUIHelper.showErrorMessage(this.getParentFrame(), msg);
        }
    }

    public void selectFont() {
        FontChooser chooser = this.getParentDialog() != null ? new FontChooser(this.getParentDialog()) : new FontChooser(this.getParentFrame());
        chooser.setCurrent(this.getFont());
        chooser.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        chooser.setVisible(true);
        this.setTextFont(chooser.getCurrent());
    }

    @MixedCopyright(author="Philip Isenhour", copyright="2003-2007 Philip Isenhour", license=License.PUBLIC_DOMAIN, url="http://javatechniques.com/blog/setting-jtextpane-font-and-color/")
    public void setTextFont(Font font) {
        MutableAttributeSet attrs = this.getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        StyledDocument doc = this.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
    }

    public void setWordWrap(boolean value) {
        if (this.m_WordWrapEnabled != value) {
            this.m_WordWrapEnabled = value;
            if (this.m_WordWrapEnabled) {
                this.setSize(this.m_SizeBackup);
            } else {
                this.setSize(this.getSize());
            }
            if (this.getParent() != null) {
                this.getParent().invalidate();
                this.getParent().doLayout();
            }
        }
    }

    public boolean getWordWrap() {
        return this.m_WordWrapEnabled;
    }

    @Override
    @MixedCopyright(copyright="JBroFuzz", license=License.GPL3, url="http://grepcode.com/file/repo1.maven.org/maven2/org.owasp.jbrofuzz/jbrofuzz/2.5/org/owasp/jbrofuzz/util/NonWrappingTextPane.java#NonWrappingTextPane")
    public boolean getScrollableTracksViewportWidth() {
        if (this.m_WordWrapEnabled) {
            return false;
        }
        Container parent = this.getParent();
        TextUI mComponentUI = this.getUI();
        if (parent != null) {
            return mComponentUI.getPreferredSize((JComponent)this).width <= parent.getSize().width;
        }
        return true;
    }

    public int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean gotoLine(int index) {
        if (index < 0) {
            return false;
        }
        Document document = this.getDocument();
        synchronized (document) {
            Element root = this.getDocument().getDefaultRootElement();
            if (root.getElementCount() <= index) {
                return false;
            }
            this.setCaretPosition(root.getElement(index).getStartOffset());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int caretToLine(int position) {
        int result = -1;
        Document document = this.getDocument();
        synchronized (document) {
            Element root = this.getDocument().getDefaultRootElement();
            for (int i = 0; i < root.getElementCount(); ++i) {
                Element child = root.getElement(i);
                if (child.getStartOffset() < position || position > child.getEndOffset()) continue;
                result = i;
                break;
            }
        }
        return result;
    }
}

