/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.ByteFormat;
import adams.core.Pausable;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.core.VariablesHandler;
import adams.core.io.FileUtils;
import adams.core.io.FilenameProposer;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.NestedProducer;
import adams.data.statistics.InformativeStatistic;
import adams.db.LogEntryHandler;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorStatistic;
import adams.flow.core.ActorUtils;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.CheckVariableUsage;
import adams.flow.processor.ManageInteractiveActors;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.ParameterPanel;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.core.ToolBarPanel;
import adams.gui.core.Undo;
import adams.gui.core.UndoPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.dialog.TextDialog;
import adams.gui.event.ActorChangeEvent;
import adams.gui.event.ActorChangeListener;
import adams.gui.event.UndoEvent;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.FlowTabbedPane;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.tools.LogEntryViewerPanel;
import adams.gui.tools.VariableManagementPanel;
import adams.gui.visualization.statistics.InformativeStatisticFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class FlowPanel
extends UndoPanel
implements StatusMessageHandler,
SendToActionSupporter {
    private static final long serialVersionUID = -3579084888256133873L;
    public static final String PREFIX_NEW = "new";
    public static final String PREFIX_FLOW = "Flow";
    protected static int m_Counter = 0;
    protected static Properties m_Properties;
    protected FlowTabbedPane m_Owner;
    protected boolean m_Running;
    protected boolean m_Stopping;
    protected boolean m_RunningSwingWorker;
    protected AbstractActor m_CurrentFlow;
    protected AbstractActor m_LastFlow;
    protected File m_CurrentFile;
    protected Tree m_Tree;
    protected RecentFilesHandler m_RecentFilesHandler;
    protected FilenameProposer m_FilenameProposer;
    protected String m_LastVariableSearch;
    protected ToolBarPanel.ToolBarLocation m_ToolBarLocation;
    protected VariableManagementPanel m_PanelVariables;
    protected TitleGenerator m_TitleGenerator;
    protected String m_Title;
    protected boolean m_Headless;

    public FlowPanel(FlowTabbedPane owner) {
        this.m_Owner = owner;
        this.m_RecentFilesHandler = this.getEditor().getRecentFilesHandler();
        this.reset(new Flow());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CurrentFlow = null;
        this.m_LastFlow = null;
        this.m_CurrentFile = null;
        this.m_RecentFilesHandler = null;
        this.m_LastVariableSearch = "";
        this.m_TitleGenerator = new TitleGenerator("Flow editor", true);
        this.m_FilenameProposer = new FilenameProposer(PREFIX_NEW, "flow", FlowPanel.getProperties().getString("InitialDir", "%h"));
        this.m_Title = "";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = FlowPanel.getProperties();
        this.setLayout(new BorderLayout());
        this.m_Tree = new Tree(this);
        this.m_Tree.setActorNameColor(props.getProperty("Tree.ActorName.Color", "black"));
        this.m_Tree.setActorNameSize(props.getProperty("Tree.ActorName.Size", "3"));
        this.m_Tree.setQuickInfoColor(props.getProperty("Tree.QuickInfo.Color", "#008800"));
        this.m_Tree.setQuickInfoSize(props.getProperty("Tree.QuickInfo.Size", "-2"));
        this.m_Tree.setAnnotationsColor(props.getProperty("Tree.Annotations.Color", "blue"));
        this.m_Tree.setAnnotationsSize(props.getProperty("Tree.Annotations.Size", "-2"));
        this.m_Tree.setAnnotationsMarkDown(props.getBoolean("Tree.Annotations.MarkDown", false));
        this.m_Tree.setInputOutputColor(props.getProperty("Tree.InputOutput.Color", "blue"));
        this.m_Tree.setInputOutputSize(props.getProperty("Tree.InputOutput.Size", "-2"));
        this.m_Tree.setPlaceholdersColor(props.getProperty("Tree.Placeholders.Color", "navy"));
        this.m_Tree.setPlaceholdersSize(props.getProperty("Tree.Placeholders.Size", "-2"));
        this.m_Tree.setStateUsesNested(props.getBoolean("Tree.StateUsesNested", true));
        this.m_Tree.setIgnoreNameChanges(props.getBoolean("Tree.IgnoreNameChanges", false));
        this.m_Tree.setIconScaleFactor(props.getDouble("Tree.IconScaleFactor", 1.0));
        this.m_Tree.setVariableHighlightBackground(props.getProperty("VariableHighlight.Background", "#FFDD88"));
        this.m_Tree.setShowQuickInfo(props.getBoolean("ShowQuickInfo", true));
        this.m_Tree.setShowAnnotations(props.getBoolean("ShowAnnotations", true));
        this.m_Tree.setShowInputOutput(props.getBoolean("ShowInputOutput", false));
        this.m_Tree.setInputOutputPrefixes(props.getProperty("Tree.InputOutput.Prefixes", "java.lang.,java.io.,adams.core.io.,adams.flow.core.,adams.flow.container.").replace(" ", "").split(","));
        this.m_Tree.addActorChangeListener(new ActorChangeListener(){

            @Override
            public void actorChanged(ActorChangeEvent e) {
                FlowPanel.this.update();
            }
        });
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (FlowPanel.this.m_Tree.getSelectionPath() != null) {
                    FlowPanel.this.showStatus(FlowPanel.this.m_Tree.getSelectedFullName());
                }
            }
        });
        this.add((Component)new BaseScrollPane(this.m_Tree), "Center");
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (FlowPanel.this.getEditor() != null) {
                    FlowPanel.this.getEditor().getTabs().notifyTabs(FlowPanel.this.m_Tree.getSelectionPaths(), FlowPanel.this.m_Tree.getSelectedActors());
                }
            }
        });
    }

    public FlowTabbedPane getOwner() {
        return this.m_Owner;
    }

    public FlowEditorPanel getEditor() {
        if (this.m_Owner != null) {
            return this.m_Owner.getOwner();
        }
        return null;
    }

    public void setHeadless(boolean value) {
        if (!this.m_Running && !this.m_Stopping) {
            this.m_Headless = value;
        }
    }

    public boolean isHeadless() {
        return this.m_Headless;
    }

    protected void updateWidgets() {
        boolean inputEnabled = !this.m_Running && !this.m_Stopping;
        this.getTree().setEditable(inputEnabled);
    }

    protected void update() {
        this.updateWidgets();
        this.updateTitle();
        if (this.getOwner() != null && this.getOwner().getOwner() != null) {
            this.getOwner().getOwner().update();
        }
    }

    protected synchronized int next() {
        return ++m_Counter;
    }

    public void setTitle(String value) {
        this.m_Title = value;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public void updateTitle() {
        int index;
        this.setParentTitle(this.m_TitleGenerator.generate(this.getCurrentFile(), this.getTree().isModified()));
        if (this.getOwner() != null && (index = this.getOwner().indexOfComponent(this)) != -1) {
            this.getOwner().setTitleAt(index, (this.isModified() ? "*" : "") + this.getTitle());
        }
    }

    public void reset(AbstractActor actor) {
        this.addUndoPoint("Saving undo data...", "New " + actor.getClass().getName().replaceAll(".*\\.", ""));
        this.cleanUp();
        this.m_CurrentFlow = null;
        this.getTree().setActor(null);
        this.getTree().setActor(actor);
        this.getTree().setModified(false);
        this.setCurrentFile(null);
        this.setTitle(PREFIX_NEW + this.next());
        this.update();
        this.grabFocus();
    }

    public void setCurrentFile(File value) {
        this.m_CurrentFile = value;
        this.m_Title = value == null ? "" : (value.getName().lastIndexOf(46) > -1 ? value.getName().substring(0, value.getName().lastIndexOf(46)) : value.getName());
        this.getTree().setFile(value);
        this.getOwner().updateCurrentDirectory();
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public void load(File file) {
        file = new PlaceholderFile(file);
        this.m_RunningSwingWorker = true;
        final File currFile = new File(file.getAbsolutePath());
        SwingWorker worker = new SwingWorker(){
            protected AbstractActor m_Flow = null;
            protected Vector<String> m_Errors;
            protected Vector<String> m_Warnings;

            protected Object doInBackground() throws Exception {
                this.m_Errors = new Vector();
                this.m_Warnings = new Vector();
                FlowPanel.this.cleanUp();
                FlowPanel.this.update();
                FlowPanel.this.addUndoPoint("Saving undo data...", "Loading '" + currFile.getName() + "'");
                FlowPanel.this.showStatus("Loading '" + currFile + "'...");
                this.m_Flow = ActorUtils.read(currFile.getAbsolutePath(), this.m_Errors, this.m_Warnings);
                if (!this.m_Errors.isEmpty()) {
                    this.m_Flow = null;
                }
                FlowPanel.this.setCurrentFlow(this.m_Flow);
                FlowPanel.this.showStatus("");
                return null;
            }

            @Override
            protected void done() {
                FlowPanel.this.m_RunningSwingWorker = false;
                if (this.m_Flow == null) {
                    if (this.m_Errors.isEmpty()) {
                        GUIHelper.showErrorMessage(FlowPanel.this.m_Owner, "Failed to load flow '" + currFile + "'!");
                    } else {
                        GUIHelper.showErrorMessage(FlowPanel.this.m_Owner, "Failed to load flow '" + currFile + "':\n" + Utils.flatten(this.m_Errors, "\n"));
                    }
                } else {
                    FlowPanel.this.setCurrentFile(currFile);
                    if (FlowPanel.this.m_RecentFilesHandler != null) {
                        FlowPanel.this.m_RecentFilesHandler.addRecentFile(currFile);
                    }
                    if (!this.m_Warnings.isEmpty()) {
                        GUIHelper.showErrorMessage(FlowPanel.this.m_Owner, "Warning(s) encountered while loading flow '" + currFile + "':\n" + Utils.flatten(this.m_Warnings, "\n"));
                    }
                }
                FlowPanel.this.update();
                super.done();
            }
        };
        worker.execute();
    }

    public void setCurrentFlow(AbstractActor flow) {
        this.m_CurrentFlow = flow;
        if (flow != null) {
            this.getTree().setActor(flow);
            this.getTree().setModified(false);
        }
        this.setCurrentFile(null);
        this.setTitle(PREFIX_FLOW + this.next());
    }

    public AbstractActor getCurrentFlow() {
        return this.getTree().getActor();
    }

    public AbstractActor getCurrentRoot() {
        return this.getTree().getRootActor();
    }

    public AbstractActor getLastFlow() {
        return this.m_LastFlow;
    }

    public void setModified(boolean value) {
        this.getTree().setModified(value);
        this.update();
    }

    public boolean isModified() {
        return this.getTree().isModified();
    }

    public void revert() {
        this.cleanUp();
        this.load(this.getCurrentFile());
    }

    public void save(final File file) {
        SwingWorker worker = new SwingWorker(){
            boolean m_Result;

            protected Object doInBackground() throws Exception {
                FlowPanel.this.showStatus("Saving '" + file + "'...");
                this.m_Result = ActorUtils.write(file.getAbsolutePath(), FlowPanel.this.getCurrentFlow());
                FlowPanel.this.showStatus("");
                return null;
            }

            @Override
            protected void done() {
                if (!this.m_Result) {
                    GUIHelper.showErrorMessage(FlowPanel.this.m_Owner, "Error saving flow to '" + file.getAbsolutePath() + "'!");
                } else {
                    FlowPanel.this.showStatus("");
                    FlowPanel.this.getTree().setModified(false);
                    if (FlowPanel.this.m_RecentFilesHandler != null) {
                        FlowPanel.this.m_RecentFilesHandler.addRecentFile(file);
                    }
                    FlowPanel.this.setCurrentFile(file);
                }
                FlowPanel.this.update();
                super.done();
            }
        };
        worker.execute();
    }

    public void importFlow(AbstractOptionConsumer consumer, File file) {
        AbstractActor actor = (AbstractActor)consumer.fromFile(file);
        if (actor == null) {
            this.showMessage("Failed to load flow from:\n" + file, true);
        } else {
            this.getTree().setActor(actor);
            this.setCurrentFile(new PlaceholderFile(file.getAbsolutePath() + "." + "flow"));
            if (!consumer.hasErrors()) {
                this.showMessage("Flow successfully imported from:\n" + file, false);
            } else {
                this.showMessage("Flow import of:\n" + file + "\nResulted in errors:\n" + Utils.flatten(consumer.getErrors(), "\n"), true);
            }
        }
    }

    public void exportFlow(AbstractOptionProducer producer, File file) {
        producer.produce(this.getCurrentFlow());
        if (!FileUtils.writeToFile(file.getAbsolutePath(), producer.toString(), false)) {
            this.showMessage("Failed to export flow to:\n" + file, true);
        } else {
            this.showMessage("Flow successfully exported to:\n" + file, false);
        }
    }

    public void validateSetup() {
        String msg;
        AbstractActor actor = this.getCurrentFlow();
        try {
            msg = actor.setUp();
            actor.wrapUp();
            actor.cleanUp();
        }
        catch (Exception e) {
            msg = "Actor generated exception: ";
            System.err.println(msg);
            e.printStackTrace();
            msg = msg + e;
        }
        msg = ActorUtils.checkFlow(actor);
        if (msg == null) {
            msg = "The flow passed validation!";
            this.showStatus(msg);
            this.showMessage(msg, false);
        } else {
            this.showStatus(msg);
            this.showMessage("The flow setup failed validation:\n" + msg, true);
        }
    }

    public void run() {
        this.run(true);
    }

    public void run(boolean showNotification) {
        final boolean fShowNotification = showNotification;
        this.m_Running = true;
        SwingWorker worker = new SwingWorker(){
            String m_Output;

            protected Object doInBackground() throws Exception {
                FlowPanel.this.update();
                FlowPanel.this.cleanUp();
                try {
                    FlowPanel.this.showStatus("Initializing");
                    FlowPanel.this.m_CurrentFlow = FlowPanel.this.getCurrentFlow();
                    FlowPanel.this.m_CurrentFlow.setHeadless(FlowPanel.this.m_Headless);
                    FlowPanel.this.m_CurrentFlow = ActorUtils.removeDisabledActors(FlowPanel.this.m_CurrentFlow);
                    if (FlowPanel.this.m_CurrentFlow instanceof VariablesHandler) {
                        ActorUtils.updateVariablesWithFlowFilename((VariablesHandler)((Object)FlowPanel.this.m_CurrentFlow), FlowPanel.this.m_CurrentFile);
                    }
                    this.m_Output = FlowPanel.this.m_CurrentFlow.setUp();
                    if (this.m_Output == null && !FlowPanel.this.m_CurrentFlow.isStopped()) {
                        FlowPanel.this.showStatus("Running");
                        this.m_Output = FlowPanel.this.m_CurrentFlow.execute();
                        if (this.m_Output == null && FlowPanel.this.m_CurrentFlow.hasStopMessage()) {
                            this.m_Output = FlowPanel.this.m_CurrentFlow.getStopMessage();
                        }
                    }
                    FlowPanel.this.showStatus("Finishing up");
                    FlowPanel.this.m_CurrentFlow.wrapUp();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.m_Output = Utils.throwableToString(e);
                }
                if (FlowPanel.this.m_PanelVariables != null && FlowPanel.this.m_PanelVariables.getParentDialog() != null) {
                    FlowPanel.this.m_PanelVariables.getParentDialog().setVisible(false);
                }
                return "Done!";
            }

            @Override
            protected void done() {
                int countErrors;
                super.done();
                FlowPanel.this.m_LastFlow = FlowPanel.this.m_CurrentFlow;
                FlowPanel.this.m_CurrentFlow = null;
                String errors = null;
                if (FlowPanel.this.m_LastFlow instanceof LogEntryHandler && (countErrors = ((LogEntryHandler)((Object)FlowPanel.this.m_LastFlow)).countLogEntries()) > 0) {
                    errors = countErrors + " error(s) logged";
                }
                if (this.m_Output != null) {
                    String msg = "Finished with error: " + this.m_Output;
                    if (errors != null) {
                        msg = msg + "(" + errors + ")";
                    }
                    FlowPanel.this.showStatus(msg);
                    if (fShowNotification) {
                        FlowPanel.this.showMessage(this.m_Output, true);
                    }
                } else {
                    String msg = FlowPanel.this.m_Running ? "Flow finished." : "User stopped flow.";
                    if (errors != null) {
                        msg = msg + " " + errors + ".";
                    }
                    FlowPanel.this.showStatus(msg);
                    if (fShowNotification) {
                        if (FlowPanel.this.m_Running) {
                            GUIHelper.showInformationMessage(FlowPanel.this.m_Owner, msg);
                        } else {
                            GUIHelper.showErrorMessage(FlowPanel.this.m_Owner, msg);
                        }
                    }
                }
                FlowPanel.this.m_Running = false;
                FlowPanel.this.m_Stopping = false;
                FlowPanel.this.update();
            }
        };
        worker.execute();
    }

    public boolean isRunning() {
        return this.m_Running;
    }

    public boolean isStopping() {
        return this.m_Stopping;
    }

    public boolean isSwingWorkerRunning() {
        return this.m_RunningSwingWorker;
    }

    public boolean pauseAndResume() {
        boolean result;
        Pausable pausable = (Pausable)((Object)this.m_CurrentFlow);
        if (!pausable.isPaused()) {
            this.showStatus("Pausing");
            pausable.pauseExecution();
            result = true;
        } else {
            this.showStatus("Resuming");
            pausable.resumeExecution();
            result = false;
        }
        this.update();
        return result;
    }

    public void stop() {
        this.showStatus("Stopping");
        this.m_Running = false;
        this.m_Stopping = true;
        this.update();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (FlowPanel.this.m_CurrentFlow != null) {
                    FlowPanel.this.m_CurrentFlow.stopExecution();
                }
                FlowPanel.this.update();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void displayErrors() {
        if (this.m_LastFlow == null) {
            return;
        }
        if (!(this.m_LastFlow instanceof LogEntryHandler)) {
            return;
        }
        LogEntryHandler handler = (LogEntryHandler)((Object)this.m_LastFlow);
        if (handler.getLogEntries().size() == 0) {
            return;
        }
        BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new BaseDialog(this.getParentFrame(), false);
        dialog.setTitle("Flow execution errors");
        LogEntryViewerPanel panel = new LogEntryViewerPanel();
        panel.display(handler.getLogEntries());
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.setSize(new Dimension(800, 600));
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public void cleanUp() {
        if (this.m_LastFlow != null) {
            this.showStatus("Cleaning up");
            try {
                this.m_LastFlow.destroy();
                this.m_LastFlow = null;
                this.showStatus("");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showStatus("Error cleaning up: " + e);
            }
        }
    }

    public void close() {
        this.cleanUp();
        if (this.m_Owner != null) {
            this.m_Owner.remove(this);
        }
    }

    public void showStatistics() {
        ActorStatistic stats = this.getTree().getSelectedNode() != null ? new ActorStatistic(this.getTree().getSelectedNode().getFullActor()) : (this.m_CurrentFlow != null ? new ActorStatistic(this.m_CurrentFlow) : new ActorStatistic(this.getCurrentFlow()));
        Vector<InformativeStatistic> statsList = new Vector<InformativeStatistic>();
        statsList.add(stats);
        InformativeStatisticFactory.Dialog dialog = this.getParentDialog() != null ? InformativeStatisticFactory.getDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : InformativeStatisticFactory.getDialog(this.getParentFrame(), true);
        dialog.setStatistics(statsList);
        dialog.setTitle("Actor statistics");
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public void showProperties() {
        String file = this.getCurrentFile() != null ? this.getCurrentFile().toString() : "N/A";
        String size = this.getCurrentFile() != null && !this.isModified() ? ByteFormat.toKiloBytes(this.getCurrentFile().length(), 1) : "N/A";
        JButton buttonStats = new JButton("Display", GUIHelper.getIcon("statistics.png"));
        buttonStats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowPanel.this.showStatistics();
            }
        });
        ParameterPanel params = new ParameterPanel();
        final JTextField textFile = new JTextField(file, 20);
        textFile.setEditable(false);
        textFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    e.consume();
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
                    menuitem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GUIHelper.copyToClipboard(textFile.getText());
                        }
                    });
                    menu.add(menuitem);
                    menu.show(textFile, e.getX(), e.getY());
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        params.addParameter("File", textFile);
        JTextField textSize = new JTextField(size, 7);
        textSize.setEditable(false);
        params.addParameter("Size", textSize);
        params.addParameter("Statistics", buttonStats);
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog()) : new ApprovalDialog(this.getParentFrame());
        dialog.setTitle("Properties");
        dialog.setCancelVisible(false);
        dialog.setApproveVisible(true);
        dialog.setDiscardVisible(false);
        dialog.getContentPane().add((Component)params, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public void addUndoPoint(String statusMsg, String undoComment) {
        if (this.isUndoSupported() && this.getUndo().isEnabled()) {
            this.showStatus(statusMsg);
            this.getUndo().addUndo(this.getTree().getState(), undoComment);
            this.showStatus("");
        }
    }

    public void undo() {
        if (!this.getUndo().canUndo()) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                FlowPanel.this.showStatus("Performing Undo...");
                FlowPanel.this.getUndo().addRedo(FlowPanel.this.getTree().getState(), FlowPanel.this.getUndo().peekUndoComment());
                Undo.UndoPoint point = FlowPanel.this.getUndo().undo();
                FlowPanel.this.getTree().setState((Vector)point.getData());
                FlowPanel.this.m_CurrentFile = FlowPanel.this.getTree().getFile();
                return "Done!";
            }

            @Override
            protected void done() {
                super.done();
                FlowPanel.this.update();
                FlowPanel.this.showStatus("");
            }
        };
        worker.execute();
    }

    public void redo() {
        if (!this.getUndo().canRedo()) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                FlowPanel.this.showStatus("Performing Redo...");
                FlowPanel.this.getUndo().addUndo(FlowPanel.this.getTree().getState(), FlowPanel.this.getUndo().peekRedoComment(), true);
                Undo.UndoPoint point = FlowPanel.this.getUndo().redo();
                FlowPanel.this.getTree().setState((Vector)point.getData());
                FlowPanel.this.m_CurrentFile = FlowPanel.this.getTree().getFile();
                return "Done!";
            }

            @Override
            protected void done() {
                super.done();
                FlowPanel.this.update();
                FlowPanel.this.showStatus("");
            }
        };
        worker.execute();
    }

    public void find() {
        this.getTree().find();
    }

    public void findNext() {
        this.getTree().findNext();
    }

    public void locateActor() {
        String path = JOptionPane.showInputDialog("Please enter the full name of the actor (e.g., 'Flow[0].Sequence[3].Display'):");
        if (path == null) {
            return;
        }
        this.getTree().locateAndDisplay(path);
    }

    public void highlightVariables(boolean highlight) {
        if (highlight) {
            String regexp = JOptionPane.showInputDialog(this, "Enter the regular expression for the variable name ('.*' matches all):", this.m_LastVariableSearch);
            if (regexp == null) {
                return;
            }
            this.m_LastVariableSearch = regexp;
            this.getTree().highlightVariables(this.m_LastVariableSearch);
        } else {
            this.getTree().highlightVariables(null);
        }
    }

    public void cleanUpFlow() {
        AbstractActor cleaned = ActorUtils.cleanUpFlow(this.getCurrentFlow());
        if (cleaned != null) {
            this.addUndoPoint("Saving undo data...", "Cleaning up");
            this.getTree().buildTree(cleaned);
            this.getTree().setModified(true);
            this.update();
        }
    }

    protected void checkVariables() {
        CheckVariableUsage processor = new CheckVariableUsage();
        processor.process(this.getCurrentFlow());
        if (processor.hasGraphicalOutput()) {
            final BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
            dialog.setTitle(processor.getClass().getSimpleName());
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add(processor.getGraphicalOutput(), "Center");
            JButton button = new JButton("Close");
            button.setMnemonic('C');
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                }
            });
            JPanel panel = new JPanel(new FlowLayout(2));
            panel.add(button);
            dialog.getContentPane().add((Component)panel, "South");
            dialog.pack();
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        } else {
            this.showMessage("Basic check passed!\nAll variables get at least set once in the flow.", false);
        }
    }

    public void manageInteractiveActors(boolean enable) {
        ManageInteractiveActors processor = new ManageInteractiveActors();
        processor.setEnable(enable);
        processor.process(this.getCurrentFlow());
        if (processor.isModified()) {
            this.addUndoPoint("Saving undo data...", (enable ? "Enable" : "Disable") + " interactive behaviour");
            this.getTree().buildTree(processor.getModifiedActor());
            this.getTree().setModified(true);
            this.update();
        }
    }

    public void setIgnoreNameChanges(boolean value) {
        this.m_Tree.setIgnoreNameChanges(value);
    }

    public boolean getIgnoreNameChanges() {
        return this.m_Tree.getIgnoreNameChanges();
    }

    public void processActorsPrompt() {
        this.processActorsPrompt(null);
    }

    public void processActorsPrompt(AbstractActorProcessor processor) {
        boolean selected;
        if (this.getTree().getSelectionCount() == 1 && !this.getTree().isRootSelected()) {
            int retVal = GUIHelper.showConfirmMessage(this, "Process only below selected actor instead of complete flow?\n" + this.getTree().getSelectedFullName());
            if (retVal == 2) {
                return;
            }
            selected = retVal == 0;
        } else {
            selected = false;
        }
        if (selected) {
            this.processSelectedActor(processor);
        } else {
            this.processActors(processor);
        }
    }

    public void processActors() {
        this.processActors(null);
    }

    public void processActors(AbstractActorProcessor processor) {
        if (this.getTree().processActor(null, processor)) {
            this.showMessage("Actors processed!", false);
        }
    }

    public void processSelectedActor() {
        this.processSelectedActor(null);
    }

    public void processSelectedActor(AbstractActorProcessor processor) {
        if (this.getTree().getSelectionRows().length != 1) {
            return;
        }
        TreePath path = this.getTree().getSelectionPath();
        Node node = (Node)path.getLastPathComponent();
        if (this.getTree().processActor(path, processor)) {
            this.showMessage("Actor " + node.getActor().getName() + " processed!", false);
        }
    }

    public void enableBreakpoints(boolean enable) {
        this.getTree().enableBreakpoints(enable);
    }

    public void showVariables() {
        if (this.m_PanelVariables == null) {
            this.m_PanelVariables = new VariableManagementPanel();
            BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
            dialog.setTitle("Variables");
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add((Component)this.m_PanelVariables, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(null);
        }
        this.m_PanelVariables.setVariables(this.m_CurrentFlow.getVariables());
        this.m_PanelVariables.getParentDialog().setVisible(true);
    }

    public void showSource() {
        String buffer = AbstractOptionProducer.toString(NestedProducer.class, this.getCurrentFlow());
        TextDialog dialog = this.getParentDialog() != null ? new TextDialog(this.getParentDialog()) : new TextDialog(this.getParentFrame());
        dialog.setTitle(this.m_TitleGenerator.generate(this.getCurrentFile(), this.getTree().isModified()) + " [Source]");
        dialog.setTabSize(2);
        dialog.setContent(buffer);
        dialog.setLocationRelativeTo(this.getTree());
        dialog.setVisible(true);
    }

    protected void showMessage(String msg, boolean isError) {
        String status = msg.replaceAll(": ", ":\n");
        if (isError) {
            GUIHelper.showErrorMessage(this.m_Owner, status, "Error");
        } else {
            GUIHelper.showInformationMessage(this.m_Owner, status, "Status");
        }
    }

    @Override
    public void showStatus(String msg) {
        if (this.getEditor() != null) {
            this.getEditor().showStatus(msg);
        }
    }

    @Override
    public void undoOccurred(UndoEvent e) {
        this.update();
    }

    @Override
    public void grabFocus() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FlowPanel.this.getTree().grabFocus();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public Tree getTree() {
        return this.m_Tree;
    }

    public void setRecentFilesHandler(RecentFilesHandler value) {
        this.m_RecentFilesHandler = value;
    }

    public RecentFilesHandler getRecentFilesHandler() {
        return this.m_RecentFilesHandler;
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, JComponent.class}, cls) && (this.getTree().isModified() || this.getCurrentFile() != null);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            if (this.getTree().isModified()) {
                result = SendToActionUtils.nextTmpFile("floweditor", "flow");
                AbstractActor actor = this.getCurrentFlow();
                ActorUtils.write(((PlaceholderFile)result).getAbsolutePath(), actor);
            } else if (this.getCurrentFile() != null) {
                result = new PlaceholderFile(this.getCurrentFile());
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
            result = this.m_Tree;
        }
        return result;
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("flow editor panel");
        }
        return m_Properties;
    }
}

