/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree;

import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.net.HtmlUtils;
import adams.core.option.NestedConsumer;
import adams.core.option.NestedProducer;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractExternalActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.OutputProducer;
import adams.gui.core.GUIHelper;
import adams.gui.core.LazyExpansionTreeNode;
import adams.gui.core.TransferableString;
import adams.gui.flow.tree.Tree;
import java.awt.datatransfer.Transferable;
import java.util.HashSet;
import org.pegdown.PegDownProcessor;

public class Node
extends LazyExpansionTreeNode
implements Destroyable {
    private static final long serialVersionUID = 8994468228049539761L;
    protected Tree m_Owner;
    protected HashSet<String> m_Variables;
    protected String m_VariableSearch;
    protected Boolean m_VariableFound;
    protected String m_RenderString;
    protected boolean m_Editable;
    protected PegDownProcessor m_MarkDownProcessor;

    public Node(Tree owner, AbstractActor actor) {
        super(Node.strip(actor));
        this.m_Owner = owner;
        this.m_VariableSearch = null;
        this.m_RenderString = null;
        this.m_Editable = true;
        this.m_MarkDownProcessor = null;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.m_Variables = null;
        this.m_VariableFound = null;
        this.m_RenderString = null;
        super.setUserObject(userObject);
    }

    public Tree getOwner() {
        return this.m_Owner;
    }

    public void setActor(AbstractActor value) {
        AbstractActor stripped = Node.strip(value);
        AbstractActor oldActor = this.getActor();
        if (oldActor != null) {
            AbstractActor parent = oldActor.getParent();
            stripped.setParent(parent);
        } else {
            System.err.println("No old actor stored?");
        }
        this.setUserObject(stripped);
        if (oldActor != null) {
            oldActor.destroy();
        }
    }

    public AbstractActor getActor() {
        return (AbstractActor)this.getUserObject();
    }

    public String getFullName() {
        StringBuilder result = new StringBuilder(this.getActor().getName().replace(".", "\\."));
        Node child = this;
        Node parent = (Node)child.getParent();
        do {
            if (parent == null) continue;
            result.insert(0, parent.getActor().getName().replace(".", "\\.") + ".");
            child = parent;
            parent = (Node)child.getParent();
        } while (parent != null);
        return result.toString();
    }

    public AbstractActor getFullActor() {
        AbstractActor result = this.getActor().shallowCopy();
        boolean mutable = result instanceof MutableActorHandler;
        if (mutable) {
            while (((MutableActorHandler)((Object)result)).size() > 0) {
                ((MutableActorHandler)((Object)result)).remove(0);
            }
        }
        if (result instanceof ActorHandler) {
            ActorHandler handler = (ActorHandler)((Object)result);
            for (int i = 0; i < this.getChildCount(); ++i) {
                Node child = (Node)this.getChildAt(i);
                if (mutable) {
                    ((MutableActorHandler)handler).add(child.getFullActor());
                    continue;
                }
                handler.set(i, child.getFullActor());
            }
        }
        return result;
    }

    public boolean isRemovable() {
        boolean result = false;
        if (this.getActor().getParent() != null) {
            result = this.getActor().getParent() instanceof MutableActorHandler;
        }
        return result;
    }

    public int replace(Comparable find, Comparable replace, boolean recursive) {
        HashSet<Class> excluded = new HashSet<Class>();
        excluded.add(AbstractActor.class);
        int result = ActorUtils.replace(this.getActor(), find, replace, recursive, excluded);
        if (recursive) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                Node child = (Node)this.getChildAt(i);
                result += child.replace(find, replace, true);
            }
        }
        return result;
    }

    public void findVariable(String nameRegExp) {
        this.m_VariableSearch = nameRegExp;
        this.m_VariableFound = null;
    }

    protected void updateVariableSearch() {
        if (this.m_VariableFound != null) {
            return;
        }
        if (this.m_VariableSearch == null) {
            this.m_VariableFound = false;
            return;
        }
        if (this.m_Variables == null) {
            this.m_Variables = this.getActor().findVariables();
        }
        this.m_VariableFound = false;
        for (String var : this.m_Variables) {
            if (!var.matches(this.m_VariableSearch)) continue;
            this.m_VariableFound = true;
            break;
        }
    }

    @Override
    public Transferable toTransferable() {
        return new TransferableString(this.getFullActor().toCommandLine());
    }

    @Override
    public void destroy() {
        this.m_Owner = null;
        this.getActor().destroy();
    }

    protected String classArrayToString(Class[] classes) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < classes.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            Class<?> cls = classes[i];
            if (classes[i].isArray()) {
                cls = cls.getComponentType();
            }
            String name = cls.getName();
            for (int n = 0; n < this.m_Owner.getInputOutputPrefixes().length; ++n) {
                String prefix = this.m_Owner.getInputOutputPrefixes()[n];
                if (!name.startsWith(prefix)) continue;
                name = name.replace(prefix, "");
            }
            result.append(name);
            if (!classes[i].isArray()) continue;
            result.append("[]");
        }
        if (result.length() == 0) {
            result.append("-none-");
        }
        return result.toString();
    }

    protected String scaleFontSize(String size) {
        try {
            size = size.trim();
            int newSize = size.startsWith("+") ? 3 + Integer.parseInt(size.substring(1)) : (size.startsWith("-") ? 3 - Integer.parseInt(size.substring(1)) : Integer.parseInt(size));
            newSize = (int)((double)newSize * this.m_Owner.getIconScaleFactor());
            if (newSize < 1) {
                newSize = 1;
            }
            if (newSize > 7) {
                newSize = 7;
            }
            if (newSize > 3) {
                return "+" + (newSize - 3);
            }
            if (newSize < 3) {
                return "-" + (3 - newSize);
            }
            return "" + newSize;
        }
        catch (Exception e) {
            return size;
        }
    }

    protected synchronized PegDownProcessor getMarkDownProcessor() {
        if (this.m_MarkDownProcessor == null) {
            this.m_MarkDownProcessor = new PegDownProcessor();
        }
        return this.m_MarkDownProcessor;
    }

    @Override
    public String toString() {
        if (this.m_RenderString == null) {
            StringBuilder html = new StringBuilder();
            AbstractActor actor = this.getActor();
            if (actor == null) {
                html.append("<b>[none]</b>");
            } else {
                String quickInfo;
                html.append("<font size='" + this.scaleFontSize(this.m_Owner.getActorNameSize()) + "' color='" + this.m_Owner.getActorNameColor() + "'>" + HtmlUtils.toHTML(actor.getName()) + "</font>");
                if (actor.getSkip()) {
                    html.insert(0, "<s>");
                    html.append("</s>");
                }
                if (this.m_Owner.getShowInputOutput() && actor instanceof InputConsumer) {
                    html.insert(0, "<font size='" + this.scaleFontSize(this.m_Owner.getInputOutputSize()) + "' color='" + this.m_Owner.getInputOutputColor() + "'>" + HtmlUtils.toHTML(this.classArrayToString(((InputConsumer)((Object)actor)).accepts())) + "</font>" + "<br>");
                }
                if (this.m_Owner.getShowQuickInfo() && (quickInfo = actor.getQuickInfo()) != null) {
                    html.append("&nbsp;&nbsp;<font size='" + this.scaleFontSize(this.m_Owner.getQuickInfoSize()) + "' color='" + this.m_Owner.getQuickInfoColor() + "'>" + HtmlUtils.toHTML(quickInfo) + "</font>");
                }
                if (this.m_Owner.getShowAnnotations() && actor.getAnnotations().getValue().length() > 0) {
                    html.append("<font size='" + this.scaleFontSize(this.m_Owner.getAnnotationsSize()) + "' color='" + this.m_Owner.getAnnotationsColor() + "'>");
                    if (this.m_Owner.getAnnotationsMarkDown()) {
                        html.append(this.getMarkDownProcessor().markdownToHtml(actor.getAnnotations().getValue()));
                    } else {
                        String[] lines = actor.getAnnotations().getValue().split("\n");
                        for (int i = 0; i < lines.length; ++i) {
                            String line;
                            if (lines[i].startsWith(" ")) {
                                line = lines[i].trim();
                                for (int n = 0; n < lines[i].length() - line.length(); ++n) {
                                    line = "&nbsp;" + line;
                                }
                            } else {
                                line = lines[i];
                            }
                            html.append("<br>" + line);
                        }
                    }
                    html.append("</font>");
                }
                if (this.m_Owner.getShowInputOutput() && actor instanceof OutputProducer) {
                    html.append("<br>");
                    html.append("<font size='" + this.scaleFontSize(this.m_Owner.getInputOutputSize()) + "' color='" + this.m_Owner.getInputOutputColor() + "'>" + HtmlUtils.toHTML(this.classArrayToString(((OutputProducer)((Object)actor)).generates())) + "</font>");
                }
                this.updateVariableSearch();
                if (this.m_VariableFound.booleanValue()) {
                    html.insert(0, "<font style='background-color: " + this.m_Owner.getVariableHighlightBackground() + "'>");
                }
                html.append("</font>");
            }
            html.insert(0, "<html>");
            html.append("</html>");
            this.m_RenderString = html.toString();
        }
        return this.m_RenderString;
    }

    @Override
    public String toPlainText() {
        if (this.m_RenderString == null) {
            StringBuilder html = new StringBuilder();
            AbstractActor actor = this.getActor();
            if (actor == null) {
                html.append("[none]");
            } else {
                String quickInfo;
                html.append(actor.getName());
                if (actor.getSkip()) {
                    html.insert(0, "---");
                    html.append("---");
                }
                if (this.m_Owner.getShowInputOutput() && actor instanceof InputConsumer) {
                    html.insert(0, this.classArrayToString(((InputConsumer)((Object)actor)).accepts()) + "\n");
                }
                if (this.m_Owner.getShowQuickInfo() && (quickInfo = actor.getQuickInfo()) != null) {
                    html.append("  " + quickInfo);
                }
                if (this.m_Owner.getShowAnnotations() && actor.getAnnotations().getValue().length() > 0) {
                    String[] lines = actor.getAnnotations().getValue().split("\n");
                    for (int i = 0; i < lines.length; ++i) {
                        String line;
                        if (lines[i].startsWith(" ")) {
                            line = lines[i].trim();
                            for (int n = 0; n < lines[i].length() - line.length(); ++n) {
                                line = " " + line;
                            }
                        } else {
                            line = lines[i];
                        }
                        html.append("\n" + line);
                    }
                }
                if (this.m_Owner.getShowInputOutput() && actor instanceof OutputProducer) {
                    html.append("\n");
                    html.append(this.classArrayToString(((OutputProducer)((Object)actor)).generates()));
                }
                this.updateVariableSearch();
            }
            this.m_RenderString = html.toString();
        }
        return this.m_RenderString;
    }

    public static AbstractActor strip(AbstractActor actor) {
        AbstractActor result;
        if (actor instanceof ActorHandler) {
            result = (AbstractActor)Utils.newInstance(actor);
            NestedProducer producer = new NestedProducer();
            producer.setBlacklisted(new Class[]{AbstractActor[].class, AbstractActor.class});
            producer.produce(actor);
            NestedConsumer consumer = new NestedConsumer();
            consumer.setInput(producer.getOutput());
            result = (AbstractActor)consumer.consume();
            producer.cleanUp();
            consumer.cleanUp();
        } else {
            result = actor.shallowCopy();
        }
        result.setParent(actor.getParent());
        return result;
    }

    public void invalidateRendering() {
        this.m_RenderString = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((Node)this.getChildAt(i)).invalidateRendering();
        }
    }

    public int indexOf(String name) {
        int result = -1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = (Node)this.getChildAt(i);
            if (!child.getActor().getName().equals(name)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public boolean canExpand() {
        return this.getActor() instanceof AbstractExternalActor;
    }

    @Override
    public boolean getExpansionOccurred() {
        if (this.getActor() instanceof AbstractExternalActor) {
            return this.m_ExpansionOccurred;
        }
        return true;
    }

    @Override
    protected boolean doExpand() {
        boolean result = false;
        if (this.getActor() instanceof AbstractExternalActor) {
            AbstractExternalActor actor = (AbstractExternalActor)this.getActor();
            String msg = actor.setUpExternalActor();
            if (msg == null) {
                Node node = this.m_Owner.buildTree(this, actor.getExternalActor(), true);
                node.setEditable(false, true);
                result = this.getChildCount() > 0;
            } else {
                GUIHelper.showErrorMessage(null, "Failed to expand node '" + this.getFullName() + "': " + msg);
            }
        }
        return result;
    }

    @Override
    protected void doReset() {
        if (this.getActor() instanceof AbstractExternalActor) {
            ((AbstractExternalActor)this.getActor()).cleanUpExternalActor();
        }
    }

    public void setEditable(boolean value) {
        this.setEditable(value, false);
    }

    public void setEditable(boolean value, boolean recurse) {
        this.m_Editable = value;
        if (recurse) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ((Node)this.getChildAt(i)).setEditable(value, true);
            }
        }
    }

    public boolean isEditable() {
        return this.m_Editable;
    }

    @Override
    public synchronized boolean expand() {
        boolean result = super.expand();
        if (result) {
            this.getOwner().nodeStructureChanged(this);
        }
        return result;
    }

    @Override
    public synchronized boolean collapse() {
        boolean result = super.collapse();
        if (result) {
            this.getOwner().nodeStructureChanged(this);
        }
        return result;
    }
}

