/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.FieldType;
import adams.data.report.PrefixOnlyField;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import adams.gui.selection.SelectFieldPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FieldEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor {
    protected SelectFieldPanel m_SelectFieldPanel;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonClose;

    public static String toString(AbstractOption option, Object object) {
        return ((Field)object).toParseableString();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return Field.parseField(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return FieldEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return FieldEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        Field field = (Field)this.getValue();
        String result = field == null ? "null" : "new " + Field.class.getName() + "(\"" + field.toString() + "\", " + DataType.class.getName() + "." + field.getDataType() + ")";
        return result;
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panel = new JPanel(new BorderLayout());
        this.m_SelectFieldPanel = new SelectFieldPanel();
        this.m_SelectFieldPanel.setFieldType(FieldType.FIELD);
        panel.add((Component)this.m_SelectFieldPanel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panel.add((Component)panelButtons, "South");
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FieldEditor.this.m_SelectFieldPanel.getItem() != null) {
                    AbstractField field = FieldEditor.this.m_SelectFieldPanel.getItem();
                    AbstractField current = (AbstractField)FieldEditor.this.getValue();
                    if (!current.toParseableString().equals(field.toParseableString())) {
                        FieldEditor.this.setValue(field);
                    }
                }
                FieldEditor.this.closeDialog(1);
            }
        });
        panelButtons.add(this.m_ButtonOK);
        this.m_ButtonClose = new JButton("Cancel");
        this.m_ButtonClose.setMnemonic('C');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldEditor.this.m_SelectFieldPanel.setItem((AbstractField)FieldEditor.this.getValue());
                FieldEditor.this.closeDialog(0);
            }
        });
        panelButtons.add(this.m_ButtonClose);
        return panel;
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        this.m_SelectFieldPanel.setItem((Field)this.getValue());
        this.m_SelectFieldPanel.grabFocus();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        Field curr = (Field)this.getValue();
        String val = curr.toDisplayString();
        if (!(curr instanceof PrefixOnlyField)) {
            val = val + "[" + curr.getDataType().toDisplay() + "]";
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected AbstractField[] newArray(Vector<String> fields, DataType type) {
        AbstractField[] result = new Field[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            result[i] = new Field(fields.get(i), type);
        }
        return result;
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        JComboBox<String> combo = new JComboBox<String>();
        for (DataType type : DataType.values()) {
            combo.addItem(type.toDisplay());
            if (type != DataType.NUMERIC) continue;
            combo.setSelectedIndex(combo.getModel().getSize() - 1);
        }
        JPanel panelType = new JPanel(new FlowLayout(0, 5, 0));
        panelType.add(new JLabel("Data type"));
        panelType.add(combo);
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the field names, one per line:");
        panelType = dialog.getBottomPanel();
        panelType.setLayout(new FlowLayout(0, 5, 0));
        panelType.add(new JLabel("Data type"));
        panelType.add(combo);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            DataType dtype = combo.getSelectedIndex() == -1 ? DataType.UNKNOWN : DataType.valueOf((AbstractOption)null, (String)combo.getSelectedItem());
            result = this.newArray(lines, dtype);
        } else {
            result = this.newArray(new Vector<String>(), DataType.UNKNOWN);
        }
        return result;
    }
}

