/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ClassLister;
import adams.core.CustomDisplayStringProvider;
import adams.core.SerializedObject;
import adams.core.Utils;
import adams.core.option.AbstractCommandLineHandler;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.dotnotationtree.AbstractItemFilter;
import adams.gui.goe.AdamsEditorsRegistration;
import adams.gui.goe.CustomPanelSupplier;
import adams.gui.goe.Favorites;
import adams.gui.goe.GenericObjectEditorPopupMenu;
import adams.gui.goe.PropertyPanel;
import adams.gui.goe.PropertySheetPanel;
import adams.gui.goe.classtree.ClassTree;
import adams.gui.goe.classtree.StrictClassTreeFilter;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class GenericObjectEditor
implements PropertyEditor,
CustomPanelSupplier {
    public static final String ACTION_CMD_OK = "ok";
    public static final String ACTION_CMD_CANCEL = "cancel";
    public static final String ACTION_CMD_OPEN = "open";
    public static final String ACTION_CMD_SAVE = "save";
    public static final String ACTION_CMD_REVERT = "revert";
    protected Object m_Object;
    protected Object m_Backup;
    protected Object m_DefaultValue;
    protected Boolean m_DefaultValueDetermined;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Class m_ClassType;
    protected Vector<String> m_ObjectNames;
    protected GOEPanel m_EditorComponent;
    protected boolean m_Enabled = true;
    protected JPanel m_CustomPanel;
    protected JButton m_CustomPanelChooseButton;
    protected PropertyPanel m_ObjectPropertyPanel;
    protected boolean m_canChangeClassInDialog;
    protected AbstractItemFilter m_Filter;
    protected int m_MinimumChars;
    protected Class[] m_ProposedClasses = new Class[0];

    public GenericObjectEditor() {
        this(false);
    }

    public GenericObjectEditor(boolean canChangeClassInDialog) {
        AdamsEditorsRegistration.registerEditors();
        Favorites.getSingleton();
        this.m_DefaultValueDetermined = null;
        this.m_DefaultValue = null;
        this.m_MinimumChars = 2;
        this.setCanChangeClassInDialog(canChangeClassInDialog);
    }

    public void setCanChangeClassInDialog(boolean value) {
        this.m_canChangeClassInDialog = value;
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.setCanChangeClassInDialog(value);
        }
        if (this.m_CustomPanelChooseButton != null) {
            this.m_CustomPanelChooseButton.setVisible(value);
        }
    }

    public boolean getCanChangeClassInDialog() {
        return this.m_canChangeClassInDialog;
    }

    public void setReadOnly(boolean value) {
        this.m_EditorComponent.setReadOnly(value);
    }

    public boolean isReadOnly() {
        return this.m_EditorComponent.isReadOnly();
    }

    public void setFilter(AbstractItemFilter value) {
        this.m_Filter = value;
    }

    public AbstractItemFilter getFilter() {
        return this.m_Filter;
    }

    public Object getBackup() {
        return this.m_Backup;
    }

    protected Vector<String> getClassesFromProperties() {
        Vector<String> result = new Vector<String>();
        String classesStr = ClassLister.getSingleton().getClasses().getString(this.m_ClassType.getName());
        String[] classes = classesStr == null ? new String[]{this.m_ClassType.getName()} : classesStr.replaceAll(" ", "").split(",");
        for (int i = 0; i < classes.length; ++i) {
            result.add(classes[i]);
        }
        Collections.sort(result);
        return result;
    }

    protected void updateObjectNames() {
        String className;
        if (this.m_ObjectNames == null) {
            this.m_ObjectNames = this.getClassesFromProperties();
        }
        if (this.m_Object != null && !this.m_ObjectNames.contains(className = this.m_Object.getClass().getName())) {
            this.m_ObjectNames.add(className);
            Collections.sort(this.m_ObjectNames);
        }
    }

    public void setEnabled(boolean newVal) {
        if (newVal != this.m_Enabled) {
            this.m_Enabled = newVal;
        }
    }

    public void setClassType(Class type) {
        this.m_ClassType = type;
        this.m_ObjectNames = this.getClassesFromProperties();
        this.m_DefaultValueDetermined = null;
    }

    public Class getClassType() {
        return this.m_ClassType;
    }

    protected Object determineDefaultValue() {
        if (this.m_DefaultValueDetermined == null) {
            this.m_DefaultValueDetermined = true;
            ClassTree tree = new ClassTree();
            tree.setItems(this.getClassesFromProperties());
            String defaultValue = tree.getFirstItem();
            try {
                if (defaultValue == null) {
                    throw new IllegalStateException("No classes available!");
                }
                this.m_DefaultValue = Class.forName(defaultValue).newInstance();
            }
            catch (Exception e) {
                System.err.println("Problem loading the first class: " + defaultValue);
                e.printStackTrace();
                this.m_DefaultValue = null;
            }
        }
        return this.m_DefaultValue;
    }

    protected boolean checkClassType(Object obj) {
        if (this.m_ClassType != null) {
            return true;
        }
        String[] superclasses = ClassLister.getSingleton().getSuperclasses(obj.getClass());
        if (superclasses.length == 0) {
            System.err.println("No class type set up for GenericObjectEditor and unable to determine one!");
            return false;
        }
        if (superclasses.length > 1) {
            System.err.println("No class type set up for GenericObjectEditor and more than one superclass found, defaulting to: " + superclasses[0]);
        }
        try {
            this.m_ClassType = Class.forName(superclasses[0]);
            this.m_canChangeClassInDialog = true;
        }
        catch (Exception e) {
            System.err.println("Failed to initialize class type: " + superclasses[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setDefaultValue() {
        if (this.m_ClassType == null) {
            System.err.println("setDefaultValue: No class type set up for GenericObjectEditor!");
            return;
        }
        Object defaultValue = this.determineDefaultValue();
        if (defaultValue != null) {
            this.setValue(defaultValue);
        }
    }

    @Override
    public void setValue(Object o) {
        if (!this.checkClassType(o)) {
            return;
        }
        if (!this.m_ClassType.isAssignableFrom(o.getClass())) {
            System.err.println("setValue object not of correct type: " + this.m_ClassType.getName() + " != " + o.getClass().getName());
            return;
        }
        this.setObject(o);
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.repaint();
        }
        this.updateObjectNames();
    }

    protected void setObject(Object c) {
        boolean trueChange = this.getValue() != null ? !c.equals(this.getValue()) : true;
        this.m_Backup = this.m_Object != null ? this.m_Object : Utils.deepCopy(c);
        this.m_Object = Utils.deepCopy(c);
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.updateChildPropertySheet();
        }
        if (trueChange) {
            this.firePropertyChange();
        }
    }

    @Override
    public Object getValue() {
        return Utils.deepCopy(this.m_Object);
    }

    @Override
    public String getJavaInitializationString() {
        return "new " + this.m_Object.getClass().getName() + "()";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.m_Enabled) {
            String rep;
            if (this.m_Object != null) {
                if (this.m_Object instanceof CustomDisplayStringProvider) {
                    rep = ((CustomDisplayStringProvider)this.m_Object).toDisplay();
                } else {
                    rep = this.m_Object.getClass().getName();
                    int dotPos = rep.lastIndexOf(46);
                    if (dotPos != -1) {
                        rep = rep.substring(dotPos + 1);
                    }
                    AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(this.m_Object);
                    String optionStr = handler.joinOptions(handler.getOptions(this.m_Object));
                    rep = rep + " " + optionStr;
                    rep = rep.trim();
                }
            } else {
                rep = "None";
            }
            Font originalFont = gfx.getFont();
            gfx.setFont(originalFont.deriveFont(0));
            FontMetrics fm = gfx.getFontMetrics();
            int vpad = box.height - fm.getHeight();
            gfx.drawString(rep, 2, fm.getAscent() + vpad);
            gfx.setFont(originalFont);
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.m_EditorComponent == null) {
            this.m_EditorComponent = new GOEPanel();
        }
        return this.m_EditorComponent;
    }

    public void setMinimumChars(int value) {
        if (value >= 1) {
            this.m_MinimumChars = value;
        }
    }

    public int getMinimumChars() {
        return this.m_MinimumChars;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    @Override
    public JPanel getCustomPanel() {
        if (this.m_CustomPanel == null) {
            this.m_ObjectPropertyPanel = new PropertyPanel(this, true);
            this.m_CustomPanel = new JPanel(new BorderLayout()){
                private static final long serialVersionUID = 7871364274183770690L;

                @Override
                public void setToolTipText(String text) {
                    super.setToolTipText(text);
                    for (int i = 0; i < this.getComponentCount(); ++i) {
                        if (!(this.getComponent(i) instanceof JPanel)) continue;
                        ((JPanel)this.getComponent(i)).setToolTipText(text);
                    }
                }
            };
            JPanel buttonPanel = new JPanel(new GridLayout(1, 1));
            this.m_CustomPanelChooseButton = this.createChooseClassButton();
            buttonPanel.add(this.m_CustomPanelChooseButton);
            this.m_CustomPanel.add((Component)buttonPanel, "East");
            this.m_CustomPanel.add((Component)this.m_ObjectPropertyPanel, "Center");
        }
        return this.m_CustomPanel;
    }

    protected JButton createChooseClassButton() {
        JButton setButton = new JButton(GUIHelper.getIcon("tree.gif"));
        setButton.setToolTipText("Select different class");
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = GenericObjectEditor.this.getChooseClassPopupMenu();
                if (e.getSource() instanceof Component) {
                    Component comp = (Component)e.getSource();
                    popup.show(comp, comp.getWidth(), 0);
                    popup.pack();
                }
            }
        });
        return setButton;
    }

    public JPopupMenu getChooseClassPopupMenu() {
        this.updateObjectNames();
        final ClassTree tree = new ClassTree();
        tree.setFilter(this.m_Filter);
        tree.setItems(this.m_ObjectNames);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setSelectedItem(this.getValue().getClass().getName());
        final GOETreePopupMenu popup = new GOETreePopupMenu(tree);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                String classname = tree.getSelectedItem();
                if (classname == null) {
                    return;
                }
                GenericObjectEditor.this.classSelected(classname);
                popup.setVisible(false);
            }
        });
        return popup;
    }

    protected void classSelected(String className) {
        try {
            if (this.m_Object != null && this.m_Object.getClass().getName().equals(className)) {
                return;
            }
            this.setValue(Class.forName(className).newInstance());
            if (this.m_EditorComponent != null) {
                this.m_EditorComponent.updateChildPropertySheet();
            }
        }
        catch (Exception ex) {
            GUIHelper.showErrorMessage(null, "Could not create an example of\n" + className + "\n" + "from the current classpath", "Class load failed");
            ex.printStackTrace();
            try {
                if (this.m_Backup != null) {
                    this.setValue(this.m_Backup);
                } else {
                    this.setDefaultValue();
                }
            }
            catch (Exception e) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public void setProposedClasses(Object[] value) {
        Class[] classes;
        if (value == null) {
            classes = new Class[]{};
        } else {
            classes = new Class[value.length];
            for (int i = 0; i < value.length; ++i) {
                classes[i] = value[i].getClass();
            }
        }
        this.setProposedClasses(classes);
    }

    public void setProposedClasses(Class[] value) {
        this.m_ProposedClasses = value == null ? new Class[0] : (Class[])value.clone();
    }

    public Class[] getProposedClasses() {
        return this.m_ProposedClasses;
    }

    public void firePropertyChange() {
        this.m_Support.firePropertyChange("", null, null);
    }

    public class GOEPanel
    extends JPanel {
        static final long serialVersionUID = 3656028520876011335L;
        protected GOEPanel m_Self = this;
        protected PropertySheetPanel m_PropertySheetChild;
        protected JComboBox m_ComboBoxClassname;
        protected JLabel m_LabelClassname;
        protected JButton m_ButtonOpen;
        protected JButton m_ButtonSave;
        protected JButton m_ButtonOK;
        protected JButton m_ButtonCancel;
        protected JButton m_ButtonRevert;
        protected transient BaseFileChooser m_FileChooser;
        protected JButton m_ButtonChoose;
        protected JButton m_ButtonCopyPaste;
        protected JPanel m_TopPanel;
        protected boolean m_IgnoreChanges;

        public GOEPanel() {
            GenericObjectEditor.this.m_Backup = this.copyObject(GenericObjectEditor.this.m_Object);
            this.m_LabelClassname = new JLabel("None");
            this.m_ComboBoxClassname = new JComboBox<String>(new String[]{"None"});
            this.m_ComboBoxClassname.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_ComboBoxClassname.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GOEPanel.this.m_ComboBoxClassname.getSelectedIndex() == -1 || GOEPanel.this.m_IgnoreChanges) {
                        return;
                    }
                    try {
                        Class<?> cls = Class.forName("" + GOEPanel.this.m_ComboBoxClassname.getSelectedItem());
                        GenericObjectEditor.this.setValue(cls.newInstance());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.m_PropertySheetChild = new PropertySheetPanel();
            this.m_PropertySheetChild.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GenericObjectEditor.this.firePropertyChange();
                }
            });
            this.m_ButtonOpen = new JButton(GUIHelper.getIcon("open.gif"));
            this.m_ButtonOpen.setActionCommand(GenericObjectEditor.ACTION_CMD_OPEN);
            this.m_ButtonOpen.setToolTipText("Load a serialized object");
            this.m_ButtonOpen.setEnabled(true);
            this.m_ButtonOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object object = GOEPanel.this.openObject();
                    if (object != null) {
                        GenericObjectEditor.this.setValue(object);
                    }
                }
            });
            this.m_ButtonSave = new JButton(GUIHelper.getIcon("save.gif"));
            this.m_ButtonSave.setActionCommand(GenericObjectEditor.ACTION_CMD_SAVE);
            this.m_ButtonSave.setToolTipText("Save the current as serialized object");
            this.m_ButtonSave.setEnabled(true);
            this.m_ButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GOEPanel.this.saveObject(GenericObjectEditor.this.m_Object);
                }
            });
            this.m_ButtonOK = new JButton("OK");
            this.m_ButtonOK.setActionCommand(GenericObjectEditor.ACTION_CMD_OK);
            this.m_ButtonOK.setEnabled(true);
            this.m_ButtonOK.setMnemonic('O');
            this.m_ButtonOK.setToolTipText("Use this setup and close dialog");
            this.m_ButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericObjectEditor.this.m_Backup = GOEPanel.this.copyObject(GenericObjectEditor.this.m_Object);
                    GOEPanel.this.close();
                }
            });
            this.m_ButtonCancel = new JButton("Cancel");
            this.m_ButtonCancel.setActionCommand(GenericObjectEditor.ACTION_CMD_CANCEL);
            this.m_ButtonCancel.setEnabled(true);
            this.m_ButtonCancel.setMnemonic('C');
            this.m_ButtonCancel.setToolTipText("Discard changes and close dialog");
            this.m_ButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GenericObjectEditor.this.m_Backup != null) {
                        GenericObjectEditor.this.m_Object = GOEPanel.this.copyObject(GenericObjectEditor.this.m_Backup);
                    }
                    GOEPanel.this.close();
                }
            });
            this.m_ButtonRevert = new JButton(GUIHelper.getIcon("undo.gif"));
            this.m_ButtonRevert.setActionCommand(GenericObjectEditor.ACTION_CMD_REVERT);
            this.m_ButtonRevert.setEnabled(true);
            this.m_ButtonRevert.setToolTipText("Revert changes");
            this.m_ButtonRevert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GenericObjectEditor.this.m_Backup != null) {
                        GenericObjectEditor.this.m_Object = GOEPanel.this.copyObject(GenericObjectEditor.this.m_Backup);
                        GenericObjectEditor.this.firePropertyChange();
                        GenericObjectEditor.this.m_ObjectNames = GenericObjectEditor.this.getClassesFromProperties();
                        GenericObjectEditor.this.updateObjectNames();
                        GOEPanel.this.updateChildPropertySheet();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.m_ButtonChoose = GenericObjectEditor.this.createChooseClassButton();
            this.m_ButtonChoose.setVisible(GenericObjectEditor.this.m_canChangeClassInDialog);
            this.m_ButtonCopyPaste = new JButton("...");
            this.m_ButtonCopyPaste.setToolTipText("Displays copy/paste/favorites action menu");
            this.m_ButtonCopyPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericObjectEditorPopupMenu menu = new GenericObjectEditorPopupMenu(GenericObjectEditor.this, GOEPanel.this.m_ButtonCopyPaste);
                    menu.addSeparator();
                    Favorites.getSingleton().customizePopupMenu(menu, GenericObjectEditor.this.getClassType(), GenericObjectEditor.this.getValue(), new Favorites.FavoriteSelectionListener(){

                        @Override
                        public void favoriteSelected(Favorites.FavoriteSelectionEvent e) {
                            GenericObjectEditor.this.setValue(e.getFavorite().getObject());
                        }
                    });
                    menu.show(GOEPanel.this.m_ButtonCopyPaste, 0, GOEPanel.this.m_ButtonCopyPaste.getHeight());
                }
            });
            this.m_TopPanel = new JPanel(new BorderLayout());
            JPanel chooseButtonPanel = new JPanel(new FlowLayout(2));
            chooseButtonPanel.add(this.m_ButtonCopyPaste);
            chooseButtonPanel.add(this.m_ButtonChoose);
            this.m_TopPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_TopPanel.add((Component)chooseButtonPanel, "East");
            this.m_TopPanel.add((Component)this.m_ComboBoxClassname, "Center");
            this.add((Component)this.m_TopPanel, "North");
            final JButton chooseButtonFinal = this.m_ButtonChoose;
            this.m_ComboBoxClassname.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MouseUtils.isRightClick(e)) {
                        e.consume();
                        GenericObjectEditorPopupMenu menu = new GenericObjectEditorPopupMenu(GenericObjectEditor.this, GOEPanel.this.m_Self);
                        if (chooseButtonFinal.isVisible()) {
                            JMenuItem item = new JMenuItem("Choose...", GUIHelper.getIcon("tree.gif"));
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    chooseButtonFinal.doClick();
                                }
                            });
                            menu.insert(new JPopupMenu.Separator(), 0);
                            menu.insert(item, 0);
                        }
                        menu.addSeparator();
                        Favorites.getSingleton().customizePopupMenu(menu, GenericObjectEditor.this.getClassType(), GenericObjectEditor.this.getValue(), new Favorites.FavoriteSelectionListener(){

                            @Override
                            public void favoriteSelected(Favorites.FavoriteSelectionEvent e) {
                                GenericObjectEditor.this.setValue(e.getFavorite().getObject());
                            }
                        });
                        menu.show(GOEPanel.this.m_Self, e.getX(), e.getY());
                    } else {
                        super.mouseClicked(e);
                    }
                }
            });
            JPanel childPanel = new JPanel(new BorderLayout());
            childPanel.add((Component)this.m_PropertySheetChild, "West");
            this.add((Component)childPanel, "Center");
            JPanel allButs = new JPanel(new GridLayout(1, 2));
            JPanel leftButs = new JPanel();
            JPanel rightButs = new JPanel();
            allButs.add((Component)leftButs, "West");
            allButs.add((Component)rightButs, "East");
            allButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            leftButs.setLayout(new FlowLayout(0));
            leftButs.add(this.m_ButtonOpen);
            leftButs.add(this.m_ButtonSave);
            leftButs.add(this.m_ButtonRevert);
            rightButs.setLayout(new FlowLayout(2));
            rightButs.add(this.m_ButtonOK);
            rightButs.add(this.m_ButtonCancel);
            this.add((Component)allButs, "South");
            if (GenericObjectEditor.this.m_ClassType != null) {
                GenericObjectEditor.this.m_ObjectNames = GenericObjectEditor.this.getClassesFromProperties();
                if (GenericObjectEditor.this.m_Object != null) {
                    GenericObjectEditor.this.updateObjectNames();
                    this.updateChildPropertySheet();
                }
            }
        }

        protected void close() {
            if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof Window) {
                Window w = (Window)this.getTopLevelAncestor();
                w.dispose();
            }
        }

        protected void setCancelButton(boolean flag) {
            if (this.m_ButtonCancel != null) {
                this.m_ButtonCancel.setEnabled(flag);
            }
        }

        protected Object openObject() {
            this.getFileChooser().setDialogTitle("Load setup from serialized object");
            VFSJFileChooser.RETURN_TYPE returnVal = this.getFileChooser().showOpenDialog(this);
            if (returnVal == VFSJFileChooser.RETURN_TYPE.APPROVE) {
                File selected = this.getFileChooser().getSelectedFile();
                try {
                    Object obj = SerializedObject.read(selected);
                    if (!GenericObjectEditor.this.m_ClassType.isAssignableFrom(obj.getClass())) {
                        throw new Exception("Object not of type: " + GenericObjectEditor.this.m_ClassType.getName());
                    }
                    return obj;
                }
                catch (Exception ex) {
                    GUIHelper.showErrorMessage(this, "Couldn't read object:\n" + selected + "\n" + ex.getMessage(), "Open object file");
                }
            }
            return null;
        }

        protected void saveObject(Object object) {
            File file;
            this.getFileChooser().setDialogTitle("Save setup as serialized object");
            VFSJFileChooser.RETURN_TYPE returnVal = this.getFileChooser().showSaveDialog(this);
            if (returnVal == VFSJFileChooser.RETURN_TYPE.APPROVE && !SerializedObject.write(file = this.getFileChooser().getSelectedFile(), (Serializable)object)) {
                GUIHelper.showErrorMessage(this, "Couldn't write to file:\n" + file, "Save object");
            }
        }

        protected BaseFileChooser getFileChooser() {
            if (this.m_FileChooser == null) {
                BaseFileChooser fileChooser = new BaseFileChooser(new File(System.getProperty("user.dir")));
                ExtensionFileFilter filter = new ExtensionFileFilter("Serialized objects", "model");
                fileChooser.addChoosableFileFilter(filter);
                fileChooser.setAcceptAllFileFilterUsed(true);
                fileChooser.setFileFilter(filter);
                fileChooser.setAutoAppendExtension(true);
                fileChooser.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.FILES_ONLY);
                this.m_FileChooser = fileChooser;
            }
            return this.m_FileChooser;
        }

        protected Object copyObject(Object source) {
            Object result = Utils.deepCopy(source);
            this.setCancelButton(result != null);
            return result;
        }

        public void setOkButtonText(String newLabel) {
            this.m_ButtonOK.setText(newLabel);
        }

        public void addOkListener(ActionListener a) {
            this.m_ButtonOK.addActionListener(a);
        }

        public void addCancelListener(ActionListener a) {
            this.m_ButtonCancel.addActionListener(a);
        }

        public void removeOkListener(ActionListener a) {
            this.m_ButtonOK.removeActionListener(a);
        }

        public void removeCancelListener(ActionListener a) {
            this.m_ButtonCancel.removeActionListener(a);
        }

        public void updateChildPropertySheet() {
            this.m_IgnoreChanges = true;
            String classname = "None";
            if (GenericObjectEditor.this.m_Object != null) {
                classname = GenericObjectEditor.this.m_Object.getClass().getName();
            }
            Vector<String> list = new Vector<String>();
            list.add(classname);
            for (Class cls : GenericObjectEditor.this.m_ProposedClasses) {
                if (cls.getName().equals(classname)) continue;
                list.add(cls.getName());
            }
            Collections.sort(list);
            this.m_ComboBoxClassname.setModel(new DefaultComboBoxModel(list));
            this.m_ComboBoxClassname.setSelectedItem(classname);
            this.m_LabelClassname.setText(classname);
            if (list.size() == 1) {
                this.m_TopPanel.add((Component)this.m_LabelClassname, "Center");
                this.m_TopPanel.remove(this.m_ComboBoxClassname);
            } else {
                this.m_TopPanel.add((Component)this.m_ComboBoxClassname, "Center");
                this.m_TopPanel.remove(this.m_LabelClassname);
            }
            this.m_PropertySheetChild.setTarget(GenericObjectEditor.this.m_Object);
            if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof Window) {
                ((Window)this.getTopLevelAncestor()).pack();
            }
            this.m_IgnoreChanges = false;
        }

        public void setCanChangeClassInDialog(boolean value) {
            this.m_ButtonChoose.setVisible(value);
        }

        public boolean getCanChangeClassInDialog() {
            return this.m_ButtonChoose.isVisible();
        }

        public void setReadOnly(boolean value) {
            this.m_ButtonOK.setEnabled(!value);
            this.m_ButtonChoose.setEnabled(!value);
        }

        public boolean isReadOnly() {
            return !this.m_ButtonOK.isEnabled();
        }
    }

    public class GOETreePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -3404546329655057387L;
        protected JPopupMenu m_Self = this;
        protected ClassTree m_Tree;
        protected BaseScrollPane m_Scroller;
        protected JTextField m_TextSearch;
        protected JButton m_CloseButton;
        protected JCheckBox m_CheckBoxFilter;
        protected JCheckBox m_CheckBoxStrict;

        public GOETreePopupMenu(ClassTree tree) {
            this.m_Tree = tree;
            this.setLayout(new BorderLayout());
            JPanel bottomPanel = new JPanel(new BorderLayout());
            this.add((Component)bottomPanel, "South");
            JPanel panel = new JPanel(new FlowLayout(0));
            bottomPanel.add((Component)panel, "West");
            this.m_TextSearch = new JTextField(20);
            this.m_TextSearch.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                protected void update() {
                    if (GOETreePopupMenu.this.m_TextSearch.getText().length() >= GenericObjectEditor.this.getMinimumChars()) {
                        GOETreePopupMenu.this.m_Tree.setSearch(GOETreePopupMenu.this.m_TextSearch.getText());
                    }
                }
            });
            JLabel labelSearch = new JLabel("Search");
            labelSearch.setDisplayedMnemonic('S');
            labelSearch.setLabelFor(this.m_TextSearch);
            panel.add(labelSearch);
            panel.add(this.m_TextSearch);
            if (this.m_Tree.getFilter() != null) {
                panel = new JPanel(new FlowLayout(0));
                bottomPanel.add((Component)panel, "South");
                this.m_CheckBoxFilter = new JCheckBox("Filtering");
                this.m_CheckBoxFilter.setMnemonic('F');
                this.m_CheckBoxFilter.setSelected(this.m_Tree.getFilter().isEnabled());
                this.m_CheckBoxFilter.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractItemFilter filter = GOETreePopupMenu.this.m_Tree.getFilter();
                        filter.setEnabled(GOETreePopupMenu.this.m_CheckBoxFilter.isSelected());
                        GOETreePopupMenu.this.m_Tree.setFilter(filter);
                        GOETreePopupMenu.this.m_CheckBoxStrict.setEnabled(GOETreePopupMenu.this.m_CheckBoxFilter.isEnabled() && GOETreePopupMenu.this.m_CheckBoxFilter.isSelected() && GOETreePopupMenu.this.m_Tree.getFilter() instanceof StrictClassTreeFilter);
                    }
                });
                panel.add(this.m_CheckBoxFilter);
                this.m_CheckBoxStrict = new JCheckBox("Strict mode");
                this.m_CheckBoxStrict.setMnemonic('m');
                this.m_CheckBoxStrict.setEnabled(this.m_CheckBoxFilter.isEnabled() && this.m_CheckBoxFilter.isSelected() && this.m_Tree.getFilter() instanceof StrictClassTreeFilter);
                this.m_CheckBoxStrict.setSelected(this.m_CheckBoxStrict.isEnabled() && ((StrictClassTreeFilter)((Object)this.m_Tree.getFilter())).isStrict());
                this.m_CheckBoxStrict.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((StrictClassTreeFilter)((Object)GOETreePopupMenu.this.m_Tree.getFilter())).setStrict(!((StrictClassTreeFilter)((Object)GOETreePopupMenu.this.m_Tree.getFilter())).isStrict());
                        GOETreePopupMenu.this.m_Tree.setFilter(GOETreePopupMenu.this.m_Tree.getFilter());
                    }
                });
                panel.add(this.m_CheckBoxStrict);
            }
            panel = new JPanel(new FlowLayout(2));
            bottomPanel.add((Component)panel, "East");
            this.m_CloseButton = new JButton("Close");
            this.m_CloseButton.setMnemonic('C');
            this.m_CloseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == GOETreePopupMenu.this.m_CloseButton) {
                        GOETreePopupMenu.this.m_Self.setVisible(false);
                    }
                }
            });
            panel.add(this.m_CloseButton);
            JPanel treeView = new JPanel();
            treeView.setLayout(new BorderLayout());
            treeView.add((Component)this.m_Tree, "North");
            treeView.setBackground(this.m_Tree.getBackground());
            this.m_Scroller = new BaseScrollPane(treeView);
            this.m_Scroller.setPreferredSize(new Dimension(300, 400));
            this.add(this.m_Scroller);
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
            Point location = this.getLocationOnScreen();
            Dimension screenSize = this.getToolkit().getScreenSize();
            int maxWidth = (int)(screenSize.getWidth() - location.getX());
            int maxHeight = (int)(screenSize.getHeight() - location.getY());
            Dimension scrollerSize = this.m_Scroller.getPreferredSize();
            int height = (int)scrollerSize.getHeight();
            int width = (int)scrollerSize.getWidth();
            if (width > maxWidth) {
                width = maxWidth;
            }
            if (height > maxHeight) {
                height = maxHeight;
            }
            this.m_Scroller.setPreferredSize(new Dimension(width, height));
            this.revalidate();
            this.pack();
        }
    }
}

