/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Variables;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.flow.control.StorageName;
import adams.flow.source.StorageValue;
import adams.flow.standalone.GlobalActors;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.flow.tree.Node;
import adams.gui.goe.FlowHelper;
import adams.gui.goe.PropertySheetPanel;
import adams.gui.goe.actorpathtree.ActorPathNode;
import adams.gui.goe.globalactorstree.GlobalActorsTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;

public class VariableSupport {
    public static final String CAPTION_INDICATOR = "*";
    public static final String HINT_INDICATOR = ", variable: ";

    public static PropertySheetPanel findParent(Container c) {
        return (PropertySheetPanel)GUIHelper.getParent(c, PropertySheetPanel.class);
    }

    public static boolean hasVariable(PropertySheetPanel parent, PropertyEditor editor) {
        if (parent != null) {
            return parent.findOption(editor) != null;
        }
        return false;
    }

    public static JPopupMenu createPopup(PropertySheetPanel parent, PropertyEditor editor) {
        AbstractOption option;
        JPopupMenu result = null;
        if (parent != null && (option = parent.findOption(editor)) != null) {
            result = VariableSupport.updatePopup(parent, editor, new JPopupMenu());
        }
        return result;
    }

    protected static String getGlobalActor(TreePath path) {
        ActorPathNode global;
        BaseTreeNode node;
        String result = null;
        if (path != null && (node = (BaseTreeNode)path.getLastPathComponent()) instanceof ActorPathNode && (global = (ActorPathNode)node).hasClassname()) {
            result = global.getLabel();
        }
        return result;
    }

    protected static String selectGlobalActor(Container parent, Vector<Node> nodes, String current) {
        Vector<String> list = new Vector<String>();
        for (Node node : nodes) {
            list.add(node.getFullName());
            for (int i = 0; i < node.getChildCount(); ++i) {
                Node child = (Node)node.getChildAt(i);
                list.add(child.getFullName());
            }
        }
        if (list.size() == 0) {
            GUIHelper.showErrorMessage(parent, "No global actors found!");
            return null;
        }
        return VariableSupport.selectGlobalActor(parent, list, current);
    }

    protected static String selectGlobalActor(Container parent, List<String> actors, String current) {
        String result = null;
        if (actors.size() == 0) {
            return result;
        }
        final StringBuilder selected = new StringBuilder();
        final BaseDialog dlg = GUIHelper.getParentDialog(parent) != null ? new BaseDialog(GUIHelper.getParentDialog(parent), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(GUIHelper.getParentFrame(parent), true);
        dlg.setTitle("Global actor");
        JPanel panelTree = new JPanel(new BorderLayout(0, 5));
        panelTree.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        final GlobalActorsTree tree = new GlobalActorsTree();
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
                if (MouseUtils.isDoubleClick(e)) {
                    if (VariableSupport.getGlobalActor(selPath) != null) {
                        selected.append(VariableSupport.getGlobalActor(selPath));
                    }
                    dlg.setVisible(false);
                    e.consume();
                }
                if (!e.isConsumed()) {
                    super.mousePressed(e);
                }
            }
        });
        tree.setFlowTree(FlowHelper.getTree(parent));
        tree.setItems(actors);
        tree.expandAll();
        if (current != null) {
            tree.selectNodeByName(current);
        }
        panelTree.add((Component)new BaseScrollPane(tree), "Center");
        panelTree.add((Component)new JLabel("Select global actor:"), "North");
        JPanel panelAll = new JPanel(new BorderLayout());
        panelTree.add((Component)panelAll, "South");
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "Center");
        final JTextField textValue = new JTextField(20);
        textValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    selected.append(textValue.getText());
                    dlg.setVisible(false);
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    dlg.setVisible(false);
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Manual reference");
        label.setDisplayedMnemonic('M');
        label.setLabelFor(textValue);
        panel.add(label);
        panel.add(textValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VariableSupport.getGlobalActor(tree.getSelectionPath()) != null) {
                    selected.append(VariableSupport.getGlobalActor(tree.getSelectionPath()));
                } else if (textValue.getText().length() > 0) {
                    selected.append(textValue.getText());
                }
                dlg.setVisible(false);
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
            }
        });
        panelButtons.add(buttonClose);
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add((Component)panelTree, "Center");
        dlg.pack();
        dlg.setLocationRelativeTo(parent);
        dlg.setVisible(true);
        if (selected.length() > 0) {
            result = selected.toString();
        }
        return result;
    }

    public static JPopupMenu updatePopup(final PropertySheetPanel parent, PropertyEditor editor, JPopupMenu menu) {
        AbstractArgumentOption argoption;
        JPopupMenu result = menu;
        if (parent == null) {
            return result;
        }
        AbstractOption option = parent.findOption(editor);
        JLabel label = parent.findLabel(editor);
        if (option instanceof AbstractArgumentOption && !(argoption = (AbstractArgumentOption)option).isMultiple()) {
            final AbstractArgumentOption fArgOption = argoption;
            final JLabel fLabel = label;
            final PropertySheetPanel fParent = parent;
            if (result.getComponentCount() > 0) {
                result.addSeparator();
            }
            if (!argoption.isVariableAttached()) {
                JMenuItem item = new JMenuItem("Set variable...", GUIHelper.getIcon("variable.gif"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String name = JOptionPane.showInputDialog(fParent, (Object)"Please enter the variable name:");
                        if (name == null) {
                            return;
                        }
                        if (!Variables.isValidName(name)) {
                            GUIHelper.showErrorMessage(fParent, "Not a valid variable name: " + name + "\n" + "Allowed characters:\n" + "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789:.");
                            return;
                        }
                        fArgOption.setVariable(name);
                        VariableSupport.updateLabel(fLabel, fArgOption.getVariableName());
                        parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                    }
                });
                result.add(item);
                item = new JMenuItem("Attach global actor...", GUIHelper.getIcon(GlobalActors.class.getName() + ".gif"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Vector<Node> nodes = FlowHelper.findTopGlobalActors(fParent);
                        String name = VariableSupport.selectGlobalActor((Container)fParent, nodes, null);
                        if (name == null) {
                            return;
                        }
                        fArgOption.setVariable("global:" + name);
                        VariableSupport.updateLabel(fLabel, fArgOption.getVariableName());
                        parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                    }
                });
                result.add(item);
                item = new JMenuItem("Attach storage value...", GUIHelper.getIcon(StorageValue.class.getName() + ".gif"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String name = JOptionPane.showInputDialog(fParent, (Object)"Please enter the storage name:");
                        if (name == null) {
                            return;
                        }
                        StorageName sn = new StorageName();
                        if (!sn.isValid(name)) {
                            GUIHelper.showErrorMessage(fParent, "Not a valid storage name: " + name + "!");
                            return;
                        }
                        fArgOption.setVariable("storage:" + name);
                        VariableSupport.updateLabel(fLabel, fArgOption.getVariableName());
                        parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                    }
                });
                result.add(item);
            } else {
                JMenuItem item;
                if (fArgOption.getVariableName().startsWith("global:")) {
                    item = new JMenuItem("Re-attach global actor...", GUIHelper.getIcon(GlobalActors.class.getName() + ".gif"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Vector<Node> nodes = FlowHelper.findTopGlobalActors(fParent);
                            String name = VariableSupport.selectGlobalActor((Container)fParent, nodes, fArgOption.getVariableName().substring("global:".length()));
                            if (name == null) {
                                return;
                            }
                            fArgOption.setVariable("global:" + name);
                            VariableSupport.updateLabel(fLabel, fArgOption.getVariableName());
                            parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                        }
                    });
                    result.add(item);
                } else if (fArgOption.getVariableName().startsWith("storage:")) {
                    item = new JMenuItem("Re-attach storage value...", GUIHelper.getIcon(StorageValue.class.getName() + ".gif"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String oldName = fArgOption.getVariableName().substring("storage:".length());
                            String name = JOptionPane.showInputDialog(fParent, "Please enter the new storage value name:", oldName);
                            if (name == null) {
                                return;
                            }
                            StorageName sn = new StorageName();
                            if (!sn.isValid(name)) {
                                GUIHelper.showErrorMessage(fParent, "Not a valid storage name: " + name + "!");
                                return;
                            }
                            fArgOption.setVariable("storage:" + name);
                            VariableSupport.updateLabel(fLabel, fArgOption.getVariableName());
                            parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                        }
                    });
                    result.add(item);
                } else {
                    item = new JMenuItem("Change variable '" + fArgOption.getVariableName() + "'...", GUIHelper.getIcon("variable.gif"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String oldName = fArgOption.getVariableName();
                            String name = JOptionPane.showInputDialog(fParent, "Please enter the new variable name:", oldName);
                            if (name == null) {
                                return;
                            }
                            if (!Variables.isValidName(name)) {
                                GUIHelper.showErrorMessage(fParent, "Not a valid variable name: " + name + "\n" + "Allowed characters:\n" + "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789:.");
                                return;
                            }
                            fArgOption.setVariable(name);
                            VariableSupport.updateLabel(fLabel, fArgOption.getVariableName());
                            parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                        }
                    });
                    result.add(item);
                }
                item = fArgOption.getVariableName().startsWith("global:") ? new JMenuItem("Detach global actor '" + argoption.getVariableName().substring("global:".length()) + "'", GUIHelper.getIcon("delete.gif")) : (fArgOption.getVariableName().startsWith("storage:") ? new JMenuItem("Detach storage value '" + argoption.getVariableName().substring("storage:".length()) + "'", GUIHelper.getIcon("delete.gif")) : new JMenuItem("Remove variable '" + argoption.getVariableName() + "'", GUIHelper.getIcon("delete.gif")));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fArgOption.setVariable(null);
                        VariableSupport.updateLabel(fLabel, null);
                        parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                    }
                });
                result.add(item);
            }
        }
        return result;
    }

    public static void updateLabel(JLabel label, String variable) {
        boolean hasVariable = variable != null;
        String text = label.getText();
        boolean hintPresent = text.endsWith(CAPTION_INDICATOR);
        if (hintPresent) {
            text = text.substring(0, text.length() - CAPTION_INDICATOR.length());
        }
        if (hasVariable) {
            text = text + CAPTION_INDICATOR;
        }
        label.setText(text);
        text = label.getToolTipText();
        boolean bl = hintPresent = text.indexOf(HINT_INDICATOR) > -1;
        if (hintPresent) {
            text = text.substring(0, text.indexOf(HINT_INDICATOR));
        }
        if (hasVariable) {
            text = text + HINT_INDICATOR + variable;
        }
        label.setToolTipText(text);
    }
}

