/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.License;
import adams.core.Properties;
import adams.core.annotation.MixedCopyright;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

@MixedCopyright(copyright="Rob Camick, David Underhill", license=License.APACHE2, url="http://www.dound.com/src/MultiSyntaxDocument.java and https://forums.oracle.com/forums/thread.jspa?threadID=2103230&tstart=107655", note="Rob Camick released code in public domain, David Underhill the modifications under Apache 2")
public class SyntaxDocument
extends DefaultStyledDocument {
    protected static final long serialVersionUID = -3642426465631271381L;
    public static final int MAX_TABS = 35;
    public static final String DEFAULT_FONT_FAMILY = "monospaced";
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final SimpleAttributeSet DEFAULT_NORMAL = new SimpleAttributeSet();
    public static final SimpleAttributeSet DEFAULT_COMMENT;
    public static final SimpleAttributeSet DEFAULT_STRING;
    public static final SimpleAttributeSet DEFAULT_KEYWORD;
    protected DefaultStyledDocument m_Self = this;
    protected Element m_RootElement = this.m_Self.getDefaultRootElement();
    protected boolean m_InsideMultiLineComment;
    protected HashMap<String, MutableAttributeSet> m_Keywords = new HashMap();
    protected String m_Delimiters;
    protected String m_QuoteDelimiters;
    protected String m_QuoteEscape;
    protected String m_MultiLineCommentStart;
    protected String m_MultiLineCommentEnd;
    protected String m_SingleLineCommentStart;
    protected String m_BlockStart;
    protected String m_BlockEnd;
    protected int m_FontSize = 12;
    protected String m_FontName = "monospaced";
    protected Color m_BackgroundColor;
    protected String m_Indentation;
    protected boolean m_AddMatchingEndBlocks;
    protected boolean m_UseBlanks;
    protected boolean m_MultiLineComment;
    protected boolean m_CaseSensitive;

    public SyntaxDocument(Properties props) {
        this.putProperty("__EndOfLine__", "\n");
        this.setup(props);
    }

    protected void setup(Properties props) {
        this.setDelimiters(props.getProperty("Delimiters", ";:{}()[]+-/%<=>!&|^~*"));
        this.setQuoteDelimiters(props.getProperty("QuoteDelimiters", "\"'"));
        this.setQuoteEscape(props.getProperty("QuoteEscape", "\\"));
        this.setSingleLineCommentStart(props.getProperty("SingleLineCommentStart", "//"));
        this.setMultiLineComment(props.getBoolean("MultiLineComment", false));
        this.setMultiLineCommentStart(props.getProperty("MultiLineCommentStart", "/*"));
        this.setMultiLineCommentEnd(props.getProperty("MultiLineCommentEnd", "*/"));
        this.setBlockStart(props.getProperty("BlockStart", "{"));
        this.setBlockEnd(props.getProperty("BlockEnd", "}"));
        this.setAddMatchingEndBlocks(props.getBoolean("AddMatchingBlockEnd", false));
        this.setUseBlanks(props.getBoolean("UseBlanks", false));
        this.setCaseSensitive(props.getBoolean("CaseSensitive", true));
        this.addKeywords(props.getProperty("Keywords", "").trim().replaceAll(" ", "").split(","), DEFAULT_KEYWORD);
        this.setTabs(props.getInteger("Tabs", 2));
        SyntaxDocument.setAttributeColor(DEFAULT_NORMAL, props.getColor("ForegroundColor", Color.BLACK));
        SyntaxDocument.setAttributeColor(DEFAULT_COMMENT, props.getColor("CommentColor", Color.GRAY));
        SyntaxDocument.setAttributeColor(DEFAULT_STRING, props.getColor("StringColor", Color.RED));
        SyntaxDocument.setAttributeColor(DEFAULT_KEYWORD, props.getColor("KeywordColor", Color.BLUE));
        this.setBackgroundColor(props.getColor("BackgroundColor", Color.WHITE));
        this.setFontName(props.getProperty("FontName", DEFAULT_FONT_FAMILY));
        this.setFontSize(Integer.parseInt(props.getProperty("FontSize", "12")));
        this.setIndentationSize(Integer.parseInt(props.getProperty("Indentation", "2")));
    }

    public void setAttributeFont(ATTR_TYPE attr, int style) {
        Font f = new Font(this.m_FontName, style, this.m_FontSize);
        if (attr == ATTR_TYPE.Comment) {
            SyntaxDocument.setAttributeFont(DEFAULT_COMMENT, f);
        } else if (attr == ATTR_TYPE.Quote) {
            SyntaxDocument.setAttributeFont(DEFAULT_STRING, f);
        } else {
            SyntaxDocument.setAttributeFont(DEFAULT_NORMAL, f);
        }
    }

    public static void setAttributeFont(MutableAttributeSet attr, Font f) {
        StyleConstants.setBold(attr, f.isBold());
        StyleConstants.setItalic(attr, f.isItalic());
        StyleConstants.setFontFamily(attr, f.getFamily());
        StyleConstants.setFontSize(attr, f.getSize());
    }

    public void setAttributeColor(ATTR_TYPE attr, Color c) {
        if (attr == ATTR_TYPE.Comment) {
            SyntaxDocument.setAttributeColor(DEFAULT_COMMENT, c);
        } else if (attr == ATTR_TYPE.Quote) {
            SyntaxDocument.setAttributeColor(DEFAULT_STRING, c);
        } else {
            SyntaxDocument.setAttributeColor(DEFAULT_NORMAL, c);
        }
    }

    public static void setAttributeColor(MutableAttributeSet attr, Color c) {
        StyleConstants.setForeground(attr, c);
    }

    public void addKeywords(String[] keywords, MutableAttributeSet attr) {
        for (int i = 0; i < keywords.length; ++i) {
            this.addKeyword(keywords[i], attr);
        }
    }

    public void addKeyword(String keyword, MutableAttributeSet attr) {
        if (this.m_CaseSensitive) {
            this.m_Keywords.put(keyword, attr);
        } else {
            this.m_Keywords.put(keyword.toLowerCase(), attr);
        }
    }

    public MutableAttributeSet getKeywordFormatting(String keyword) {
        if (this.m_CaseSensitive) {
            return this.m_Keywords.get(keyword);
        }
        return this.m_Keywords.get(keyword.toLowerCase());
    }

    public void removeKeyword(String keyword) {
        if (this.m_CaseSensitive) {
            this.m_Keywords.remove(keyword);
        } else {
            this.m_Keywords.remove(keyword.toLowerCase());
        }
    }

    public void setTabs(int charactersPerTab) {
        Font f = new Font(this.m_FontName, 0, this.m_FontSize);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * charactersPerTab;
        TabStop[] tabs = new TabStop[35];
        for (int j = 0; j < tabs.length; ++j) {
            tabs[j] = new TabStop((j + 1) * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        int length = this.getLength();
        this.setParagraphAttributes(0, length, attributes, false);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (this.m_AddMatchingEndBlocks && this.m_BlockStart.length() > 0 && str.equals(this.m_BlockStart)) {
            str = this.addMatchingBlockEnd(offset);
        } else if (this.m_UseBlanks && str.equals("\t")) {
            str = this.m_Indentation;
        }
        super.insertString(offset, str, a);
        this.processChangedLines(offset, str.length());
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.m_Self.getText(0, this.m_Self.getLength());
        int startLine = this.m_RootElement.getElementIndex(offset);
        int endLine = this.m_RootElement.getElementIndex(offset + length);
        if (this.getMultiLineComment()) {
            this.setInsideMultiLineComment(this.commentLinesBefore(content, startLine));
        }
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    protected boolean commentLinesBefore(String content, int line) {
        int offset = this.m_RootElement.getElement(line).getStartOffset();
        int startDelimiter = -1;
        if (this.getMultiLineComment()) {
            startDelimiter = this.lastIndexOf(content, this.getMultiLineCommentStart(), offset - 2);
        }
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getMultiLineCommentEnd(), startDelimiter);
        if (endDelimiter < offset & endDelimiter != -1) {
            return false;
        }
        this.m_Self.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, DEFAULT_COMMENT, false);
        return true;
    }

    protected void commentLinesAfter(String content, int line) {
        int offset = this.m_RootElement.getElement(line).getEndOffset();
        int endDelimiter = -1;
        if (this.getMultiLineComment()) {
            endDelimiter = this.indexOf(content, this.getMultiLineCommentEnd(), offset);
        }
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getMultiLineCommentStart(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.m_Self.setCharacterAttributes(offset, endDelimiter - offset + 1, DEFAULT_COMMENT, false);
        }
    }

    protected void highlightLinesAfter(String content, int line) throws BadLocationException {
        int delimiter;
        int offset = this.m_RootElement.getElement(line).getEndOffset();
        int startDelimiter = -1;
        int endDelimiter = -1;
        if (this.getMultiLineComment()) {
            startDelimiter = this.indexOf(content, this.getMultiLineCommentStart(), offset);
            endDelimiter = this.indexOf(content, this.getMultiLineCommentEnd(), offset);
        }
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this.m_RootElement.getElementIndex(delimiter);
        for (int i = line + 1; i < endLine; ++i) {
            Element branch = this.m_RootElement.getElement(i);
            Element leaf = this.m_Self.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes();
            if (!as.isEqual(DEFAULT_COMMENT)) continue;
            this.applyHighlighting(content, i);
        }
    }

    protected void applyHighlighting(String content, int line) throws BadLocationException {
        int startOffset = this.m_RootElement.getElement(line).getStartOffset();
        int endOffset = this.m_RootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.getMultiLineComment() && (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset))) {
            this.m_Self.setCharacterAttributes(startOffset, endOffset - startOffset + 1, DEFAULT_COMMENT, false);
            return;
        }
        this.m_Self.setCharacterAttributes(startOffset, lineLength, DEFAULT_NORMAL, true);
        int index = content.indexOf(this.getSingleLineCommentStart(), startOffset);
        if (index > -1 && index < endOffset) {
            this.m_Self.setCharacterAttributes(index, endOffset - index + 1, DEFAULT_COMMENT, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    protected boolean startingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        if (!this.getMultiLineComment()) {
            return false;
        }
        int index = this.indexOf(content, this.getMultiLineCommentStart(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setInsideMultiLineComment(true);
        return true;
    }

    protected boolean endingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        if (!this.getMultiLineComment()) {
            return false;
        }
        int index = this.indexOf(content, this.getMultiLineCommentEnd(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setInsideMultiLineComment(false);
        return true;
    }

    protected boolean isMultiLineComment() {
        return this.m_InsideMultiLineComment;
    }

    protected void setInsideMultiLineComment(boolean value) {
        this.m_InsideMultiLineComment = value;
    }

    protected void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    protected int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.escapeQuote(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.m_Self.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, DEFAULT_STRING, false);
        return endOfQuote + 1;
    }

    protected int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        MutableAttributeSet attr = this.getKeywordFormatting(token);
        if (attr != null) {
            this.m_Self.setCharacterAttributes(startOffset, endOfToken - startOffset, attr, false);
        }
        return endOfToken + 1;
    }

    protected int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    protected int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    protected String getLine(String content, int offset) {
        int line = this.m_RootElement.getElementIndex(offset);
        Element lineElement = this.m_RootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    public boolean isDelimiter(String character) {
        return Character.isWhitespace(character.charAt(0)) || this.m_Delimiters.indexOf(character.charAt(0)) > -1;
    }

    public boolean isQuoteDelimiter(String character) {
        return this.m_QuoteDelimiters.indexOf(character.charAt(0)) > -1;
    }

    public String escapeQuote(String quoteDelimiter) {
        return this.m_QuoteEscape + quoteDelimiter;
    }

    protected String addMatchingBlockEnd(int offset) throws BadLocationException {
        String temp;
        StringBuilder whiteSpace = new StringBuilder();
        int line = this.m_RootElement.getElementIndex(offset);
        int i = this.m_RootElement.getElement(line).getStartOffset();
        while ((temp = this.m_Self.getText(i, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i;
        }
        StringBuilder result = new StringBuilder();
        result.append(this.m_BlockStart);
        result.append("\n");
        result.append(whiteSpace.toString());
        if (this.m_UseBlanks) {
            result.append(this.m_Indentation);
        } else {
            result.append("\t");
        }
        result.append("\n");
        result.append(whiteSpace.toString());
        result.append(this.m_BlockEnd);
        return result.toString();
    }

    public int getFontSize() {
        return this.m_FontSize;
    }

    public void setFontSize(int fontSize) {
        this.m_FontSize = fontSize;
        StyleConstants.setFontSize(DEFAULT_NORMAL, fontSize);
        StyleConstants.setFontSize(DEFAULT_STRING, fontSize);
        StyleConstants.setFontSize(DEFAULT_COMMENT, fontSize);
    }

    public String getFontName() {
        return this.m_FontName;
    }

    public void setFontName(String fontName) {
        this.m_FontName = fontName;
        StyleConstants.setFontFamily(DEFAULT_NORMAL, fontName);
        StyleConstants.setFontFamily(DEFAULT_STRING, fontName);
        StyleConstants.setFontFamily(DEFAULT_COMMENT, fontName);
    }

    public void setIndentationSize(int value) {
        this.m_Indentation = "";
        for (int i = 0; i < value; ++i) {
            this.m_Indentation = this.m_Indentation + " ";
        }
    }

    public int getIndentationSize() {
        return this.m_Indentation.length();
    }

    public void setDelimiters(String value) {
        this.m_Delimiters = value;
    }

    public String getDelimiters() {
        return this.m_Delimiters;
    }

    public void setQuoteDelimiters(String value) {
        this.m_QuoteDelimiters = value;
    }

    public String getQuoteDelimiters() {
        return this.m_QuoteDelimiters;
    }

    public void setQuoteEscape(String value) {
        this.m_QuoteEscape = value;
    }

    public String getQuoteEscape() {
        return this.m_QuoteEscape;
    }

    public void setSingleLineCommentStart(String value) {
        this.m_SingleLineCommentStart = value;
    }

    public String getSingleLineCommentStart() {
        return this.m_SingleLineCommentStart;
    }

    public void setMultiLineCommentStart(String value) {
        this.m_MultiLineCommentStart = value;
    }

    public String getMultiLineCommentStart() {
        return this.m_MultiLineCommentStart;
    }

    public void setMultiLineCommentEnd(String value) {
        this.m_MultiLineCommentEnd = value;
    }

    public String getMultiLineCommentEnd() {
        return this.m_MultiLineCommentEnd;
    }

    public void setBlockStart(String value) {
        this.m_BlockStart = value;
    }

    public String getBlockStart() {
        return this.m_BlockStart;
    }

    public void setBlockEnd(String value) {
        this.m_BlockEnd = value;
    }

    public String getBlockEnd() {
        return this.m_BlockEnd;
    }

    public void setAddMatchingEndBlocks(boolean value) {
        this.m_AddMatchingEndBlocks = value;
    }

    public boolean getAddMatchingEndBlocks() {
        return this.m_AddMatchingEndBlocks;
    }

    public void setUseBlanks(boolean value) {
        this.m_UseBlanks = value;
    }

    public boolean getUseBlanks() {
        return this.m_UseBlanks;
    }

    public void setBackgroundColor(Color value) {
        this.m_BackgroundColor = value;
    }

    public Color getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    public void setMultiLineComment(boolean value) {
        this.m_MultiLineComment = value;
    }

    public boolean getMultiLineComment() {
        return this.m_MultiLineComment;
    }

    public void setCaseSensitive(boolean value) {
        this.m_CaseSensitive = value;
    }

    public boolean getCaseSensitive() {
        return this.m_CaseSensitive;
    }

    static {
        StyleConstants.setForeground(DEFAULT_NORMAL, Color.BLACK);
        StyleConstants.setFontFamily(DEFAULT_NORMAL, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_NORMAL, 12);
        DEFAULT_COMMENT = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_COMMENT, Color.GRAY);
        StyleConstants.setFontFamily(DEFAULT_COMMENT, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_COMMENT, 12);
        DEFAULT_STRING = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_STRING, Color.RED);
        StyleConstants.setFontFamily(DEFAULT_STRING, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_STRING, 12);
        DEFAULT_KEYWORD = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_KEYWORD, Color.BLUE);
        StyleConstants.setBold(DEFAULT_KEYWORD, false);
        StyleConstants.setFontFamily(DEFAULT_KEYWORD, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_KEYWORD, 12);
    }

    public static enum ATTR_TYPE {
        Normal,
        Comment,
        Quote;

    }
}

