/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.MouseMovementTracker;
import adams.gui.visualization.core.Paintlet;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class MultiMouseMovementTracker
extends AbstractPaintlet
implements MouseMovementTracker {
    private static final long serialVersionUID = -6562614432508466918L;
    protected MouseMovementTracker[] m_Trackers;

    @Override
    public String globalInfo() {
        return "Applies multiple trackers sequentially.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tracker", "trackers", new MouseMovementTracker[0]);
    }

    public void setTrackers(MouseMovementTracker[] value) {
        this.m_Trackers = value;
        this.reset();
    }

    public MouseMovementTracker[] getTrackers() {
        return this.m_Trackers;
    }

    public String trackersTipText() {
        return "The mouse movement trackers to apply.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.POST_PAINT;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        for (MouseMovementTracker tracker : this.m_Trackers) {
            if (!(tracker instanceof Paintlet)) continue;
            ((Paintlet)((Object)tracker)).paint(g);
        }
    }

    @Override
    public void mouseMovementTracked(MouseEvent e) {
        boolean paintlet = false;
        for (MouseMovementTracker tracker : this.m_Trackers) {
            if (tracker instanceof Paintlet) {
                paintlet = true;
                continue;
            }
            tracker.mouseMovementTracked(e);
        }
        if (paintlet) {
            this.getPanel().getPlot().getContent().repaint();
        }
    }

    @Override
    public MouseMovementTracker shallowCopyTracker() {
        return (MouseMovementTracker)((Object)this.shallowCopy());
    }

    @Override
    public MouseMovementTracker shallowCopyTracker(boolean expand) {
        return (MouseMovementTracker)((Object)this.shallowCopy(expand));
    }
}

