/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug;

import adams.core.DiffUtils;
import adams.core.io.PlaceholderFile;
import adams.gui.action.AbstractBaseAction;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.ToolBarPanel;
import adams.gui.visualization.debug.DiffTextPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SideBySideDiffPanel
extends ToolBarPanel {
    private static final long serialVersionUID = -7728182993462886323L;
    protected DiffTextPane m_TextLeft;
    protected BaseScrollPane m_ScrollPaneLeft;
    protected BasePanel m_PanelLeft;
    protected JLabel m_LabelLeft;
    protected DiffTextPane m_TextRight;
    protected BaseScrollPane m_ScrollPaneRight;
    protected BasePanel m_PanelRight;
    protected JLabel m_LabelRight;
    protected BasePanel m_PanelAll;
    protected boolean m_IgnoreViewportChangesLeft;
    protected boolean m_IgnoreViewportChangesRight;
    protected File m_LastFileLeft;
    protected File m_LastFileRight;
    protected AbstractBaseAction m_ActionFirstDiff;
    protected AbstractBaseAction m_ActionLastDiff;
    protected AbstractBaseAction m_ActionNextDiff;
    protected AbstractBaseAction m_ActionPreviousDiff;

    @Override
    protected void initialize() {
        super.initialize();
        this.resetLastFiles();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelAll = new BasePanel(new GridLayout(1, 2));
        this.add((Component)this.m_PanelAll, "Center");
        this.m_TextLeft = new DiffTextPane();
        this.m_TextLeft.setLeft(true);
        this.m_ScrollPaneLeft = new BaseScrollPane(this.m_TextLeft);
        this.m_ScrollPaneLeft.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SideBySideDiffPanel.this.m_IgnoreViewportChangesLeft) {
                    return;
                }
                SideBySideDiffPanel.this.m_IgnoreViewportChangesRight = true;
                SideBySideDiffPanel.this.m_ScrollPaneRight.getViewport().setViewPosition(SideBySideDiffPanel.this.m_ScrollPaneLeft.getViewport().getViewPosition());
                SideBySideDiffPanel.this.m_IgnoreViewportChangesRight = false;
            }
        });
        this.m_LabelLeft = new JLabel("Left");
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_LabelLeft);
        this.m_PanelLeft = new BasePanel(new BorderLayout());
        this.m_PanelLeft.add((Component)panel, "North");
        this.m_PanelLeft.add((Component)this.m_ScrollPaneLeft, "Center");
        this.m_PanelAll.add(this.m_PanelLeft);
        this.m_TextRight = new DiffTextPane();
        this.m_TextRight.setLeft(false);
        this.m_ScrollPaneRight = new BaseScrollPane(this.m_TextRight);
        this.m_ScrollPaneRight.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SideBySideDiffPanel.this.m_IgnoreViewportChangesRight) {
                    return;
                }
                SideBySideDiffPanel.this.m_IgnoreViewportChangesLeft = true;
                SideBySideDiffPanel.this.m_ScrollPaneLeft.getViewport().setViewPosition(SideBySideDiffPanel.this.m_ScrollPaneRight.getViewport().getViewPosition());
                SideBySideDiffPanel.this.m_IgnoreViewportChangesLeft = false;
            }
        });
        this.m_LabelRight = new JLabel("Right");
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_LabelRight);
        this.m_PanelRight = new BasePanel(new BorderLayout());
        this.m_PanelRight.add((Component)panel, "North");
        this.m_PanelRight.add((Component)this.m_ScrollPaneRight, "Center");
        this.m_PanelAll.add(this.m_PanelRight);
    }

    protected void resetLastFiles() {
        this.m_LastFileLeft = new PlaceholderFile(".");
        this.m_LastFileRight = new PlaceholderFile(".");
    }

    public BasePanel getPanel(boolean left) {
        if (left) {
            return this.m_PanelLeft;
        }
        return this.m_PanelRight;
    }

    public DiffTextPane getDiffTextPane(boolean left) {
        if (left) {
            return this.m_TextLeft;
        }
        return this.m_TextRight;
    }

    public void setLabelText(boolean left, String text) {
        if (left) {
            this.m_LabelLeft.setText(text);
        } else {
            this.m_LabelRight.setText(text);
        }
    }

    public String getLabelText(boolean left) {
        if (left) {
            return this.m_LabelLeft.getText();
        }
        return this.m_LabelRight.getText();
    }

    public void compare(File file1, File file2) {
        this.m_LastFileLeft = file1;
        this.m_LastFileRight = file2;
        this.display(DiffUtils.sideBySide(file1, file2));
    }

    public void compare(String[] list1, String[] list2) {
        this.resetLastFiles();
        this.display(DiffUtils.sideBySide(list1, list2));
    }

    public void compare(List<String> list1, List<String> list2) {
        this.resetLastFiles();
        this.display(DiffUtils.sideBySide(list1, list2));
    }

    public void updateLeft(File file) {
        this.m_LastFileLeft = file;
        this.display(DiffUtils.sideBySide(this.m_LastFileLeft, this.m_LastFileRight));
    }

    public void updateRight(File file) {
        this.m_LastFileRight = file;
        this.display(DiffUtils.sideBySide(this.m_LastFileLeft, this.m_LastFileRight));
    }

    public void clear() {
        this.resetLastFiles();
        this.display(new DiffUtils.SideBySideDiff());
    }

    public void display(DiffUtils.SideBySideDiff diff) {
        this.m_TextLeft.setDiff(diff);
        this.m_TextRight.setDiff(diff);
        this.updateActions();
        this.firstDiff();
    }

    public DiffUtils.SideBySideDiff getCurrent() {
        return this.m_TextLeft.getDiff();
    }

    public void firstDiff() {
        this.m_TextLeft.gotoLine(this.getCurrent().deltaToLine(0, true));
        this.updateActions();
    }

    public void lastDiff() {
        this.m_TextLeft.gotoLine(this.getCurrent().deltaToLine(this.getCurrent().differences() - 1, true));
        this.updateActions();
    }

    public void nextDiff() {
        this.m_TextLeft.gotoLine(this.getCurrent().deltaToLine(this.getCurrent().getNextDelta(this.m_TextLeft.caretToLine(this.m_TextLeft.getCaretPosition())), true));
        this.updateActions();
    }

    public void previousDiff() {
        this.m_TextLeft.gotoLine(this.getCurrent().deltaToLine(this.getCurrent().getPreviousDelta(this.m_TextLeft.caretToLine(this.m_TextLeft.getCaretPosition())), true));
        this.updateActions();
    }

    @Override
    protected void initActions() {
        this.m_ActionFirstDiff = new AbstractBaseAction("First", GUIHelper.getIcon("diff_first.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideBySideDiffPanel.this.firstDiff();
            }
        };
        this.m_ActionLastDiff = new AbstractBaseAction("Last", GUIHelper.getIcon("diff_last.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideBySideDiffPanel.this.lastDiff();
            }
        };
        this.m_ActionNextDiff = new AbstractBaseAction("Next", GUIHelper.getIcon("diff_next.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideBySideDiffPanel.this.nextDiff();
            }
        };
        this.m_ActionPreviousDiff = new AbstractBaseAction("Previous", GUIHelper.getIcon("diff_prev.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideBySideDiffPanel.this.previousDiff();
            }
        };
    }

    @Override
    protected void initToolBar() {
        this.addToToolBar(this.m_ActionFirstDiff);
        this.addToToolBar(this.m_ActionPreviousDiff);
        this.addToToolBar(this.m_ActionNextDiff);
        this.addToToolBar(this.m_ActionLastDiff);
    }

    @Override
    protected void updateActions() {
        int line = this.m_TextLeft.caretToLine(this.m_TextLeft.getCaretPosition());
        this.m_ActionFirstDiff.setEnabled(this.getCurrent().hasDifferences());
        this.m_ActionPreviousDiff.setEnabled(this.getCurrent().hasDifferences() && this.getCurrent().hasPreviousDelta(line));
        this.m_ActionNextDiff.setEnabled(this.getCurrent().hasDifferences() && this.getCurrent().hasNextDelta(line));
        this.m_ActionLastDiff.setEnabled(this.getCurrent().hasDifferences());
    }
}

