/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.webservice.AbstractWebServiceClientSource;
import adams.flow.webservice.GlobalTransformerSupport;

public abstract class AbstractWebServiceClientSourceWithGlobalTransformer<O>
extends AbstractWebServiceClientSource<O>
implements GlobalTransformerSupport<O, O> {
    private static final long serialVersionUID = -3505197925715473652L;
    protected GlobalActorReference m_Transformer;
    protected AbstractActor m_ActualTransformer;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformer", (Object)new GlobalActorReference());
    }

    @Override
    public void setTransformer(GlobalActorReference value) {
        this.m_Transformer = value;
        this.reset();
    }

    @Override
    public GlobalActorReference getTransformer() {
        return this.m_Transformer;
    }

    @Override
    public String transformerTipText() {
        return "The global transformer to use for further processing the data.";
    }

    @Override
    protected void preQuery() throws Exception {
        super.preQuery();
        if (this.m_ActualTransformer == null) {
            GlobalActorHelper helper = new GlobalActorHelper();
            this.m_ActualTransformer = helper.findGlobalActorRecursive(this.getOwner(), this.m_Transformer);
            if (this.m_ActualTransformer == null) {
                throw new IllegalStateException("Failed to locate global transformer '" + this.m_Transformer + "'!");
            }
            if (!ActorUtils.isTransformer((AbstractActor)this.m_ActualTransformer)) {
                throw new IllegalStateException("Global actor '" + this.m_Transformer + "' is not a transformer!");
            }
        }
    }

    @Override
    public O applyTransformer(O data) throws Exception {
        ((InputConsumer)this.m_ActualTransformer).input(new Token(data));
        String msg = this.m_ActualTransformer.execute();
        if (msg != null) {
            throw new IllegalStateException("Failed to post-process response data: " + msg);
        }
        if (!((OutputProducer)this.m_ActualTransformer).hasPendingOutput()) {
            throw new IllegalStateException("Global transformer did not produce any data!");
        }
        Object result = ((OutputProducer)this.m_ActualTransformer).output().getPayload();
        if (((OutputProducer)this.m_ActualTransformer).hasPendingOutput()) {
            throw new IllegalStateException("Global transformer still has pending output!");
        }
        return (O)result;
    }
}

