/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.cache;

import de.intarsys.tools.cache.CacheEntry;
import de.intarsys.tools.component.ISynchronizable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<T>
implements ISynchronizable {
    private final Map<Object, CacheEntry<T>> map = new HashMap<Object, CacheEntry<T>>();
    private final CacheEntry<T>[] elements;
    private int ptr = 0;

    public Cache(int size) {
        this.elements = new CacheEntry[size];
    }

    public synchronized void clear() {
        this.map.clear();
        int i = 0;
        while (i < this.ptr) {
            this.elements[i] = null;
            ++i;
        }
        this.ptr = 0;
    }

    public synchronized T get(Object key) {
        ISynchronizable synch;
        CacheEntry<T> result = this.map.get(key);
        if (result != null && result.getValue() instanceof ISynchronizable && (synch = (ISynchronizable)result.getValue()).isOutOfSynch()) {
            this.remove(key);
            result = null;
        }
        if (result != null) {
            result.touch();
            return result.getValue();
        }
        return null;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    public synchronized void put(Object key, T value) {
        CacheEntry<T> entry = new CacheEntry<T>(key, value);
        if (this.ptr >= this.elements.length) {
            this.removeStrategy();
        }
        this.elements[this.ptr++] = entry;
        this.map.put(key, entry);
    }

    public synchronized void remove(Object key) {
        CacheEntry<T> entry = this.map.remove(key);
        int i = 0;
        while (i < this.ptr) {
            CacheEntry<T> current = this.elements[i];
            if (current == entry) {
                --this.ptr;
                if (i < this.ptr) {
                    System.arraycopy(this.elements, i + 1, this.elements, i, this.ptr - i);
                }
                this.elements[this.ptr] = null;
            }
            ++i;
        }
    }

    protected void removeStrategy() {
        Arrays.sort(this.elements, 0, this.ptr);
        --this.ptr;
        CacheEntry<T> entry = this.elements[this.ptr];
        this.map.remove(entry.getKey());
        this.elements[this.ptr] = null;
    }

    public synchronized int size() {
        return this.ptr;
    }

    @Override
    public synchronized void synch() {
        int i = 0;
        while (i < this.ptr) {
            CacheEntry<T> element = this.elements[i];
            if (element.getValue() instanceof ISynchronizable) {
                ((ISynchronizable)element.getValue()).synch();
            }
            ++i;
        }
    }
}

