/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractTemplate;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.template.DummySink;
import java.util.Hashtable;

public class TemplateSink
extends AbstractTemplate
implements InputConsumer {
    private static final long serialVersionUID = -1017031413702121257L;
    public static final String BACKUP_CURRENT = "current";
    protected transient Token m_CurrentInput;

    public String globalInfo() {
        return "Lets a sink generated from a template consume the input tokens.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentInput = null;
    }

    @Override
    protected AbstractActorTemplate getDefaultTemplate() {
        return new DummySink();
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_CURRENT, this.m_CurrentInput);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_CurrentInput = (Token)state.get(BACKUP_CURRENT);
            state.remove(BACKUP_CURRENT);
        }
        super.restoreState(state);
    }

    @Override
    protected String setUpTemplate() {
        String result = super.setUpTemplate();
        if (result == null && !ActorUtils.isSink((AbstractActor)this.m_Actor)) {
            result = "Template '" + this.m_Template + "' does not generate a sink actor: " + this.m_Actor;
        }
        return result;
    }

    public Class[] accepts() {
        if (this.m_Actor != null) {
            return ((InputConsumer)this.m_Actor).accepts();
        }
        return new Class[]{Unknown.class};
    }

    public void input(Token token) {
        this.m_CurrentInput = token;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Actor == null) {
            result = this.setUpTemplate();
        }
        if (result == null) {
            ((InputConsumer)this.m_Actor).input(this.m_CurrentInput);
            result = this.m_Actor.execute();
        }
        return result;
    }
}

