/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.Utils;
import adams.core.scripting.GroovyScript;
import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.template.AbstractScriptTemplate;

public class Groovy
extends AbstractScriptTemplate {
    private static final long serialVersionUID = 3861631532032659677L;
    protected GroovyScript m_InlineScript;

    public String globalInfo() {
        return "Uses a Groovy script to generate a sub-flow.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)this.getDefaultInlineScript());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("scriptFile");
        if (variable != null || !this.m_ScriptFile.isDirectory()) {
            return super.getQuickInfo();
        }
        variable = this.getOptionManager().getVariableForProperty("inlineScript");
        if (variable != null) {
            return variable;
        }
        return Utils.shorten((String)this.m_InlineScript.stringValue(), (int)50);
    }

    public String scriptOptionsTipText() {
        return "The options for the Groovy script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the Groovy actor.";
    }

    protected GroovyScript getDefaultInlineScript() {
        return new GroovyScript();
    }

    public void setInlineScript(GroovyScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public GroovyScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script, if not using an external script file.";
    }

    protected String loadScriptObject() {
        Object[] result = adams.core.scripting.Groovy.loadScriptObject(AbstractActorTemplate.class, this.m_ScriptFile, this.m_InlineScript, this.m_ScriptOptions);
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    protected String checkScriptObject() {
        return null;
    }

    protected AbstractActor executeScript() {
        return ((AbstractActorTemplate)this.m_ScriptObject).generate();
    }
}

