/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.filechooser;

import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public final class PopupHandler
extends MouseAdapter {
    private JTextComponent txt;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem copyItem;
    private JMenuItem pasteItem;
    private JMenuItem cutItem;
    private JMenuItem selectAllItem;
    private JMenuItem clearItem;
    private static final PopupHandler INSTANCE = new PopupHandler();

    private PopupHandler() {
        this.clearItem = new JMenuItem(VFSResources.getMessage("VFSJFileChooser.clearItemText"));
        this.copyItem = new JMenuItem(VFSResources.getMessage("VFSJFileChooser.copyItemText"));
        this.pasteItem = new JMenuItem(VFSResources.getMessage("VFSJFileChooser.pasteItemText"));
        this.cutItem = new JMenuItem(VFSResources.getMessage("VFSJFileChooser.cutItemText"));
        this.selectAllItem = new JMenuItem(VFSResources.getMessage("VFSJFileChooser.selectAllItemText"));
        this.cutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupHandler.this.txt.cut();
            }
        });
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupHandler.this.txt.copy();
            }
        });
        this.pasteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupHandler.this.txt.paste();
            }
        });
        this.clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupHandler.this.txt.setText("");
            }
        });
        this.selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupHandler.this.txt.selectAll();
            }
        });
        this.popup.add(this.cutItem);
        this.popup.add(this.copyItem);
        this.popup.add(this.pasteItem);
        this.popup.add(this.clearItem);
        this.popup.add(this.selectAllItem);
    }

    public static void installDefaultMouseListener(JTextComponent jtc) {
        jtc.addMouseListener(INSTANCE);
    }

    public PopupHandler(JPopupMenu popup) {
        this.setPopup(popup);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
            this.txt = (JTextComponent)e.getSource();
            boolean editable = this.txt.isEditable();
            boolean textSelected = this.txt.getSelectionStart() != this.txt.getSelectionEnd();
            this.copyItem.setEnabled(textSelected);
            this.cutItem.setEnabled(editable && textSelected);
            this.pasteItem.setEnabled(editable);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void setPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }
}

