/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.plaf.basic;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileSystemView;
import com.googlecode.vfsjfilechooser2.plaf.basic.BasicVFSFileChooserUI;
import com.googlecode.vfsjfilechooser2.plaf.metal.MetalVFSFileChooserUI;
import com.googlecode.vfsjfilechooser2.utils.FileObjectComparatorFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class BasicVFSDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private static final Comparator<FileObject> fileNameComparator = FileObjectComparatorFactory.newFileNameComparator(true);
    private VFSJFileChooser filechooser = null;
    private final List<FileObject> fileCache = new ArrayList<FileObject>();
    private ReadWriteLock aLock = new ReentrantReadWriteLock(true);
    private volatile Future<?> loadThread = null;
    private ExecutorService executor;
    private List<FileObject> files = null;
    private List<FileObject> directories = null;
    private int fetchID = 0;
    private PropertyChangeSupport changeSupport;
    private boolean busy = false;

    public BasicVFSDirectoryModel(VFSJFileChooser filechooser) {
        this.filechooser = filechooser;
        this.executor = Executors.newCachedThreadPool();
        this.validateFileCache();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("directoryChanged") || prop.equals("fileViewChanged") || prop.equals("fileFilterChanged") || prop.equals("FileHidingChanged") || prop.equals("fileSelectionChanged")) {
            this.validateFileCache();
        } else if ("UI".equals(prop)) {
            BasicVFSFileChooserUI ui;
            BasicVFSDirectoryModel model;
            Object old = e.getOldValue();
            if (old instanceof BasicVFSFileChooserUI && (model = (ui = (BasicVFSFileChooserUI)old).getModel()) != null) {
                model.invalidateFileCache();
            }
        } else if ("JFileChooserDialogIsClosingProperty".equals(prop)) {
            this.invalidateFileCache();
        }
    }

    public void invalidateFileCache() {
        if (this.loadThread != null) {
            this.loadThread.cancel(true);
            this.loadThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileObject> getFiles() {
        this.aLock.readLock().lock();
        try {
            if (this.files != null) {
                List<FileObject> list = this.files;
                return list;
            }
            this.files = new CopyOnWriteArrayList<FileObject>();
            this.directories = new CopyOnWriteArrayList<FileObject>();
            FileObject currentDir = this.filechooser.getCurrentDirectoryObject();
            AbstractVFSFileSystemView v = this.filechooser.getFileSystemView();
            this.directories.add(v.createFileObject(currentDir, ".."));
            for (FileObject f : this.fileCache) {
                if (this.filechooser.isTraversable(f)) {
                    this.directories.add(f);
                    continue;
                }
                this.files.add(f);
            }
            List<FileObject> list = this.files;
            return list;
        }
        finally {
            this.aLock.readLock().unlock();
        }
    }

    public void validateFileCache() {
        FileObject currentDirectory = this.filechooser.getCurrentDirectoryObject();
        if (currentDirectory == null) {
            return;
        }
        try {
            currentDirectory.refresh();
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (this.loadThread != null) {
            this.loadThread.cancel(true);
        }
        this.setBusy(true, ++this.fetchID);
        this.loadThread = this.executor.submit(new LoadFilesThread(currentDirectory, this.fetchID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(FileObject oldFile, FileObject newFile) {
        this.aLock.writeLock().lock();
        try {
            oldFile.moveTo(newFile);
            this.validateFileCache();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.aLock.writeLock().unlock();
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object o) {
        return this.fileCache.contains(o);
    }

    public int indexOf(Object o) {
        return this.fileCache.indexOf(o);
    }

    @Override
    public Object getElementAt(int index) {
        return this.fileCache.get(index);
    }

    public void sort(Comparator<FileObject> comparator) {
        Collections.sort(this.fileCache, comparator);
    }

    protected void sort(List<FileObject> v) {
        Collections.sort(v, fileNameComparator);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBusy(final boolean busy, int fid) {
        this.aLock.writeLock().lock();
        try {
            if (fid == this.fetchID) {
                boolean oldValue = this.busy;
                this.busy = busy;
                if (this.changeSupport != null && busy != oldValue) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            BasicVFSDirectoryModel.this.firePropertyChange("busy", !busy, busy);
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        r.run();
                    } else {
                        SwingUtilities.invokeLater(r);
                    }
                }
            }
        }
        finally {
            this.aLock.writeLock().unlock();
        }
    }

    class DoChangeContents
    implements Runnable {
        private List<FileObject> addFiles;
        private List<FileObject> remFiles;
        private boolean doFire = true;
        private int fid;
        private int addStart = 0;
        private int remStart = 0;

        public DoChangeContents(List<FileObject> addFiles, int addStart, List<FileObject> remFiles, int remStart, int fid) {
            this.addFiles = addFiles;
            this.addStart = addStart;
            this.remFiles = remFiles;
            this.remStart = remStart;
            this.fid = fid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            BasicVFSDirectoryModel.this.aLock.writeLock().lock();
            try {
                this.doFire = false;
            }
            finally {
                BasicVFSDirectoryModel.this.aLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (BasicVFSDirectoryModel.this.fetchID == this.fid && this.doFire) {
                int remSize = this.remFiles == null ? 0 : this.remFiles.size();
                int addSize = this.addFiles == null ? 0 : this.addFiles.size();
                BasicVFSDirectoryModel.this.aLock.writeLock().lock();
                try {
                    if (remSize > 0) {
                        BasicVFSDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (addSize > 0) {
                        BasicVFSDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    BasicVFSDirectoryModel.this.files = null;
                    BasicVFSDirectoryModel.this.directories = null;
                }
                finally {
                    BasicVFSDirectoryModel.this.aLock.writeLock().unlock();
                }
                if (remSize > 0 && addSize == 0) {
                    BasicVFSDirectoryModel.this.fireIntervalRemoved(BasicVFSDirectoryModel.this, this.remStart, this.remStart + remSize - 1);
                } else if (addSize > 0 && remSize == 0 && BasicVFSDirectoryModel.this.fileCache.size() > addSize) {
                    BasicVFSDirectoryModel.this.fireIntervalAdded(BasicVFSDirectoryModel.this, this.addStart, this.addStart + addSize - 1);
                } else {
                    BasicVFSDirectoryModel.this.fireContentsChanged();
                }
            }
        }
    }

    class LoadFilesThread
    implements Runnable {
        private int fid;
        private Queue<DoChangeContents> runnables = new ConcurrentLinkedQueue<DoChangeContents>();

        public LoadFilesThread(FileObject currentDirectory, int fid) {
            this.fid = fid;
        }

        private void invokeLater(DoChangeContents runnable) {
            this.runnables.add(runnable);
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        @Override
        public void run() {
            this.run0();
            BasicVFSDirectoryModel.this.setBusy(false, this.fid);
        }

        public void run0() {
            AbstractVFSFileSystemView fileSystem = BasicVFSDirectoryModel.this.filechooser.getFileSystemView();
            FileObject cwd = BasicVFSDirectoryModel.this.filechooser.getCurrentDirectoryObject();
            if (!BasicVFSDirectoryModel.this.contains(cwd)) {
                MetalVFSFileChooserUI ui = (MetalVFSFileChooserUI)BasicVFSDirectoryModel.this.filechooser.getUI();
                ui.getCombo().setSelectedItem(cwd);
            }
            FileObject[] list = fileSystem.getFiles(cwd, BasicVFSDirectoryModel.this.filechooser.isFileHidingEnabled());
            ArrayList<FileObject> acceptsList = new ArrayList<FileObject>(list.length);
            if (BasicVFSDirectoryModel.this.loadThread != null && BasicVFSDirectoryModel.this.loadThread.isCancelled()) {
                return;
            }
            for (FileObject aFileObject : list) {
                if (!BasicVFSDirectoryModel.this.filechooser.accept(aFileObject)) continue;
                acceptsList.add(aFileObject);
            }
            if (BasicVFSDirectoryModel.this.loadThread != null && BasicVFSDirectoryModel.this.loadThread.isCancelled()) {
                this.cancelRunnables();
                return;
            }
            BasicVFSDirectoryModel.this.sort(acceptsList);
            int mid = acceptsList.size() >> 1;
            ArrayList<FileObject> newDirectories = new ArrayList<FileObject>(mid);
            ArrayList<FileObject> newFiles = new ArrayList<FileObject>(mid);
            for (FileObject f : acceptsList) {
                boolean isTraversable = BasicVFSDirectoryModel.this.filechooser.isTraversable(f);
                if (isTraversable) {
                    newDirectories.add(f);
                } else {
                    newFiles.add(f);
                }
                if (BasicVFSDirectoryModel.this.loadThread == null || !BasicVFSDirectoryModel.this.loadThread.isCancelled()) continue;
                this.cancelRunnables();
                return;
            }
            ArrayList<FileObject> newFileCache = new ArrayList<FileObject>(newDirectories);
            newFileCache.addAll(newFiles);
            int newSize = newFileCache.size();
            int oldSize = BasicVFSDirectoryModel.this.fileCache.size();
            if (newSize > oldSize) {
                int start = oldSize;
                int end = newSize;
                block2: for (int i = 0; i < oldSize; ++i) {
                    if (((FileObject)newFileCache.get(i)).equals(BasicVFSDirectoryModel.this.fileCache.get(i))) continue;
                    start = i;
                    for (int j = i; j < newSize; ++j) {
                        if (!((FileObject)newFileCache.get(j)).equals(BasicVFSDirectoryModel.this.fileCache.get(i))) continue;
                        end = j;
                        break block2;
                    }
                    break;
                }
                if (start >= 0 && end > start && ((Object)newFileCache.subList(end, newSize)).equals(BasicVFSDirectoryModel.this.fileCache.subList(start, oldSize))) {
                    if (BasicVFSDirectoryModel.this.loadThread != null && BasicVFSDirectoryModel.this.loadThread.isCancelled()) {
                        this.cancelRunnables();
                        return;
                    }
                    this.invokeLater(new DoChangeContents(newFileCache.subList(start, end), start, null, 0, this.fid));
                    newFileCache = null;
                }
            } else if (newSize < oldSize) {
                int start = -1;
                int end = -1;
                for (int i = 0; i < newSize; ++i) {
                    if (((FileObject)newFileCache.get(i)).equals(BasicVFSDirectoryModel.this.fileCache.get(i))) continue;
                    start = i;
                    end = i + oldSize - newSize;
                    break;
                }
                if (start >= 0 && end > start && ((Object)BasicVFSDirectoryModel.this.fileCache.subList(end, oldSize)).equals(newFileCache.subList(start, newSize))) {
                    if (BasicVFSDirectoryModel.this.loadThread != null && BasicVFSDirectoryModel.this.loadThread.isCancelled()) {
                        this.cancelRunnables(this.runnables);
                        return;
                    }
                    this.invokeLater(new DoChangeContents(null, 0, new ArrayList<FileObject>(BasicVFSDirectoryModel.this.fileCache.subList(start, end)), start, this.fid));
                    newFileCache = null;
                }
            }
            if (newFileCache != null && !((Object)BasicVFSDirectoryModel.this.fileCache).equals(newFileCache)) {
                if (BasicVFSDirectoryModel.this.loadThread != null && BasicVFSDirectoryModel.this.loadThread.isCancelled()) {
                    this.cancelRunnables(this.runnables);
                    return;
                }
                this.invokeLater(new DoChangeContents(newFileCache, 0, BasicVFSDirectoryModel.this.fileCache, 0, this.fid));
            }
        }

        public void cancelRunnables(Queue<DoChangeContents> runnables) {
            DoChangeContents runnable = null;
            while ((runnable = runnables.poll()) != null) {
                runnable.cancel();
            }
        }

        public void cancelRunnables() {
            this.cancelRunnables(this.runnables);
        }
    }
}

