/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.utils;

import com.googlecode.vfsjfilechooser2.accessories.connection.Protocol;
import com.googlecode.vfsjfilechooser2.utils.VFSURIValidator;

public final class VFSURIParser {
    private static final char PATH_SEPARATOR = '/';
    private String username;
    private String password;
    private String path;
    private String hostname;
    private String portnumber;
    private Protocol protocol;

    public VFSURIParser(String fileURI) {
        this(fileURI, true);
    }

    public VFSURIParser(String fileURI, boolean assignDefaultPort) {
        if (fileURI == null) {
            throw new NullPointerException("file URI is null");
        }
        VFSURIValidator v = new VFSURIValidator();
        boolean valid = v.isValid(fileURI);
        if (valid) {
            this.hostname = v.getHostname();
            this.username = v.getUser();
            this.password = v.getPassword();
            this.path = v.getFile();
            this.portnumber = v.getPort();
            String p = v.getProtocol();
            this.protocol = Protocol.valueOf(p.toUpperCase());
            if (this.portnumber == null && !p.equalsIgnoreCase("file")) {
                this.portnumber = String.valueOf(this.protocol.getPort());
            }
            if (this.path == null) {
                this.path = String.valueOf('/');
            }
        } else {
            this.hostname = null;
            this.username = null;
            this.password = null;
            this.path = fileURI;
            this.portnumber = null;
            this.protocol = null;
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.path;
    }

    public String getPortnumber() {
        return this.portnumber;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }
}

