/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import weka.classifiers.sequence.core.DeleteState;
import weka.classifiers.sequence.core.DynamicProgAlgorithms;
import weka.classifiers.sequence.core.EmissionState;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.classifiers.sequence.core.ProfileHMM;

public class ForwardAlgorithm
extends DynamicProgAlgorithms {
    private static final long serialVersionUID = -8804666261111359271L;

    public ForwardAlgorithm(ProfileHMM net, String sequence) {
        super(net, sequence);
    }

    public void calculateForward() throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        this.matchMatrix = new double[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.insertMatrix = new double[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.deleteMatrix = new double[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.initialiseMatrices();
        this.recurse();
        this.terminate();
    }

    private void terminate() throws IllegalSymbolException, InvalidStructureException {
        EmissionState end = this.net.getEndState();
        EmissionState matchjMinus1 = this.net.getMatchState(this.net.getNumberMatchStates() - 1);
        double emissionProb = this.calculateLogEmissionProbability(end, this.sequence.length() - 1);
        double matchjMinus1ToEndTrans = this.getIncomingTransitionProbFrom(end, matchjMinus1);
        double matchScore = matchjMinus1ToEndTrans + this.matchMatrix[this.net.getNumberMatchStates() - 1][this.sequence.length() - 2];
        this.matchMatrix[this.net.getNumberMatchStates()][this.sequence.length() - 1] = emissionProb + matchScore;
        this.score = this.matchMatrix[this.net.getNumberMatchStates()][this.sequence.length() - 1];
    }

    private void recurse() throws IllegalSymbolException, InvalidStructureException {
        for (int j = 1; j < this.net.getNumberMatchStates(); ++j) {
            for (int i = 0; i < this.sequence.length() - 1; ++i) {
                if (i > 0) {
                    this.updateMatchMatrix(j, i);
                }
                if (j < this.net.getNumberMatchStates() - 1 && i < this.sequence.length() - 2 && i > 0) {
                    this.updateInsertMatrix(j, i);
                }
                if (j >= this.net.getNumberMatchStates() - 2 || i >= this.sequence.length() - 2) continue;
                this.updateDeleteMatrix(j, i);
            }
        }
    }

    private void updateDeleteMatrix(int j, int i) throws InvalidStructureException {
        DeleteState deletej = this.net.getDeleteState(j);
        DeleteState deletejMinus1 = this.net.getDeleteState(j - 1);
        EmissionState matchj = this.net.getMatchState(j);
        double deletejMinus1ToDeletejTrans = this.getIncomingTransitionProbFrom(deletej, deletejMinus1);
        double matchjToDeletejTrans = this.getIncomingTransitionProbFrom(deletej, matchj);
        double matchScore = matchjToDeletejTrans + this.matchMatrix[j][i];
        double deleteScore = deletejMinus1ToDeletejTrans + this.deleteMatrix[j - 1][i];
        this.deleteMatrix[j][i] = ForwardAlgorithm.logplus(matchScore, deleteScore);
    }

    private void updateInsertMatrix(int j, int i) throws IllegalSymbolException, InvalidStructureException {
        EmissionState insertj = this.net.getInsertState(j);
        EmissionState matchj = this.net.getMatchState(j);
        double emissionProb = this.calculateLogEmissionProbability(insertj, i);
        double insertjToInsertjTrans = this.getIncomingTransitionProbFrom(insertj, insertj);
        double matchjToInsertjTrans = this.getIncomingTransitionProbFrom(insertj, matchj);
        double matchScore = matchjToInsertjTrans + this.matchMatrix[j][i - 1];
        double insertScore = insertjToInsertjTrans + this.insertMatrix[j][i - 1];
        this.insertMatrix[j][i] = emissionProb + ForwardAlgorithm.logplus(matchScore, insertScore);
    }

    private void updateMatchMatrix(int j, int i) throws IllegalSymbolException, InvalidStructureException {
        EmissionState matchj = this.net.getMatchState(j);
        EmissionState matchjMinus1 = this.net.getMatchState(j - 1);
        EmissionState insertjMinus1 = this.net.getInsertState(j - 1);
        double emissionProb = this.calculateLogEmissionProbability(matchj, i);
        double matchjMinus1ToMatchjTrans = this.getIncomingTransitionProbFrom(matchj, matchjMinus1);
        double insertjMinus1ToMatchjTrans = this.getIncomingTransitionProbFrom(matchj, insertjMinus1);
        double matchScore = matchjMinus1ToMatchjTrans + this.matchMatrix[j - 1][i - 1];
        double insertScore = insertjMinus1ToMatchjTrans + this.insertMatrix[j - 1][i - 1];
        double deleteScore = Double.NEGATIVE_INFINITY;
        if (j > 1) {
            DeleteState deletejMinus2 = this.net.getDeleteState(j - 2);
            double deletejMinus2ToMatchjTrans = this.getIncomingTransitionProbFrom(matchj, deletejMinus2);
            deleteScore = deletejMinus2ToMatchjTrans + this.deleteMatrix[j - 2][i - 1];
            double logApproxmitionHelper = Double.NEGATIVE_INFINITY;
            logApproxmitionHelper = ForwardAlgorithm.logplus(deleteScore, matchScore);
            logApproxmitionHelper = ForwardAlgorithm.logplus(logApproxmitionHelper, insertScore);
            this.matchMatrix[j][i] = emissionProb + logApproxmitionHelper;
        } else {
            this.matchMatrix[j][i] = emissionProb + ForwardAlgorithm.logplus(matchScore, insertScore);
        }
    }

    private void initialiseMatrices() throws IllegalSymbolException, InvalidStructureException {
        double emissionProb;
        for (int i = 0; i < this.net.getNumberMatchStates() + 1; ++i) {
            for (int j = 0; j < this.sequence.length(); ++j) {
                this.matchMatrix[i][j] = Double.NEGATIVE_INFINITY;
                this.deleteMatrix[i][j] = Double.NEGATIVE_INFINITY;
                this.insertMatrix[i][j] = Double.NEGATIVE_INFINITY;
            }
        }
        EmissionState match0 = this.net.getMatchState(0);
        this.matchMatrix[0][0] = emissionProb = this.calculateLogEmissionProbability(match0, 0);
        EmissionState insert0 = this.net.getInsertState(0);
        double matchToInsertTrans = this.getIncomingTransitionProbFrom(insert0, match0);
        double insertToInsertTrans = this.getIncomingTransitionProbFrom(insert0, insert0);
        for (int i = 1; i < this.sequence.length() - 1; ++i) {
            emissionProb = this.calculateLogEmissionProbability(insert0, i);
            double fromMatch = matchToInsertTrans + this.matchMatrix[0][i - 1];
            double fromInsert = insertToInsertTrans + this.insertMatrix[0][i - 1];
            this.insertMatrix[0][i] = emissionProb + ForwardAlgorithm.logplus(fromMatch, fromInsert);
        }
        DeleteState delete0 = this.net.getDeleteState(0);
        double matchToDeleteTrans = this.getIncomingTransitionProbFrom(delete0, match0);
        this.deleteMatrix[0][0] = matchToDeleteTrans + this.matchMatrix[0][0];
    }
}

