/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.DateUtils;
import adams.core.io.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.AbstractTextualDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SpreadSheetDisplay
extends AbstractTextualDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected SpreadSheetTable m_Table;
    protected SpreadSheetTableModel m_TableModel;
    protected int m_NumDecimals;

    public String globalInfo() {
        return "Actor for displaying a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)3, (Number)0, null);
    }

    public void setNumDecimals(int value) {
        this.m_NumDecimals = value;
        this.reset();
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals for numeric values.";
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void clearPanel() {
        this.m_TableModel = new SpreadSheetTableModel(new SpreadSheet());
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
    }

    public BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_TableModel = new SpreadSheetTableModel(new SpreadSheet());
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
        this.m_Table.setNumDecimals(this.m_NumDecimals);
        result.add((Component)new BaseScrollPane((Component)this.m_Table), (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected void display(Token token) {
        this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)token.getPayload());
        this.m_Table.setModel((TableModel)this.m_TableModel);
        this.m_Table.setNumDecimals(this.m_NumDecimals);
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel("SpreadSheet"){
            private static final long serialVersionUID = 3524967045456783678L;
            protected SpreadSheetTable m_Table;
            protected SpreadSheetTableModel m_TableModel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_TableModel = new SpreadSheetTableModel(new SpreadSheet());
                this.m_Table = new SpreadSheetTable(this.m_TableModel);
                this.m_Table.setNumDecimals(SpreadSheetDisplay.this.m_NumDecimals);
                this.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
            }

            public void display(Token token) {
                this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)token.getPayload());
                this.m_Table.setModel((TableModel)this.m_TableModel);
                this.m_Table.setNumDecimals(SpreadSheetDisplay.this.m_NumDecimals);
            }

            public String supplyText() {
                return this.m_TableModel.getSheet().toString();
            }

            public void clearPanel() {
                this.m_TableModel = new SpreadSheetTableModel();
                this.m_Table.setModel((TableModel)this.m_TableModel);
                this.m_Table.setNumDecimals(SpreadSheetDisplay.this.m_NumDecimals);
            }

            public void cleanUp() {
            }
        };
        result.display(token);
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Headless) {
            this.getSystemOut().println("\n--> " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\n");
            this.getSystemOut().println(this.m_InputToken.getPayload());
        } else {
            result = super.doExecute();
        }
        return result;
    }

    public String supplyText() {
        String result = null;
        if (this.m_TableModel != null) {
            result = this.m_TableModel.getSheet().toString();
        }
        return result;
    }

    public Class[] getSendToClasses() {
        Vector<Class> result = new Vector<Class>(Arrays.asList(super.getSendToClasses()));
        if (!result.contains(JTable.class)) {
            result.add(JTable.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(JTable.class, (Class[])cls)) {
            result = this.m_Table;
            if (this.m_Table.getRowCount() == 0) {
                result = null;
            }
        } else {
            result = super.getSendToItem(cls);
        }
        return result;
    }
}

