/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.base.BaseRegExp;
import adams.core.io.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import java.util.Vector;

public class SpreadSheetColumnIterator
extends AbstractTransformer {
    private static final long serialVersionUID = 7689330704841468990L;
    public static final String BACKUP_NAMES = "names";
    protected Range m_Range;
    protected BaseRegExp m_RegExp;
    protected Vector<String> m_Names;

    public String globalInfo() {
        return "Iterates through all columns of a spreadsheet and outputs the names.\nThe columns can be limited with the range parameter and furthermore with the regular expression applied to the names.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("range", "range", (Object)new Range("first-last"));
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Range = new Range("first-last");
    }

    protected void reset() {
        super.reset();
        this.m_Names = new Vector();
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("range");
        String result = variable != null ? variable : this.m_Range.getRange();
        variable = this.getOptionManager().getVariableForProperty("regExp");
        if (variable != null) {
            result = result + ", subset: " + variable;
        } else if (!this.m_RegExp.isMatchAll() && !this.m_RegExp.isEmpty()) {
            result = result + ", subset: " + this.m_RegExp.getValue();
        }
        return result;
    }

    public void setRange(Range value) {
        this.m_Range = value;
        this.reset();
    }

    public Range getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The range of columns to iterate over; " + this.m_Range.getExample() + ".";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used to further limit the column set.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Names != null) {
            result.put(BACKUP_NAMES, this.m_Names);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_NAMES)) {
            this.m_Names = (Vector)state.get(BACKUP_NAMES);
            state.remove(BACKUP_NAMES);
        }
        super.restoreState(state);
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Range.setMax(sheet.getColumnCount());
        int[] indices = this.m_Range.getIntIndices();
        boolean useRegExp = !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatchAll();
        this.m_Names.clear();
        for (int index : indices) {
            String name = sheet.getHeaderRow().getCell(index).getContent();
            if (useRegExp && !this.m_RegExp.isMatch(name)) continue;
            this.m_Names.add(name);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Names != null && this.m_Names.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Names.firstElement());
        this.m_Names.remove(0);
        this.m_InputToken = null;
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_Names = null;
    }
}

