/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.flow.standalone.AbstractStandalone;
import java.util.Vector;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FTPConnection
extends AbstractStandalone
implements ProtocolCommandListener {
    private static final long serialVersionUID = -1959430342987913960L;
    protected String m_Host;
    protected String m_User;
    protected BasePassword m_Password;
    protected boolean m_UsePassiveMode;
    protected boolean m_UseBinaryMode;
    protected FTPClient m_Client;

    public String globalInfo() {
        return "Provides access to a FTP host.\nIf debugging is enabled, the FTP commands issued by other actors will get printed as debug output of this actor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"");
        this.m_OptionManager.add("user", "user", (Object)"anonymous");
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""));
        this.m_OptionManager.add("passive", "usePassiveMode", (Object)false);
        this.m_OptionManager.add("binary", "useBinaryMode", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.disconnect();
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("user");
        String result = variable != null ? variable : this.m_User;
        variable = this.getOptionManager().getVariableForProperty("password");
        result = variable != null ? result + ":" + variable : result + ":" + this.m_Password.getValue().replaceAll(".", "*");
        result = result + "@";
        variable = this.getOptionManager().getVariableForProperty("host");
        result = variable != null ? result + variable : result + this.m_Host;
        Vector<String> flags = new Vector<String>();
        if (this.m_UsePassiveMode) {
            flags.add("passive");
        }
        if (this.m_UseBinaryMode) {
            flags.add("binary");
        }
        if (flags.size() > 0) {
            result = result + " (" + Utils.flatten(flags, (String)", ") + ")";
        }
        return result;
    }

    public void setHost(String value) {
        this.m_Host = value;
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setUser(String value) {
        this.m_User = value;
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The FTP user to use for connecting.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the FTP user to use for connecting.";
    }

    public void setUsePassiveMode(boolean value) {
        this.m_UsePassiveMode = value;
    }

    public boolean getUsePassiveMode() {
        return this.m_UsePassiveMode;
    }

    public String usePassiveModeTipText() {
        return "If enabled, passive mode is used instead.";
    }

    public void setUseBinaryMode(boolean value) {
        this.m_UseBinaryMode = value;
    }

    public boolean getUseBinaryMode() {
        return this.m_UseBinaryMode;
    }

    public String useBinaryModeTipText() {
        return "If enabled, binary mode is used instead of ASCII.";
    }

    public synchronized FTPClient getFTPClient() {
        return this.m_Client;
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Client = new FTPClient();
            if (this.isDebugOn()) {
                this.m_Client.addProtocolCommandListener((ProtocolCommandListener)this);
            }
            this.m_Client.connect(this.m_Host);
            int reply = this.m_Client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                result = "FTP server refused connection: " + reply;
            } else if (!this.m_Client.login(this.m_User, this.m_Password.getValue())) {
                result = "Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "'";
            } else {
                if (this.m_UsePassiveMode) {
                    this.m_Client.enterLocalPassiveMode();
                }
                if (this.m_UseBinaryMode) {
                    this.m_Client.setFileType(2);
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "': ";
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace((Throwable)e);
            this.m_Client = null;
            result = msg + e;
        }
        return result;
    }

    protected void disconnect() {
        if (this.m_Client != null && this.m_Client.isConnected()) {
            try {
                this.m_Client.disconnect();
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to disconnect from '" + this.m_Host + "':");
                this.getSystemErr().printStackTrace((Throwable)e);
            }
            this.m_Client.removeProtocolCommandListener((ProtocolCommandListener)this);
        }
        this.m_Client = null;
    }

    public void wrapUp() {
        this.disconnect();
        super.wrapUp();
    }

    public void protocolCommandSent(ProtocolCommandEvent event) {
        this.debug("cmd sent: " + event.getCommand() + "/" + event.getReplyCode());
    }

    public void protocolReplyReceived(ProtocolCommandEvent event) {
        this.debug("reply received: " + event.getMessage() + "/" + event.getReplyCode());
    }
}

