/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Index;
import adams.core.Range;
import adams.core.Utils;
import adams.core.io.AbstractSpreadSheetReader;
import adams.core.io.SpreadSheet;
import java.io.InputStream;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.spreadsheet.Sheet;

public class ODFSpreadSheetReader
extends AbstractSpreadSheetReader {
    private static final long serialVersionUID = 4755872204697328246L;
    protected Index m_SheetIndex;
    protected Range m_TextColumns;

    public String globalInfo() {
        return "Reads ODF (Open Document Format) spreadsheet files.\nIf a row contains only empty cells, this is interpreted as the end of the sheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sheet", "sheetIndex", (Object)new Index("first"));
        this.m_OptionManager.add("text-columns", "textColumns", (Object)"");
    }

    public String getFormatDescription() {
        return "OpenDocument format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"ods"};
    }

    protected void initialize() {
        super.initialize();
        this.m_SheetIndex = new Index();
        this.m_TextColumns = new Range();
    }

    public void setSheetIndex(Index value) {
        this.m_SheetIndex = value;
        this.reset();
    }

    public Index getSheetIndex() {
        return this.m_SheetIndex;
    }

    public String sheetIndexTipText() {
        return "The index of the sheet to load; " + this.m_SheetIndex.getExample();
    }

    public void setTextColumns(String value) {
        this.m_TextColumns.setRange(value);
        this.reset();
    }

    public String getTextColumns() {
        return this.m_TextColumns.getRange();
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text; " + this.m_TextColumns.getExample();
    }

    protected boolean getUseInputStream() {
        return true;
    }

    protected String numericToString(String s) {
        Double dbl = Double.parseDouble(s);
        long lng = dbl.longValue();
        if (dbl == (double)lng) {
            return "" + lng;
        }
        return "" + dbl;
    }

    protected SpreadSheet doRead(InputStream in) {
        SpreadSheet result = new SpreadSheet();
        try {
            String cellStr;
            int i;
            org.jopendocument.dom.spreadsheet.SpreadSheet spreadsheet = org.jopendocument.dom.spreadsheet.SpreadSheet.get((ODPackage)new ODPackage(in));
            this.m_SheetIndex.setMax(spreadsheet.getSheetCount());
            Sheet sheet = spreadsheet.getSheet(this.m_SheetIndex.getIntIndex());
            result.setName(sheet.getName());
            SpreadSheet.Row row = result.getHeaderRow();
            for (i = 0; i < sheet.getColumnCount() && (cellStr = sheet.getCellAt(i, 0).getTextValue()).length() != 0; ++i) {
                row.addCell("" + (i + 1)).setContent(cellStr);
            }
            this.m_TextColumns.setMax(result.getColumnCount());
            for (int n = 1; n < sheet.getRowCount(); ++n) {
                Object[] data = new Object[result.getColumnCount()];
                boolean empty = true;
                for (i = 0; i < result.getColumnCount(); ++i) {
                    boolean numeric = !this.m_TextColumns.isInRange(i);
                    cellStr = sheet.getCellAt(i, n).getTextValue();
                    if (Utils.isLong((String)cellStr)) {
                        data[i] = numeric ? Long.valueOf(Long.parseLong(cellStr)) : this.numericToString(cellStr);
                        empty = false;
                    } else if (Utils.isDouble((String)cellStr)) {
                        data[i] = numeric ? Double.valueOf(Double.parseDouble(cellStr)) : this.numericToString(cellStr);
                        empty = false;
                    } else {
                        data[i] = cellStr;
                        if (((String)data[i]).length() > 0) {
                            empty = false;
                        }
                    }
                    if (!data[i].equals(this.m_MissingValue)) continue;
                    data[i] = null;
                }
                if (!empty) {
                    row = result.addRow("" + result.getRowCount());
                    for (i = 0; i < data.length; ++i) {
                        if (data[i] == null) {
                            row.addCell("" + (i + 1)).setContent("?");
                            continue;
                        }
                        if (data[i] instanceof Double) {
                            row.addCell("" + (i + 1)).setContent((Double)data[i]);
                            continue;
                        }
                        if (data[i] instanceof Long) {
                            row.addCell("" + (i + 1)).setContent(data[i].toString(), true);
                            continue;
                        }
                        row.addCell("" + (i + 1)).setContent((String)data[i], false);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception ioe) {
            this.getSystemErr().println("Failed to read data:");
            this.getSystemErr().printStackTrace((Throwable)ioe);
            result = null;
        }
        return result;
    }
}

