/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Placeholders;
import adams.core.RDataHelper;
import adams.core.RDataType;
import adams.core.Utils;
import adams.core.scripting.RScript;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.Rserve;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.Rserve.RConnection;

public class RSource
extends AbstractSource {
    private static final long serialVersionUID = -3064162887434390818L;
    protected RScript m_Script;
    protected RDataType m_returnType;
    protected String m_DataFrameColumns;
    protected Object m_returnedObject;
    protected RConnection m_RConn;
    protected Rserve m_Rserve;

    public String globalInfo() {
        return "Carries out an R function on the input script and returns data of a particular type.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "script", (Object)new RScript());
        this.m_OptionManager.add("return-type", "returnType", (Object)RDataType.Integer);
        this.m_OptionManager.add("data-frame-columns", "dataFrameColumns", (Object)"");
    }

    protected void reset() {
        super.reset();
        this.m_RConn = null;
    }

    public void setScript(RScript val) {
        this.m_Script = val;
        this.reset();
    }

    public RScript getScript() {
        return this.m_Script;
    }

    public String scriptTipText() {
        return "Script to pass into r";
    }

    public void setReturnType(RDataType val) {
        this.m_returnType = val;
        this.reset();
    }

    public RDataType getReturnType() {
        return this.m_returnType;
    }

    public String returnTypeTipText() {
        return "Data type of returned object";
    }

    public void setDataFrameColumns(String value) {
        this.m_DataFrameColumns = value;
        this.reset();
    }

    public String getDataFrameColumns() {
        return this.m_DataFrameColumns;
    }

    public String dataFrameColumnsTipText() {
        return "The comma-separated list of dataframe column names to return only (if return type is " + (Object)((Object)RDataType.DataFrame) + ")";
    }

    public String getQuickInfo() {
        String result = "script: ";
        String variable = this.getOptionManager().getVariableForProperty("script");
        result = variable != null ? result + variable : result + Utils.shorten((String)this.m_Script.stringValue(), (int)40);
        result = result + ", return: ";
        variable = this.getOptionManager().getVariableForProperty("returnType");
        result = variable != null ? result + variable : result + (Object)((Object)this.m_returnType);
        return result;
    }

    public Class[] generates() {
        switch (this.m_returnType) {
            case Integer: {
                return new Class[]{Integer.class};
            }
            case String: {
                return new Class[]{String.class};
            }
            case Double: {
                return new Class[]{Double.class};
            }
            case DoubleArray: {
                return new Class[]{Double[].class};
            }
            case DoubleMatrix: {
                return new Class[]{Double[][].class};
            }
            case DataFrame: {
                return new Class[]{SpreadSheet.class};
            }
        }
        throw new IllegalStateException("Unhandled data type: " + (Object)((Object)this.m_returnType));
    }

    public Token output() {
        Token result = new Token(this.m_returnedObject);
        this.m_returnedObject = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_returnedObject != null;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Rserve = (Rserve)ActorUtils.findClosestType((AbstractActor)this, Rserve.class, (boolean)true);
            if (this.m_Rserve == null) {
                result = "Failed to find " + Rserve.class.getName() + " standalone with Rserve configuration!";
            }
        }
        return result;
    }

    protected String doExecute() {
        if (this.m_RConn == null) {
            this.m_RConn = this.m_Rserve.newConnection();
            if (this.m_RConn == null) {
                return "Could not connect to Rserve!";
            }
        }
        try {
            String[] lines;
            String expr = this.getVariables().expand(this.m_Script.getValue());
            expr = Placeholders.expandStr((String)expr);
            REXP rexp = new REXP();
            for (String line : lines = expr.split("\r?\n")) {
                try {
                    rexp = this.m_RConn.eval(line);
                }
                catch (Exception ex) {
                    return this.handleException("Error occurred evaluating: " + line, ex);
                }
            }
            switch (this.m_returnType) {
                case Integer: {
                    this.m_returnedObject = new Integer(rexp.asInteger());
                    break;
                }
                case String: {
                    this.m_returnedObject = rexp.asString();
                    break;
                }
                case Double: {
                    this.m_returnedObject = new Double(rexp.asDouble());
                    break;
                }
                case DoubleArray: {
                    this.m_returnedObject = StatUtils.toNumberArray((double[])rexp.asDoubles());
                    break;
                }
                case DoubleMatrix: {
                    double[][] dubMat = rexp.asDoubleMatrix();
                    Double[][] result = new Double[dubMat.length][];
                    for (int i = 0; i < dubMat.length; ++i) {
                        result[i] = (Double[])StatUtils.toNumberArray((double[])dubMat[i]);
                    }
                    this.m_returnedObject = result;
                    break;
                }
                case DataFrame: {
                    if (this.m_DataFrameColumns.trim().length() > 0) {
                        this.m_returnedObject = RDataHelper.dataframeToSpreadsheet(rexp, this.m_DataFrameColumns.split(","));
                        break;
                    }
                    this.m_returnedObject = RDataHelper.dataframeToSpreadsheet(rexp);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled data type: " + (Object)((Object)this.m_returnType));
                }
            }
        }
        catch (Exception e) {
            return this.handleException("Error occurred calling Rserve:", e);
        }
        return null;
    }

    public void wrapUp() {
        if (this.m_Rserve != null) {
            this.m_Rserve.closeConnection(this.m_RConn);
            this.m_RConn = null;
            this.m_Rserve = null;
        }
        super.wrapUp();
    }
}

