/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Placeholders;
import adams.core.RDataHelper;
import adams.core.RDataType;
import adams.core.Utils;
import adams.core.scripting.RScript;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.Rserve;
import adams.flow.transformer.AbstractTransformer;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.Rserve.RConnection;

public class RTransformer
extends AbstractTransformer {
    private static final long serialVersionUID = -2595028152021378207L;
    protected RScript m_Script;
    public static final String INPUT = "X";
    protected RDataType m_returnType;
    protected String m_DataFrameColumns;
    protected Object m_returnedObject;
    protected RConnection m_RConn;
    protected Rserve m_Rserve;

    public String globalInfo() {
        return "Carries out an r command on the token passed in. The input can be accessed via 'X'.\nVariables are supported as well, e.g. pow(X,@{exp}) with '@{exp}' being a variable available at execution time.\nReturns a result from R.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "script", (Object)new RScript());
        this.m_OptionManager.add("return-type", "returnType", (Object)RDataType.Integer);
        this.m_OptionManager.add("data-frame-columns", "dataFrameColumns", (Object)"");
    }

    protected void reset() {
        super.reset();
        this.m_RConn = null;
    }

    public void setScript(RScript val) {
        this.m_Script = val;
        this.reset();
    }

    public RScript getScript() {
        return this.m_Script;
    }

    public String scriptTipText() {
        return "Script to pass into r. The input value can be accessed via 'X'.";
    }

    public void setReturnType(RDataType val) {
        this.m_returnType = val;
        this.reset();
    }

    public RDataType getReturnType() {
        return this.m_returnType;
    }

    public String returnTypeTipText() {
        return "Data type of returned object";
    }

    public void setDataFrameColumns(String value) {
        this.m_DataFrameColumns = value;
        this.reset();
    }

    public String getDataFrameColumns() {
        return this.m_DataFrameColumns;
    }

    public String dataFrameColumnsTipText() {
        return "The comma-separated list of dataframe column names to return only (if return type is " + (Object)((Object)RDataType.DataFrame) + ")";
    }

    public String getQuickInfo() {
        String result = "script: ";
        String variable = this.getOptionManager().getVariableForProperty("script");
        result = variable != null ? result + variable : result + Utils.shorten((String)this.m_Script.stringValue(), (int)40);
        result = result + ", return: ";
        variable = this.getOptionManager().getVariableForProperty("returnType");
        result = variable != null ? result + variable : result + (Object)((Object)this.m_returnType);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Integer.class, String.class, Double.class, Double[].class, Double[][].class, SpreadSheet.class};
    }

    public Class[] generates() {
        switch (this.m_returnType) {
            case Integer: {
                return new Class[]{Integer.class};
            }
            case String: {
                return new Class[]{String.class};
            }
            case Double: {
                return new Class[]{Double.class};
            }
            case DoubleArray: {
                return new Class[]{Double[].class};
            }
            case DoubleMatrix: {
                return new Class[]{Double[][].class};
            }
            case DataFrame: {
                return new Class[]{SpreadSheet.class};
            }
        }
        throw new IllegalStateException("Unhandled data type: " + (Object)((Object)this.m_returnType));
    }

    public Token output() {
        Token result = new Token(this.m_returnedObject);
        this.m_returnedObject = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_returnedObject != null;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Rserve = (Rserve)ActorUtils.findClosestType((AbstractActor)this, Rserve.class, (boolean)true);
            if (this.m_Rserve == null) {
                result = "Failed to find " + Rserve.class.getName() + " standalone with Rserve configuration!";
            }
        }
        return result;
    }

    protected String doExecute() {
        if (this.m_RConn == null) {
            this.m_RConn = this.m_Rserve.newConnection();
            if (this.m_RConn == null) {
                return "Could not connect to Rserve!";
            }
        }
        String expr = this.getVariables().expand(this.m_Script.getValue());
        expr = Placeholders.expandStr((String)expr);
        try {
            String[] lines;
            if (this.m_InputToken.getPayload() instanceof Integer) {
                this.m_RConn.assign(INPUT, new int[]{(Integer)this.m_InputToken.getPayload()});
            } else if (this.m_InputToken.getPayload() instanceof String) {
                this.m_RConn.assign(INPUT, (String)this.m_InputToken.getPayload());
            } else if (this.m_InputToken.getPayload() instanceof Double) {
                this.m_RConn.assign(INPUT, new double[]{(Double)this.m_InputToken.getPayload()});
            } else if (this.m_InputToken.getPayload() instanceof Double[]) {
                this.m_RConn.assign(INPUT, StatUtils.toDoubleArray((Number[])((Double[])this.m_InputToken.getPayload())));
            } else if (this.m_InputToken.getPayload() instanceof Double[][]) {
                int i;
                Double[][] temp = (Double[][])this.m_InputToken.getPayload();
                double[][] dubMat = new double[temp.length][];
                for (i = 0; i < temp.length; ++i) {
                    dubMat[i] = StatUtils.toDoubleArray((Number[])temp[i]);
                }
                this.m_RConn.assign(INPUT, dubMat[0]);
                for (i = 1; i < dubMat.length; ++i) {
                    this.m_RConn.assign("tmp", dubMat[i]);
                    this.m_RConn.eval("X<-rbind(X,tmp)");
                }
            } else if (this.m_InputToken.getPayload() instanceof SpreadSheet) {
                this.m_RConn.assign(INPUT, RDataHelper.spreadsheetToDataframe((SpreadSheet)this.m_InputToken.getPayload()));
            } else {
                throw new IllegalStateException("Unhandled class: " + this.m_InputToken.getPayload().getClass());
            }
            REXP rexp = new REXP();
            for (String line : lines = expr.split("\r?\n")) {
                try {
                    rexp = this.m_RConn.eval(line);
                }
                catch (Exception ex) {
                    return this.handleException("Error occurred evaluating: " + line, ex);
                }
            }
            switch (this.m_returnType) {
                case Integer: {
                    this.m_returnedObject = new Integer(rexp.asInteger());
                    break;
                }
                case String: {
                    this.m_returnedObject = rexp.asString();
                    break;
                }
                case Double: {
                    this.m_returnedObject = new Double(rexp.asDouble());
                    break;
                }
                case DoubleArray: {
                    this.m_returnedObject = StatUtils.toNumberArray((double[])rexp.asDoubles());
                    break;
                }
                case DoubleMatrix: {
                    double[][] dubMat = rexp.asDoubleMatrix();
                    Double[][] result = new Double[dubMat.length][];
                    for (int i = 0; i < dubMat.length; ++i) {
                        result[i] = (Double[])StatUtils.toNumberArray((double[])dubMat[i]);
                    }
                    this.m_returnedObject = result;
                    break;
                }
                case DataFrame: {
                    if (this.m_DataFrameColumns.trim().length() > 0) {
                        this.m_returnedObject = RDataHelper.dataframeToSpreadsheet(rexp, this.m_DataFrameColumns.split(","));
                        break;
                    }
                    this.m_returnedObject = RDataHelper.dataframeToSpreadsheet(rexp);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled data type: " + (Object)((Object)this.m_returnType));
                }
            }
        }
        catch (Exception e) {
            return this.handleException("Error occurred calling Rserve:", e);
        }
        return null;
    }

    public void wrapUp() {
        if (this.m_Rserve != null) {
            this.m_Rserve.closeConnection(this.m_RConn);
            this.m_RConn = null;
            this.m_Rserve = null;
        }
        super.wrapUp();
    }
}

