/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;
import java.util.Hashtable;

public abstract class AbstractTemplate
extends AbstractActor {
    private static final long serialVersionUID = 7246162048306571873L;
    public static final String BACKUP_ACTOR = "actor";
    protected AbstractActorTemplate m_Template;
    protected AbstractActor m_Actor;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("template", "template", (Object)this.getDefaultTemplate());
    }

    protected void reset() {
        super.reset();
        this.m_Actor = null;
    }

    protected abstract AbstractActorTemplate getDefaultTemplate();

    public void setTemplate(AbstractActorTemplate value) {
        this.m_Template = value;
        this.reset();
    }

    public AbstractActorTemplate getTemplate() {
        return this.m_Template;
    }

    public String templateTipText() {
        return "The template to use for generating the actual actor.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("template");
        if (variable != null) {
            return variable;
        }
        return this.m_Template.getClass().getSimpleName();
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ACTOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Actor != null) {
            result.put(BACKUP_ACTOR, this.m_Actor);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ACTOR)) {
            this.m_Actor = (AbstractActor)state.get(BACKUP_ACTOR);
            state.remove(BACKUP_ACTOR);
        }
        super.restoreState(state);
    }

    protected String setUpTemplate() {
        String result = null;
        this.m_Actor = this.m_Template.generate();
        if (this.m_Actor == null) {
            result = "Couldn't generate actor from template '" + this.getTemplate() + "'!";
        } else {
            this.m_Actor.setParent((AbstractActor)this);
            this.m_Actor.setHeadless(this.isHeadless());
            result = this.m_Actor.setUp();
        }
        return result;
    }

    public AbstractActor getActualActor() {
        return this.m_Actor;
    }

    public boolean isFinished() {
        if (this.m_Actor == null) {
            return true;
        }
        return this.m_Actor.isFinished();
    }

    public void stopExecution() {
        try {
            if (this.m_Actor != null) {
                this.m_Actor.stopExecution();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_Actor != null) {
            this.m_Actor.wrapUp();
        }
        super.wrapUp();
    }

    public void cleanUp() {
        super.cleanUp();
        if (this.m_Actor != null) {
            this.m_Actor.cleanUp();
            this.m_Actor = null;
        }
    }
}

