/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AntiAliasingPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.paintlet.AbstractColorPaintlet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class VsOrderPaintlet
extends AbstractColorPaintlet
implements AntiAliasingPaintlet {
    private static final long serialVersionUID = -5195847858691868288L;
    protected int m_Index;
    protected Color m_FillColor;
    protected boolean m_Fill;
    protected int m_Size;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paints the data for the versus order graph";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("size", "size", (Object)5);
        this.m_OptionManager.add("fill-point", "fillPoint", (Object)true);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)Color.RED);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public void setFillPoint(boolean val) {
        this.m_Fill = val;
        this.memberChanged();
    }

    public boolean getFillPoint() {
        return this.m_Fill;
    }

    public String fillPointTipText() {
        return "Whether to fill the data point with solid color";
    }

    public void setFillColor(Color val) {
        this.m_FillColor = val;
        this.memberChanged();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "color for filling the data points";
    }

    public void setSize(int val) {
        this.m_Size = val;
        this.memberChanged();
    }

    public int getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "Size of the data points";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        if (this.m_Instances != null) {
            if (this.m_AntiAliasingEnabled) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            AxisPanel axisBottom = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            AxisPanel axisLeft = this.getPanel().getPlot().getAxis(Axis.LEFT);
            double[] residuals = this.m_Instances.attributeToDoubleArray(this.m_Index);
            g.setColor(Color.BLACK);
            g.drawLine(0, axisLeft.valueToPos(0.0), axisBottom.valueToPos(axisBottom.getMaximum()), axisLeft.valueToPos(0.0));
            for (int i = 0; i < residuals.length; ++i) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
                if (this.m_Fill) {
                    g2d.setColor(this.m_FillColor);
                    g2d.setStroke(new BasicStroke(0.0f));
                    g2d.fillOval(axisBottom.valueToPos((double)i) - this.m_Size / 2, axisLeft.valueToPos(residuals[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
                }
                g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
                g2d.setColor(this.m_Color);
                g2d.drawOval(axisBottom.valueToPos((double)i) - this.m_Size / 2, axisLeft.valueToPos(residuals[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
                if (i >= residuals.length - 1) continue;
                g.setColor(Color.BLUE);
                g.drawLine(axisBottom.valueToPos((double)i), axisLeft.valueToPos(residuals[i]), axisBottom.valueToPos((double)(i + 1)), axisLeft.valueToPos(residuals[i + 1]));
            }
        }
    }

    public void setIndex(int val) {
        this.m_Index = val;
    }
}

