/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.WekaModelContainer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.MOAClustererSetup;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.MOATrainClusterer;
import java.util.Hashtable;
import moa.clusterers.Clusterer;
import moa.clusterers.CobWeb;
import moa.options.ClassOption;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MOAUtils;

@Deprecated
public class MOAClusterer
extends AbstractTransformer {
    private static final long serialVersionUID = -6015760924658904729L;
    public static final String BACKUP_CLUSTERER = "clusterer";
    protected ClassOption m_Clusterer;
    protected Clusterer m_ActualClusterer;
    protected int m_OutputInterval;
    protected int m_Count;

    public String globalInfo() {
        return "Trains a MOA clusterer based on the incoming data.\n\nDEPRECATED\n\n- Use " + MOAClustererSetup.class.getName() + " for definined a clusterer setup.\n" + "- Use " + MOATrainClusterer.class.getName() + " for building a clusterer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_CLUSTERER, BACKUP_CLUSTERER, (Object)this.getDefaultOption());
        this.m_OptionManager.add("output-interval", "outputInterval", (Object)1000, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualClusterer = null;
        this.m_Count = 0;
    }

    protected Clusterer getDefaultClusterer() {
        return new CobWeb();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption(BACKUP_CLUSTERER, 'c', "The MOA clusterer to use from within ADAMS.", Clusterer.class, this.getDefaultClusterer().getClass().getName().replace("moa.clusterers.", ""), this.getDefaultClusterer().getClass().getName());
    }

    public void setClusterer(ClassOption value) {
        this.m_Clusterer = (ClassOption)value.copy();
        this.reset();
    }

    public ClassOption getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The MOA clusterer to train on the input data and outputs the built clusterer alongside the training header (in a model container).\nIf the incoming token does not encapsulate an weka.core.Instance, then only a new instance of the clusterer is sent around.";
    }

    protected Clusterer getCurrentStreamGenerator() {
        return (Clusterer)MOAUtils.fromOption((ClassOption)this.m_Clusterer);
    }

    public void setOutputInterval(int value) {
        this.m_OutputInterval = value;
        this.reset();
    }

    public int getOutputInterval() {
        return this.m_OutputInterval;
    }

    public String outputIntervalTipText() {
        return "The number of tokens to wait before forwarding the trainined clusterer.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty(BACKUP_CLUSTERER);
        String result = variable != null ? variable : this.getCurrentStreamGenerator().getClass().getName().replace("moa.clusterers.", "");
        variable = this.getOptionManager().getVariableForProperty("outputInterval");
        result = variable != null ? result + "/" + variable : result + "/" + this.m_OutputInterval;
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CLUSTERER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualClusterer != null) {
            result.put(BACKUP_CLUSTERER, this.m_ActualClusterer);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CLUSTERER)) {
            this.m_ActualClusterer = (Clusterer)state.get(BACKUP_CLUSTERER);
            state.remove(BACKUP_CLUSTERER);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class, Clusterer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instance) {
                Instance inst = (Instance)this.m_InputToken.getPayload();
                if (this.m_ActualClusterer == null) {
                    this.m_ActualClusterer = this.getCurrentStreamGenerator();
                }
                this.m_ActualClusterer.trainOnInstance(inst);
                ++this.m_Count;
                if (this.m_Count % this.m_OutputInterval == 0) {
                    this.m_Count = 0;
                    this.m_OutputToken = new Token((Object)new WekaModelContainer((Object)this.m_ActualClusterer, new Instances(inst.dataset(), 0)));
                }
            } else {
                Clusterer cls = (Clusterer)MOAUtils.fromOption((ClassOption)this.m_Clusterer);
                this.m_OutputToken = new Token((Object)cls);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process input: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualClusterer = null;
    }
}

