/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import moa.clusterers.AbstractClusterer;
import moa.core.Measurement;
import moa.evaluation.BasicClusteringPerformanceEvaluator;
import moa.evaluation.LearningPerformanceEvaluator;
import moa.options.ClassOption;
import weka.core.Instance;
import weka.core.MOAUtils;

public class MOAClustererEvaluation
extends AbstractTransformer {
    private static final long serialVersionUID = 1410487605033307517L;
    public static final String BACKUP_CLUSTERER = "clusterer";
    protected GlobalActorReference m_Clusterer;
    protected AbstractClusterer m_ActualClusterer;
    protected ClassOption m_Evaluator;
    protected LearningPerformanceEvaluator m_ActualEvaluator;
    protected int m_OutputInterval;
    protected int m_Count;

    public String globalInfo() {
        return "Evaluates a MOA clusterer using prequential evaluation. With each incoming instance, the clusterer is first evaluated, then trained.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_CLUSTERER, BACKUP_CLUSTERER, (Object)new GlobalActorReference("MOAClusterer"));
        this.m_OptionManager.add("evaluator", "evaluator", (Object)this.getDefaultOption());
        this.m_OptionManager.add("output-interval", "outputInterval", (Object)1, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualEvaluator = null;
        this.m_Count = 0;
        this.m_ActualClusterer = null;
    }

    public void setClusterer(GlobalActorReference value) {
        this.m_Clusterer = value;
        this.reset();
    }

    public GlobalActorReference getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The name of the global MOA clusterer to train/evaluate.";
    }

    protected LearningPerformanceEvaluator getDefaultEvaluator() {
        return new BasicClusteringPerformanceEvaluator();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption("evaluator", 'e', "The MOA clusterer performance evaluator to use from within ADAMS.", LearningPerformanceEvaluator.class, this.getDefaultEvaluator().getClass().getName().replace("moa.evaluation.", ""), this.getDefaultEvaluator().getClass().getName());
    }

    public void setEvaluator(ClassOption value) {
        this.m_Evaluator = (ClassOption)value.copy();
        this.reset();
    }

    public ClassOption getEvaluator() {
        return this.m_Evaluator;
    }

    public String evaluatorTipText() {
        return "The MOA evaluator to use for evaluating a trained MOA clusterer.";
    }

    protected LearningPerformanceEvaluator getCurrentEvaluator() {
        return (LearningPerformanceEvaluator)MOAUtils.fromOption((ClassOption)this.m_Evaluator);
    }

    public void setOutputInterval(int value) {
        this.m_OutputInterval = value;
        this.reset();
    }

    public int getOutputInterval() {
        return this.m_OutputInterval;
    }

    public String outputIntervalTipText() {
        return "The number of tokens to skip before evaluating the clusterer stored in the token.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty(BACKUP_CLUSTERER);
        String result = variable != null ? variable : this.m_Clusterer.toString();
        variable = this.getOptionManager().getVariableForProperty("evaluator");
        result = variable != null ? result + ", " + variable : result + ", " + this.getCurrentEvaluator().getClass().getName().replace("moa.evaluation.", "");
        variable = this.getOptionManager().getVariableForProperty("outputInterval");
        result = variable != null ? result + "/" + variable : result + "/" + (this.m_OutputInterval == 1 ? "always" : Integer.valueOf(this.m_OutputInterval));
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public Class[] generates() {
        return new Class[]{Measurement[].class};
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CLUSTERER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualClusterer != null) {
            result.put(BACKUP_CLUSTERER, this.m_ActualClusterer);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CLUSTERER)) {
            this.m_ActualClusterer = (AbstractClusterer)state.get(BACKUP_CLUSTERER);
            state.remove(BACKUP_CLUSTERER);
        }
        super.restoreState(state);
    }

    protected AbstractClusterer getClustererInstance() {
        return (AbstractClusterer)GlobalActorHelper.getSetup(AbstractClusterer.class, (GlobalActorReference)this.m_Clusterer, (AbstractActor)this);
    }

    protected String doExecute() {
        String result = null;
        if (this.m_ActualEvaluator == null) {
            this.m_ActualEvaluator = (LearningPerformanceEvaluator)MOAUtils.fromOption((ClassOption)this.m_Evaluator);
        }
        Instance inst = (Instance)this.m_InputToken.getPayload();
        if (this.m_ActualClusterer == null) {
            this.m_ActualClusterer = this.getClustererInstance();
            if (this.m_ActualClusterer == null) {
                result = "Failed to located clusterer '" + this.m_Clusterer + "'!";
                return result;
            }
        }
        Instance testInst = (Instance)inst.copy();
        double[] prediction = this.m_ActualClusterer.getVotesForInstance(testInst);
        this.m_ActualEvaluator.addLearningAttempt(-1, prediction, testInst.weight());
        this.m_ActualClusterer.trainOnInstance(inst);
        ++this.m_Count;
        if (this.m_Count % this.m_OutputInterval == 0) {
            this.m_Count = 0;
            this.m_OutputToken = new Token((Object)this.m_ActualEvaluator.getPerformanceMeasurements());
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.EVALUATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualEvaluator = null;
        this.m_ActualClusterer = null;
    }
}

