/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.tool;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.tool.PlugInTool;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class BrushTool
extends PlugInTool
implements Runnable {
    private static String BRUSH_WIDTH_KEY = "brush.width";
    private static String PENCIL_WIDTH_KEY = "pencil.width";
    private static String CIRCLE_NAME = "brush-tool-overlay";
    private int width = (int)Prefs.get(BRUSH_WIDTH_KEY, 5.0);
    private Thread thread;
    private boolean dialogShowing;
    private ImageProcessor ip;
    private int x2;
    private int x3;
    private boolean isPencil;
    private Overlay overlay;
    private Options options;

    public void run(String arg) {
        this.isPencil = "pencil".equals(arg);
        if (this.isPencil) {
            this.width = (int)Prefs.get(PENCIL_WIDTH_KEY, 1.0);
        }
        Toolbar.addPlugInTool(this);
    }

    public void mousePressed(ImagePlus imp, MouseEvent e) {
        ImageCanvas ic = imp.getCanvas();
        int x = ic.offScreenX(e.getX());
        int y = ic.offScreenY(e.getY());
        this.ip = imp.getProcessor();
        this.ip.snapshot();
        Undo.setup(1, imp);
        this.ip.setLineWidth(this.width);
        if (e.isAltDown()) {
            this.ip.setColor(Toolbar.getBackgroundColor());
        } else {
            this.ip.setColor(Toolbar.getForegroundColor());
        }
        this.ip.moveTo(x, y);
        if (!e.isShiftDown()) {
            this.ip.lineTo(x, y);
            imp.updateAndDraw();
        }
        this.x2 = -1;
        this.x3 = x;
    }

    public void mouseDragged(ImagePlus imp, MouseEvent e) {
        ImageCanvas ic = imp.getCanvas();
        int x = ic.offScreenX(e.getX());
        int y = ic.offScreenY(e.getY());
        if (e.isShiftDown()) {
            if (x != this.x2) {
                this.x2 = x;
                this.width = x - this.x3;
                if (this.width < 1) {
                    this.width = 1;
                }
                OvalRoi circle = new OvalRoi(x - this.width / 2, y - this.width / 2, this.width, this.width);
                circle.setName(CIRCLE_NAME);
                circle.setStrokeColor(Color.red);
                this.overlay = imp.getOverlay();
                if (this.overlay == null) {
                    this.overlay = new Overlay();
                } else if (this.overlay.size() > 0 && CIRCLE_NAME.equals(this.overlay.get(this.overlay.size() - 1).getName())) {
                    this.overlay.remove(this.overlay.size() - 1);
                }
                this.overlay.add(circle);
                imp.setOverlay(this.overlay);
            }
            IJ.showStatus((this.isPencil ? "Pencil" : "Brush") + " size: " + this.width);
        } else {
            this.ip.lineTo(x, y);
            imp.updateAndDraw();
        }
    }

    public void mouseReleased(ImagePlus imp, MouseEvent e) {
        if (this.overlay != null && this.overlay.size() > 0 && CIRCLE_NAME.equals(this.overlay.get(this.overlay.size() - 1).getName())) {
            this.overlay.remove(this.overlay.size() - 1);
            imp.setOverlay(this.overlay);
        } else if (this.overlay != null) {
            imp.setOverlay(null);
        }
        this.overlay = null;
        if (e.isShiftDown()) {
            if (this.options != null) {
                this.options.setWidth(this.width);
            }
            if (this.isPencil) {
                Prefs.set(PENCIL_WIDTH_KEY, this.width);
            } else {
                Prefs.set(BRUSH_WIDTH_KEY, this.width);
            }
        }
    }

    public void showOptionsDialog() {
        this.thread = new Thread((Runnable)this, "Brush Options");
        this.thread.setPriority(5);
        this.thread.start();
    }

    public String getToolName() {
        if (this.isPencil) {
            return "Pencil Tool";
        }
        return "Paintbrush Tool";
    }

    public String getToolIcon() {
        if (this.isPencil) {
            return "C037L4990L90b0Lc1c3L82a4Lb58bL7c4fDb4L494fC123L5a5dL6b6cD7b";
        }
        return "C037La077Ld098L6859L4a2fL2f4fL5e9bL9b98L6888L5e8dL888cC123L8a3fL8b6d";
    }

    public void run() {
        new Options();
    }

    class Options
    implements DialogListener {
        GenericDialog gd;

        Options() {
            if (BrushTool.this.dialogShowing) {
                return;
            }
            BrushTool.this.dialogShowing = true;
            BrushTool.this.options = this;
            this.showDialog();
        }

        void setWidth(int width) {
            Vector numericFields = this.gd.getNumericFields();
            TextField widthField = (TextField)numericFields.elementAt(0);
            widthField.setText("" + width);
            Vector sliders = this.gd.getSliders();
            Scrollbar sb = (Scrollbar)sliders.elementAt(0);
            sb.setValue(width);
        }

        public void showDialog() {
            Color color = Toolbar.getForegroundColor();
            String colorName = Colors.getColorName(color, "red");
            String name = BrushTool.this.isPencil ? "Pencil" : "Brush";
            this.gd = new NonBlockingGenericDialog(name + " Options");
            this.gd.addSlider(name + " width:", 1.0, 50.0, BrushTool.this.width);
            this.gd.addChoice("Color:", Colors.colors, colorName);
            this.gd.setInsets(10, 10, 0);
            this.gd.addMessage("Shift-drag to change width\nAlt-drag to draw in background color\nColor Picker (shift-k) changes color");
            this.gd.hideCancelButton();
            this.gd.addHelp("");
            this.gd.setHelpLabel("Undo");
            this.gd.setOKLabel("Close");
            this.gd.addDialogListener(this);
            this.gd.showDialog();
            BrushTool.this.dialogShowing = false;
        }

        public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
            if (e != null && e.toString().contains("Undo")) {
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null) {
                    IJ.run("Undo");
                }
                return true;
            }
            BrushTool.this.width = (int)gd.getNextNumber();
            String colorName = gd.getNextChoice();
            Color color = Colors.getColor(colorName, Color.white);
            Toolbar.setForegroundColor(color);
            if (BrushTool.this.isPencil) {
                Prefs.set(PENCIL_WIDTH_KEY, BrushTool.this.width);
            } else {
                Prefs.set(BRUSH_WIDTH_KEY, BrushTool.this.width);
            }
            return true;
        }
    }
}

