/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.heatmap.Heatmap;

public class Celsius
extends AbstractFilter<Heatmap> {
    private static final long serialVersionUID = -7042050399940172586L;

    public String globalInfo() {
        return "Converts the intensities from Kelvin into Celsius.\nSkips 0 values in the heatmap.";
    }

    protected Heatmap processData(Heatmap data) {
        Heatmap result = data.getHeader();
        for (int i = 0; i < data.size(); ++i) {
            double value = data.get(i);
            if (!(value > 0.0)) continue;
            result.set(i, value - 273.0);
        }
        return result;
    }
}

