/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.heatmap.Heatmap;
import adams.data.statistics.StatUtils;

public class Standardize
extends AbstractFilter<Heatmap> {
    private static final long serialVersionUID = 2270876952032422552L;
    protected boolean m_IsSample;

    public String globalInfo() {
        return "Standardizes the values of a heatmap to have mean of 'min' and stdev 1.\nNB: normally, the mean is 0 when standardizing, but heatmaps only allow positive values, hence the mean is shifted yb 'min', the smallest value of the standardized values.";
    }

    protected Heatmap processData(Heatmap data) {
        Heatmap result = data.getHeader();
        Number[] values = data.toDoubleArray();
        values = StatUtils.standardize((Number[])values, (boolean)false);
        double min = StatUtils.min((Number[])values).doubleValue();
        for (int i = 0; i < values.length; ++i) {
            result.set(i, (Double)values[i] - min);
        }
        return result;
    }
}

