/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.data.heatmap.Heatmap;
import adams.data.io.output.AbstractHeatmapWriter;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.util.List;

public class SpreadSheetHeatmapWriter
extends AbstractHeatmapWriter {
    private static final long serialVersionUID = -7828811375813385465L;
    protected AbstractSpreadSheetWriter m_Writer;

    public String globalInfo() {
        return "Writes heat map files using a spreadsheet format.";
    }

    protected void initialize() {
        super.initialize();
        this.m_OutputIsFile = true;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new CsvSpreadSheetWriter());
    }

    public void setWriter(AbstractSpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractSpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The spreadsheet writer to use for writing the heatmap data.";
    }

    public String getFormatDescription() {
        return "Heatmap in spreadsheet-format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"*"};
    }

    protected boolean writeData(List<Heatmap> data) {
        int x;
        boolean result = false;
        if (data.size() != 1) {
            this.getSystemErr().println("Can only write a single heatmap, provided: " + data.size());
            return result;
        }
        Heatmap map = data.get(0);
        SpreadSheet sheet = new SpreadSheet();
        HeaderRow row = sheet.getHeaderRow();
        for (x = 0; x < map.getWidth(); ++x) {
            row.addCell("" + x).setContent("x" + (x + 1));
        }
        for (int y = 0; y < map.getHeight(); ++y) {
            row = sheet.addRow();
            for (x = 0; x < map.getWidth(); ++x) {
                row.addCell(x).setContent(Double.valueOf(map.get(y, x)));
            }
        }
        result = this.m_Writer.write(sheet, (File)this.m_Output);
        return result;
    }
}

