/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.transformer.AbstractWekaClassifierEvaluator;
import weka.classifiers.Classifier;

public abstract class AbstractGlobalWekaClassifierEvaluator
extends AbstractWekaClassifierEvaluator {
    private static final long serialVersionUID = 3440872619963043115L;
    protected GlobalActorReference m_Classifier;
    protected boolean m_DiscardPredictions;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new GlobalActorReference(WekaClassifierSetup.class.getSimpleName()));
        this.m_OptionManager.add("no-predictions", "discardPredictions", (Object)false);
    }

    public void setClassifier(GlobalActorReference value) {
        this.m_Classifier = value;
        this.reset();
    }

    public GlobalActorReference getClassifier() {
        return this.m_Classifier;
    }

    public abstract String classifierTipText();

    public void setDiscardPredictions(boolean value) {
        this.m_DiscardPredictions = value;
        this.reset();
    }

    public boolean getDiscardPredictions() {
        return this.m_DiscardPredictions;
    }

    public String discardPredictionsTipText() {
        return "If enabled, the collection of predictions during evaluation is suppressed, wich will conserve memory.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("classifier");
        String result = variable != null ? variable : this.m_Classifier.toString();
        if (this.m_DiscardPredictions) {
            result = result + ", discarding predictions";
        }
        return result;
    }

    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("classifier")) == null && this.m_Classifier.isEmpty()) {
            result = "No classifier specified!";
        }
        return result;
    }

    protected Classifier getClassifierInstance() {
        return (Classifier)GlobalActorHelper.getSetup(Classifier.class, (GlobalActorReference)this.m_Classifier, (AbstractActor)this);
    }
}

