/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.instance.Instance;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractWekaInstanceAndWekaInstancesTransformer;
import java.util.Hashtable;
import weka.core.Instances;
import weka.filters.AllFilter;
import weka.filters.Filter;

public class WekaFilter
extends AbstractWekaInstanceAndWekaInstancesTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 9078845385089445202L;
    public static final String BACKUP_INITIALIZED = "initialized";
    protected Filter m_Filter;
    protected boolean m_InitializeOnce;
    protected boolean m_KeepRelationName;
    protected boolean m_Initialized;

    public String globalInfo() {
        return "Filters Instances/Instance objects using the specified filter.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new AllFilter());
        this.m_OptionManager.add("init-once", "initializeOnce", (Object)false);
        this.m_OptionManager.add("keep", "keepRelationName", (Object)false);
    }

    public void setFilter(Filter value) {
        this.m_Filter = value;
        this.reset();
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use for filtering the Instances/Instance objects.";
    }

    public void setInitializeOnce(boolean value) {
        this.m_InitializeOnce = value;
        this.reset();
    }

    public boolean getInitializeOnce() {
        return this.m_InitializeOnce;
    }

    public String initializeOnceTipText() {
        return "If set to true, then the filter will get initialized only with the first batch of data; otherwise every time data gets passed through.";
    }

    public void setKeepRelationName(boolean value) {
        this.m_KeepRelationName = value;
        this.reset();
    }

    public boolean getKeepRelationName() {
        return this.m_KeepRelationName;
    }

    public String keepRelationNameTipText() {
        return "If set to true, then the filter won't change the relation name of the incoming dataset.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("filter");
        String result = variable != null ? variable : this.m_Filter.getClass().getSimpleName();
        if (this.m_KeepRelationName) {
            result = result + ", keep relation name";
        }
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INITIALIZED);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_INITIALIZED, this.m_Initialized);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INITIALIZED)) {
            this.m_Initialized = (Boolean)state.get(BACKUP_INITIALIZED);
            state.remove(BACKUP_INITIALIZED);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
    }

    protected String doExecute() {
        String result = null;
        Instances data = null;
        weka.core.Instance inst = null;
        if (this.m_InputToken.getPayload() instanceof weka.core.Instance) {
            inst = (weka.core.Instance)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof Instance) {
            inst = ((Instance)((Object)this.m_InputToken.getPayload())).toInstance();
        } else if (this.m_InputToken.getPayload() instanceof Instances) {
            data = (Instances)this.m_InputToken.getPayload();
        } else {
            result = "Unhandled data type: " + this.m_InputToken.getPayload().getClass().getName();
        }
        if (result == null) {
            try {
                if (this.m_InitializeOnce && !this.m_Initialized || !this.m_InitializeOnce) {
                    if (data == null) {
                        data = new Instances(inst.dataset(), 0);
                        data.add(inst);
                    }
                    this.m_Filter.setInputFormat(new Instances(data, 0));
                }
                Instances filteredData = null;
                weka.core.Instance filteredInst = null;
                if (data != null) {
                    String relation = data.relationName();
                    filteredData = Filter.useFilter((Instances)data, (Filter)this.m_Filter);
                    if (this.m_KeepRelationName) {
                        filteredData.setRelationName(relation);
                    }
                    this.m_Initialized = true;
                } else {
                    String relation = inst.dataset().relationName();
                    this.m_Filter.input(inst);
                    this.m_Filter.batchFinished();
                    filteredInst = this.m_Filter.output();
                    if (this.m_KeepRelationName) {
                        filteredInst.dataset().setRelationName(relation);
                    }
                }
                if (inst != null) {
                    if (filteredInst != null) {
                        if (this.m_InputToken.getPayload() instanceof weka.core.Instance) {
                            this.m_OutputToken = new Token((Object)filteredInst);
                        } else {
                            Instance instA = new Instance();
                            instA.set(filteredInst);
                            this.m_OutputToken = new Token((Object)instA);
                        }
                    } else if (filteredData != null && filteredData.numInstances() > 0) {
                        this.m_OutputToken = new Token((Object)filteredData.instance(0));
                    }
                } else {
                    this.m_OutputToken = new Token((Object)filteredData);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to filter data: ", e);
            }
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

