/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.flow.container.WekaTrainTestSetContainer;
import weka.classifiers.AbstractSplitGenerator;
import weka.core.Instances;

public class RandomSplitGenerator
extends AbstractSplitGenerator {
    private static final long serialVersionUID = -4813006743965500489L;
    protected double m_Percentage;
    protected boolean m_PreserveOrder;
    protected boolean m_Generated;

    public RandomSplitGenerator(Instances data, long seed, double percentage) {
        super(data, seed);
        this.m_Percentage = percentage;
        this.m_PreserveOrder = false;
    }

    public RandomSplitGenerator(Instances data, double percentage) {
        super(data, -1L);
        this.m_Percentage = percentage;
        this.m_PreserveOrder = true;
    }

    @Override
    protected boolean canRandomize() {
        return !this.m_PreserveOrder;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Generated = false;
    }

    @Override
    protected boolean checkNext() {
        return !this.m_Generated;
    }

    @Override
    protected WekaTrainTestSetContainer createNext() {
        this.m_Generated = true;
        int trainSize = (int)Math.round((double)this.m_Data.numInstances() * this.m_Percentage);
        int testSize = this.m_Data.numInstances() - trainSize;
        Instances trainSet = new Instances(this.m_Data, 0, trainSize);
        Instances testSet = new Instances(this.m_Data, trainSize, testSize);
        WekaTrainTestSetContainer result = new WekaTrainTestSetContainer(trainSet, testSet, this.m_Seed);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ", percentage=" + this.m_Percentage;
    }
}

