/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.BasicParseError;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.support.ParsingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLocatingParseRunner<V>
extends AbstractParseRunner<V>
implements MatchHandler {
    private final MatchHandler inner;
    private int errorIndex;

    public ErrorLocatingParseRunner(Rule rule) {
        this(rule, null);
    }

    public ErrorLocatingParseRunner(Rule rule, MatchHandler inner) {
        super(rule);
        this.inner = inner;
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        this.resetValueStack();
        this.errorIndex = 0;
        MatcherContext rootContext = this.createRootContext(inputBuffer, this, false);
        boolean matched = this.match(rootContext);
        if (!matched) {
            this.getParseErrors().add(new BasicParseError(inputBuffer, this.errorIndex, null));
        }
        return this.createParsingResult(matched, rootContext);
    }

    @Override
    public boolean match(MatcherContext<?> context) {
        if (this.inner == null && context.getMatcher().match(context) || this.inner != null && this.inner.match(context)) {
            if (this.errorIndex < context.getCurrentIndex() && this.notTestNot(context)) {
                this.errorIndex = context.getCurrentIndex();
            }
            return true;
        }
        return false;
    }

    private boolean notTestNot(MatcherContext context) {
        return !(context.getMatcher() instanceof TestNotMatcher) && (context.getParent() == null || this.notTestNot((MatcherContext)context.getParent()));
    }
}

