/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import org.parboiled.common.Preconditions;

public final class IndexRange {
    public static final IndexRange EMPTY = new IndexRange(0, 0);
    public final int start;
    public final int end;

    public IndexRange(int start, int end) {
        Preconditions.checkArgument(start >= 0, "start must be >= 0");
        Preconditions.checkArgument(end >= start, "end must be >= start");
        this.start = start;
        this.end = end;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean overlapsWith(IndexRange other) {
        Preconditions.checkArgNotNull(other, "other");
        return this.end > other.start && other.end > this.start;
    }

    public boolean isPrecededBy(IndexRange other) {
        Preconditions.checkArgNotNull(other, "other");
        return other.end == this.start;
    }

    public boolean isFollowedBy(IndexRange other) {
        Preconditions.checkArgNotNull(other, "other");
        return this.end == other.start;
    }

    public boolean touches(IndexRange other) {
        Preconditions.checkArgNotNull(other, "other");
        return other.end == this.start || this.end == other.start;
    }

    public IndexRange mergedWith(IndexRange other) {
        Preconditions.checkArgNotNull(other, "other");
        return new IndexRange(Math.min(this.start, other.start), Math.max(this.end, other.end));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexRange)) {
            return false;
        }
        IndexRange that = (IndexRange)o;
        return this.end == that.end && this.start == that.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        return "IndexRange{start=" + this.start + ", end=" + this.end + '}';
    }
}

