/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.data.io.output.AbstractSpreadSheetWriterWithMissingValueSupport;
import adams.data.io.output.SpreadSheetWriterWithFormulaSupport;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.OutputStream;
import java.util.Date;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ODFSpreadSheetWriter
extends AbstractSpreadSheetWriterWithMissingValueSupport
implements SpreadSheetWriterWithFormulaSupport {
    private static final long serialVersionUID = -3549185519778801930L;
    public static String FILE_EXTENSION = ".ods";
    protected boolean m_OutputAsDisplayed;

    public String globalInfo() {
        return "Writes ODF (Open Document Format) spreadsheet files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-as-displayed", "outputAsDisplayed", (Object)false);
    }

    public String getFormatDescription() {
        return "OpenDocument format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"ods"};
    }

    protected boolean getUseOutputStream() {
        return true;
    }

    public void setOutputAsDisplayed(boolean value) {
        this.m_OutputAsDisplayed = value;
        this.reset();
    }

    public boolean getOutputAsDisplayed() {
        return this.m_OutputAsDisplayed;
    }

    public String outputAsDisplayedTipText() {
        return "If enabled, cells are output as displayed, ie, results of formulas instead of the formulas.";
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        boolean result = true;
        try {
            int i;
            DateFormat dformat = DateUtils.getTimestampFormatter();
            Object[] colNames = new String[content.getColumnCount()];
            HeaderRow row = content.getHeaderRow();
            for (i = 0; i < content.getColumnCount(); ++i) {
                colNames[i] = row.getCell(i) == null || row.getCell(i).isMissing() ? this.m_MissingValue : row.getCell(i).getContent().toString();
            }
            DefaultTableModel model = new DefaultTableModel(colNames, content.getRowCount());
            for (int n = 0; n < content.getRowCount(); ++n) {
                row = content.getRow(n);
                for (i = 0; i < content.getColumnCount(); ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null || cell.isMissing()) {
                        model.setValueAt(this.m_MissingValue, n, i);
                        continue;
                    }
                    if (cell.isFormula() && !this.m_OutputAsDisplayed) {
                        model.setValueAt(cell.getFormula(), n, i);
                        continue;
                    }
                    if (cell.isDate()) {
                        model.setValueAt(dformat.format(cell.toDate()), n, i);
                        continue;
                    }
                    if (cell.isTime()) {
                        model.setValueAt(dformat.format((Date)cell.toTime()), n, i);
                        continue;
                    }
                    if (cell.isDateTime()) {
                        model.setValueAt(dformat.format((Date)cell.toDateTime()), n, i);
                        continue;
                    }
                    model.setValueAt(cell.getContent().toString(), n, i);
                }
            }
            org.jopendocument.dom.spreadsheet.SpreadSheet spreadsheet = org.jopendocument.dom.spreadsheet.SpreadSheet.createEmpty((TableModel)model);
            spreadsheet.getPackage().save(out);
        }
        catch (Exception e) {
            result = false;
            this.getSystemErr().printStackTrace("Failed writing spreadsheet data", (Throwable)e);
        }
        return result;
    }
}

