/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Index;
import adams.data.io.input.ODFSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.previewbrowser.AbstractSpreadSheetHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.jopendocument.dom.ODPackage;

public class ODFSpreadSheetHandler
extends AbstractSpreadSheetHandler {
    private static final long serialVersionUID = -57718234789783854L;

    public String[] getExtensions() {
        return new String[]{"ods"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSheetCount(File file) {
        int result;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            org.jopendocument.dom.spreadsheet.SpreadSheet spreadsheet = org.jopendocument.dom.spreadsheet.SpreadSheet.get((ODPackage)new ODPackage((InputStream)input));
            result = spreadsheet.getSheetCount();
        }
        catch (Exception e) {
            result = 0;
            this.getSystemErr().println("Failed to determine sheet count for '" + file + "':");
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    protected SpreadSheet[] readAll(File file) {
        Vector<SpreadSheet> result = new Vector<SpreadSheet>();
        int count = this.getSheetCount(file);
        ODFSpreadSheetReader reader = new ODFSpreadSheetReader();
        for (int i = 0; i < count; ++i) {
            reader.setSheetIndex(new Index("" + (i + 1)));
            SpreadSheet sheet = reader.read(file);
            if (sheet == null) continue;
            result.add(sheet);
        }
        return result.toArray(new SpreadSheet[result.size()]);
    }
}

