/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import moa.DoTask;
import moa.gui.AbstractTabPanel;
import moa.gui.GUIDefaults;

public class GUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane panel;

    public GUI() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.panel = new JTabbedPane();
        this.add((Component)this.panel, "Center");
        String[] tabs = GUIDefaults.getTabs();
        for (int i = 0; i < tabs.length; ++i) {
            try {
                String[] optionsStr = tabs[i].split(":");
                String classname = optionsStr[0];
                AbstractTabPanel tabPanel = (AbstractTabPanel)Class.forName(classname).newInstance();
                this.panel.addTab(tabPanel.getTabTitle(), null, tabPanel, tabPanel.getDescription());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (!DoTask.isJavaVersionOK() || !DoTask.isWekaVersionOK()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = new JFrame("MOA Graphical User Interface");
                    frame.setDefaultCloseOperation(3);
                    try {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    GUI gui = new GUI();
                    frame.getContentPane().setLayout(new BorderLayout());
                    frame.getContentPane().add(gui);
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

